/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hwpf.model.FSPA;
import org.apache.poi.hwpf.model.FSPADocumentPart;
import org.apache.poi.hwpf.model.FileInformationBlock;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PlexOfCps;

public final class FSPATable {
    private final Map _byStart = new LinkedHashMap();

    public FSPATable(byte[] tableStream, FileInformationBlock fib, FSPADocumentPart part) {
        int offset = fib.getFSPAPlcfOffset(part);
        int length = fib.getFSPAPlcfLength(part);
        PlexOfCps plex = new PlexOfCps(tableStream, offset, length, FSPA.getSize());
        int i = 0;
        while (i < plex.length()) {
            GenericPropertyNode property = plex.getProperty(i);
            this._byStart.put(new Integer(property.getStart()), property);
            ++i;
        }
    }

    public FSPATable(byte[] tableStream, int fcPlcspa, int lcbPlcspa, List tpt) {
        if (fcPlcspa == 0) {
            return;
        }
        PlexOfCps plex = new PlexOfCps(tableStream, fcPlcspa, lcbPlcspa, FSPA.FSPA_SIZE);
        int i = 0;
        while (i < plex.length()) {
            GenericPropertyNode property = plex.getProperty(i);
            this._byStart.put(new Integer(property.getStart()), property);
            ++i;
        }
    }

    public FSPA getFspaFromCp(int cp) {
        GenericPropertyNode propertyNode = (GenericPropertyNode)this._byStart.get(new Integer(cp));
        if (propertyNode == null) {
            return null;
        }
        return new FSPA(propertyNode.getBytes(), 0);
    }

    public FSPA[] getShapes() {
        ArrayList<FSPA> result = new ArrayList<FSPA>(this._byStart.size());
        Iterator iterator = this._byStart.values().iterator();
        while (iterator.hasNext()) {
            GenericPropertyNode propertyNode = (GenericPropertyNode)iterator.next();
            result.add(new FSPA(propertyNode.getBytes(), 0));
        }
        return result.toArray(new FSPA[result.size()]);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[FPSA PLC size=").append(this._byStart.size()).append("]\n");
        Iterator iterator = this._byStart.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Integer i = (Integer)entry.getKey();
            buf.append("  ").append(i.toString()).append(" => \t");
            try {
                FSPA fspa = this.getFspaFromCp(i);
                buf.append(fspa.toString());
            }
            catch (Exception exc) {
                buf.append(exc.getMessage());
            }
            buf.append("\n");
        }
        buf.append("[/FSPA PLC]");
        return buf.toString();
    }
}

