/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.converter;

import java.io.File;
import java.io.FileWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.AbstractWordConverter;
import org.apache.poi.hwpf.converter.FontReplacer;
import org.apache.poi.hwpf.converter.HtmlDocumentFacade;
import org.apache.poi.hwpf.converter.WordToHtmlUtils;
import org.apache.poi.hwpf.usermodel.Bookmark;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.OfficeDrawing;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Picture;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.hwpf.usermodel.Section;
import org.apache.poi.hwpf.usermodel.Table;
import org.apache.poi.hwpf.usermodel.TableCell;
import org.apache.poi.hwpf.usermodel.TableRow;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import poi.support.NodeUtil;

public class WordToHtmlConverter
extends AbstractWordConverter {
    private static final POILogger logger;
    private final Stack blocksProperies = new Stack();
    private final HtmlDocumentFacade htmlDocumentFacade;
    private Element notes = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.hwpf.converter.WordToHtmlConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = POILogFactory.getLogger((Class)clazz);
    }

    private static String getSectionStyle(Section section) {
        float leftMargin = (float)section.getMarginLeft() / 1440.0f;
        float rightMargin = (float)section.getMarginRight() / 1440.0f;
        float topMargin = (float)section.getMarginTop() / 1440.0f;
        float bottomMargin = (float)section.getMarginBottom() / 1440.0f;
        String style = "margin: " + topMargin + "in " + rightMargin + "in " + bottomMargin + "in " + leftMargin + "in;";
        if (section.getNumColumns() > 1) {
            style = String.valueOf(style) + "column-count: " + section.getNumColumns() + ";";
            if (section.isColumnsEvenlySpaced()) {
                float distance = (float)section.getDistanceBetweenColumns() / 1440.0f;
                style = String.valueOf(style) + "column-gap: " + distance + "in;";
            } else {
                style = String.valueOf(style) + "column-gap: 0.25in;";
            }
        }
        return style;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: WordToHtmlConverter <inputFile.doc> <saveTo.html>");
            return;
        }
        System.out.println("Converting " + args[0]);
        System.out.println("Saving output to " + args[1]);
        try {
            Document doc = WordToHtmlConverter.process(new File(args[0]));
            FileWriter out = new FileWriter(args[1]);
            DOMSource domSource = new DOMSource(doc);
            StreamResult streamResult = new StreamResult(out);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("method", "html");
            serializer.transform(domSource, streamResult);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static Document process(File docFile) throws Exception {
        HWPFDocumentCore wordDocument = WordToHtmlUtils.loadDoc(docFile);
        WordToHtmlConverter wordToHtmlConverter = new WordToHtmlConverter(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
        wordToHtmlConverter.processDocument(wordDocument);
        return wordToHtmlConverter.getDocument();
    }

    public WordToHtmlConverter(Document document) {
        this.htmlDocumentFacade = new HtmlDocumentFacade(document);
    }

    public WordToHtmlConverter(HtmlDocumentFacade htmlDocumentFacade) {
        this.htmlDocumentFacade = htmlDocumentFacade;
    }

    protected void afterProcess() {
        if (this.notes != null) {
            this.htmlDocumentFacade.getBody().appendChild(this.notes);
        }
        this.htmlDocumentFacade.updateStylesheet();
    }

    public Document getDocument() {
        return this.htmlDocumentFacade.getDocument();
    }

    protected void outputCharacters(Element pElement, CharacterRun characterRun, String text) {
        Element span = this.htmlDocumentFacade.document.createElement("span");
        pElement.appendChild(span);
        StringBuffer style = new StringBuffer();
        BlockProperies blockProperies = (BlockProperies)this.blocksProperies.peek();
        FontReplacer.Triplet triplet = this.getCharacterRunTriplet(characterRun);
        if (WordToHtmlUtils.isNotEmpty(triplet.fontName) && !WordToHtmlUtils.equals(triplet.fontName, blockProperies.pFontName)) {
            style.append("font-family:" + triplet.fontName + ";");
        }
        if (characterRun.getFontSize() / 2 != blockProperies.pFontSize) {
            style.append("font-size:" + characterRun.getFontSize() / 2 + "pt;");
        }
        if (triplet.bold) {
            style.append("font-weight:bold;");
        }
        if (triplet.italic) {
            style.append("font-style:italic;");
        }
        WordToHtmlUtils.addCharactersProperties(characterRun, style);
        if (style.length() != 0) {
            this.htmlDocumentFacade.addStyleClass(span, "s", style.toString());
        }
        Text textNode = this.htmlDocumentFacade.createText(text);
        span.appendChild(textNode);
    }

    protected void processBookmarks(HWPFDocumentCore wordDocument, Element currentBlock, Range range, int currentTableLevel, List rangeBookmarks) {
        Element parent = currentBlock;
        Iterator iterator = rangeBookmarks.iterator();
        while (iterator.hasNext()) {
            Bookmark bookmark = (Bookmark)iterator.next();
            Element bookmarkElement = this.htmlDocumentFacade.createBookmark(bookmark.getName());
            parent.appendChild(bookmarkElement);
            parent = bookmarkElement;
        }
        if (range != null) {
            this.processCharacters(wordDocument, currentTableLevel, range, parent);
        }
    }

    protected void processDocumentInformation(SummaryInformation summaryInformation) {
        if (WordToHtmlUtils.isNotEmpty(summaryInformation.getTitle())) {
            this.htmlDocumentFacade.setTitle(summaryInformation.getTitle());
        }
        if (WordToHtmlUtils.isNotEmpty(summaryInformation.getAuthor())) {
            this.htmlDocumentFacade.addAuthor(summaryInformation.getAuthor());
        }
        if (WordToHtmlUtils.isNotEmpty(summaryInformation.getKeywords())) {
            this.htmlDocumentFacade.addKeywords(summaryInformation.getKeywords());
        }
        if (WordToHtmlUtils.isNotEmpty(summaryInformation.getComments())) {
            this.htmlDocumentFacade.addDescription(summaryInformation.getComments());
        }
    }

    public void processDocumentPart(HWPFDocumentCore wordDocument, Range range) {
        super.processDocumentPart(wordDocument, range);
        this.afterProcess();
    }

    protected void processDrawnObject(HWPFDocument doc, CharacterRun characterRun, OfficeDrawing officeDrawing, String path, Element block) {
        Element img = this.htmlDocumentFacade.createImage(path);
        block.appendChild(img);
    }

    protected void processEndnoteAutonumbered(HWPFDocument wordDocument, int noteIndex, Element block, Range endnoteTextRange) {
        this.processNoteAutonumbered(wordDocument, "end", noteIndex, block, endnoteTextRange);
    }

    protected void processFootnoteAutonumbered(HWPFDocument wordDocument, int noteIndex, Element block, Range footnoteTextRange) {
        this.processNoteAutonumbered(wordDocument, "foot", noteIndex, block, footnoteTextRange);
    }

    protected void processHyperlink(HWPFDocumentCore wordDocument, Element currentBlock, Range textRange, int currentTableLevel, String hyperlink) {
        Element basicLink = this.htmlDocumentFacade.createHyperlink(hyperlink);
        currentBlock.appendChild(basicLink);
        if (textRange != null) {
            this.processCharacters(wordDocument, currentTableLevel, textRange, basicLink);
        }
    }

    protected void processImage(Element currentBlock, boolean inlined, Picture picture, String imageSourcePath) {
        Element root;
        float cropBottom;
        float cropTop;
        float imageHeight;
        float cropLeft;
        float cropRight;
        float imageWidth;
        int aspectRatioX = picture.getHorizontalScalingFactor();
        int aspectRatioY = picture.getVerticalScalingFactor();
        StringBuffer style = new StringBuffer();
        if (aspectRatioX > 0) {
            imageWidth = (float)(picture.getDxaGoal() * aspectRatioX / 1000) / 1440.0f;
            cropRight = (float)(picture.getDxaCropRight() * aspectRatioX / 1000) / 1440.0f;
            cropLeft = (float)(picture.getDxaCropLeft() * aspectRatioX / 1000) / 1440.0f;
        } else {
            imageWidth = (float)picture.getDxaGoal() / 1440.0f;
            cropRight = (float)picture.getDxaCropRight() / 1440.0f;
            cropLeft = (float)picture.getDxaCropLeft() / 1440.0f;
        }
        if (aspectRatioY > 0) {
            imageHeight = (float)(picture.getDyaGoal() * aspectRatioY / 1000) / 1440.0f;
            cropTop = (float)(picture.getDyaCropTop() * aspectRatioY / 1000) / 1440.0f;
            cropBottom = (float)(picture.getDyaCropBottom() * aspectRatioY / 1000) / 1440.0f;
        } else {
            imageHeight = (float)picture.getDyaGoal() / 1440.0f;
            cropTop = (float)picture.getDyaCropTop() / 1440.0f;
            cropBottom = (float)picture.getDyaCropBottom() / 1440.0f;
        }
        if (cropTop != 0.0f || cropRight != 0.0f || cropBottom != 0.0f || cropLeft != 0.0f) {
            float visibleWidth = Math.max(0.0f, imageWidth - cropLeft - cropRight);
            float visibleHeight = Math.max(0.0f, imageHeight - cropTop - cropBottom);
            root = this.htmlDocumentFacade.createBlock();
            this.htmlDocumentFacade.addStyleClass(root, "d", "vertical-align:text-bottom;width:" + visibleWidth + "in;height:" + visibleHeight + "in;");
            Element inner = this.htmlDocumentFacade.createBlock();
            this.htmlDocumentFacade.addStyleClass(inner, "d", "position:relative;width:" + visibleWidth + "in;height:" + visibleHeight + "in;overflow:hidden;");
            root.appendChild(inner);
            Element image = this.htmlDocumentFacade.createImage(imageSourcePath);
            this.htmlDocumentFacade.addStyleClass(image, "i", "position:absolute;left:-" + cropLeft + ";top:-" + cropTop + ";width:" + imageWidth + "in;height:" + imageHeight + "in;");
            inner.appendChild(image);
            style.append("overflow:hidden;");
        } else {
            root = this.htmlDocumentFacade.createImage(imageSourcePath);
            root.setAttribute("style", "width:" + imageWidth + "in;height:" + imageHeight + "in;vertical-align:text-bottom;");
        }
        currentBlock.appendChild(root);
    }

    protected void processImageWithoutPicturesManager(Element currentBlock, boolean inlined, Picture picture) {
        currentBlock.appendChild(this.htmlDocumentFacade.document.createComment("Image link to '" + picture.suggestFullFileName() + "' can be here"));
    }

    protected void processLineBreak(Element block, CharacterRun characterRun) {
        block.appendChild(this.htmlDocumentFacade.createLineBreak());
    }

    protected void processNoteAutonumbered(HWPFDocument doc, String type, int noteIndex, Element block, Range noteTextRange) {
        String textIndex = String.valueOf(noteIndex + 1);
        String textIndexClass = this.htmlDocumentFacade.getOrCreateCssClass("a", "vertical-align:super;font-size:smaller;");
        String forwardNoteLink = String.valueOf(type) + "note_" + textIndex;
        String backwardNoteLink = String.valueOf(type) + "note_back_" + textIndex;
        Element anchor = this.htmlDocumentFacade.createHyperlink("#" + forwardNoteLink);
        anchor.setAttribute("name", backwardNoteLink);
        anchor.setAttribute("class", String.valueOf(textIndexClass) + " " + type + "noteanchor");
        NodeUtil.setTextContent(anchor, textIndex);
        block.appendChild(anchor);
        if (this.notes == null) {
            this.notes = this.htmlDocumentFacade.createBlock();
            this.notes.setAttribute("class", "notes");
        }
        Element note = this.htmlDocumentFacade.createBlock();
        note.setAttribute("class", String.valueOf(type) + "note");
        this.notes.appendChild(note);
        Element bookmark = this.htmlDocumentFacade.createBookmark(forwardNoteLink);
        bookmark.setAttribute("href", "#" + backwardNoteLink);
        NodeUtil.setTextContent(bookmark, textIndex);
        bookmark.setAttribute("class", String.valueOf(textIndexClass) + " " + type + "noteindex");
        note.appendChild(bookmark);
        note.appendChild(this.htmlDocumentFacade.createText(" "));
        Element span = this.htmlDocumentFacade.getDocument().createElement("span");
        span.setAttribute("class", String.valueOf(type) + "notetext");
        note.appendChild(span);
        this.blocksProperies.add(new BlockProperies("", -1));
        try {
            this.processCharacters(doc, Integer.MIN_VALUE, noteTextRange, span);
        }
        finally {
            this.blocksProperies.pop();
        }
    }

    protected void processPageBreak(HWPFDocumentCore wordDocument, Element flow) {
        flow.appendChild(this.htmlDocumentFacade.createLineBreak());
    }

    protected void processPageref(HWPFDocumentCore hwpfDocument, Element currentBlock, Range textRange, int currentTableLevel, String pageref) {
        Element basicLink = this.htmlDocumentFacade.createHyperlink("#" + pageref);
        currentBlock.appendChild(basicLink);
        if (textRange != null) {
            this.processCharacters(hwpfDocument, currentTableLevel, textRange, basicLink);
        }
    }

    protected void processParagraph(HWPFDocumentCore hwpfDocument, Element parentElement, int currentTableLevel, Paragraph paragraph, String bulletText) {
        String pFontName;
        int pFontSize;
        Element pElement = this.htmlDocumentFacade.createParagraph();
        parentElement.appendChild(pElement);
        StringBuffer style = new StringBuffer();
        WordToHtmlUtils.addParagraphProperties(paragraph, style);
        int charRuns = paragraph.numCharacterRuns();
        if (charRuns == 0) {
            return;
        }
        CharacterRun characterRun = paragraph.getCharacterRun(0);
        if (characterRun != null) {
            FontReplacer.Triplet triplet = this.getCharacterRunTriplet(characterRun);
            pFontSize = characterRun.getFontSize() / 2;
            pFontName = triplet.fontName;
            WordToHtmlUtils.addFontFamily(pFontName, style);
            WordToHtmlUtils.addFontSize(pFontSize, style);
        } else {
            pFontSize = -1;
            pFontName = "";
        }
        this.blocksProperies.push(new BlockProperies(pFontName, pFontSize));
        try {
            if (WordToHtmlUtils.isNotEmpty(bulletText)) {
                if (bulletText.endsWith("\t")) {
                    float defaultTab = 720.0f;
                    float firstLinePosition = paragraph.getIndentFromLeft() + paragraph.getFirstLineIndent() + 20;
                    float nextStop = (float)(Math.ceil(firstLinePosition / 720.0f) * 720.0);
                    float spanMinWidth = nextStop - firstLinePosition;
                    Element span = this.htmlDocumentFacade.getDocument().createElement("span");
                    this.htmlDocumentFacade.addStyleClass(span, "s", "display: inline-block; text-indent: 0; min-width: " + spanMinWidth / 1440.0f + "in;");
                    pElement.appendChild(span);
                    Text textNode = this.htmlDocumentFacade.createText(String.valueOf(bulletText.substring(0, bulletText.length() - 1)) + '\u200b' + '\u00a0');
                    span.appendChild(textNode);
                } else {
                    Text textNode = this.htmlDocumentFacade.createText(bulletText.substring(0, bulletText.length() - 1));
                    pElement.appendChild(textNode);
                }
            }
            this.processCharacters(hwpfDocument, currentTableLevel, paragraph, pElement);
        }
        finally {
            this.blocksProperies.pop();
        }
        if (style.length() > 0) {
            this.htmlDocumentFacade.addStyleClass(pElement, "p", style.toString());
        }
        WordToHtmlUtils.compactSpans(pElement);
    }

    protected void processSection(HWPFDocumentCore wordDocument, Section section, int sectionCounter) {
        Element div = this.htmlDocumentFacade.createBlock();
        this.htmlDocumentFacade.addStyleClass(div, "d", WordToHtmlConverter.getSectionStyle(section));
        this.htmlDocumentFacade.body.appendChild(div);
        this.processParagraphes(wordDocument, div, section, Integer.MIN_VALUE);
    }

    protected void processSingleSection(HWPFDocumentCore wordDocument, Section section) {
        this.htmlDocumentFacade.addStyleClass(this.htmlDocumentFacade.body, "b", WordToHtmlConverter.getSectionStyle(section));
        this.processParagraphes(wordDocument, this.htmlDocumentFacade.body, section, Integer.MIN_VALUE);
    }

    protected void processTable(HWPFDocumentCore hwpfDocument, Element flow, Table table) {
        Element tableHeader = this.htmlDocumentFacade.createTableHeader();
        Element tableBody = this.htmlDocumentFacade.createTableBody();
        int[] tableCellEdges = WordToHtmlUtils.buildTableCellEdgesArray(table);
        int tableRows = table.numRows();
        int maxColumns = Integer.MIN_VALUE;
        int r = 0;
        while (r < tableRows) {
            maxColumns = Math.max(maxColumns, table.getRow(r).numCells());
            ++r;
        }
        r = 0;
        while (r < tableRows) {
            TableRow tableRow = table.getRow(r);
            Element tableRowElement = this.htmlDocumentFacade.createTableRow();
            StringBuffer tableRowStyle = new StringBuffer();
            WordToHtmlUtils.addTableRowProperties(tableRow, tableRowStyle);
            int currentEdgeIndex = 0;
            int rowCells = tableRow.numCells();
            int c = 0;
            while (c < rowCells) {
                TableCell tableCell = tableRow.getCell(c);
                if (tableCell.isVerticallyMerged() && !tableCell.isFirstVerticallyMerged()) {
                    currentEdgeIndex += this.getNumberColumnsSpanned(tableCellEdges, currentEdgeIndex, tableCell);
                } else {
                    Element tableCellElement = tableRow.isTableHeader() ? this.htmlDocumentFacade.createTableHeaderCell() : this.htmlDocumentFacade.createTableCell();
                    StringBuffer tableCellStyle = new StringBuffer();
                    WordToHtmlUtils.addTableCellProperties(tableRow, tableCell, r == 0, r == tableRows - 1, c == 0, c == rowCells - 1, tableCellStyle);
                    int colSpan = this.getNumberColumnsSpanned(tableCellEdges, currentEdgeIndex, tableCell);
                    currentEdgeIndex += colSpan;
                    if (colSpan != 0) {
                        int rowSpan;
                        if (colSpan != 1) {
                            tableCellElement.setAttribute("colspan", String.valueOf(colSpan));
                        }
                        if ((rowSpan = this.getNumberRowsSpanned(table, tableCellEdges, r, c, tableCell)) > 1) {
                            tableCellElement.setAttribute("rowspan", String.valueOf(rowSpan));
                        }
                        this.processParagraphes(hwpfDocument, tableCellElement, tableCell, table.getTableLevel());
                        if (!tableCellElement.hasChildNodes()) {
                            tableCellElement.appendChild(this.htmlDocumentFacade.createParagraph());
                        }
                        if (tableCellStyle.length() > 0) {
                            this.htmlDocumentFacade.addStyleClass(tableCellElement, tableCellElement.getTagName(), tableCellStyle.toString());
                        }
                        tableRowElement.appendChild(tableCellElement);
                    }
                }
                ++c;
            }
            if (tableRowStyle.length() > 0) {
                tableRowElement.setAttribute("class", this.htmlDocumentFacade.getOrCreateCssClass("r", tableRowStyle.toString()));
            }
            if (tableRow.isTableHeader()) {
                tableHeader.appendChild(tableRowElement);
            } else {
                tableBody.appendChild(tableRowElement);
            }
            ++r;
        }
        Element tableElement = this.htmlDocumentFacade.createTable();
        tableElement.setAttribute("class", this.htmlDocumentFacade.getOrCreateCssClass("t", "table-layout:fixed;border-collapse:collapse;border-spacing:0;"));
        if (tableHeader.hasChildNodes()) {
            tableElement.appendChild(tableHeader);
        }
        if (tableBody.hasChildNodes()) {
            tableElement.appendChild(tableBody);
            flow.appendChild(tableElement);
        } else {
            logger.log(POILogger.WARN, (Object)"Table without body starting at [", (Object)new Integer(table.getStartOffset()), (Object)"; ", (Object)new Integer(table.getEndOffset()), (Object)")");
        }
    }

    private static class BlockProperies {
        final String pFontName;
        final int pFontSize;

        public BlockProperies(String pFontName, int pFontSize) {
            this.pFontName = pFontName;
            this.pFontSize = pFontSize;
        }
    }
}

