/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.model;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.poi.xwpf.model.XWPFParagraphDecorator;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;

public class XWPFHyperlinkDecorator
extends XWPFParagraphDecorator {
    private StringBuffer hyperlinkText = new StringBuffer();

    public XWPFHyperlinkDecorator(XWPFParagraphDecorator nextDecorator, boolean outputHyperlinkUrls) {
        this(nextDecorator.paragraph, nextDecorator, outputHyperlinkUrls);
    }

    public XWPFHyperlinkDecorator(XWPFParagraph prgrph, XWPFParagraphDecorator nextDecorator, boolean outputHyperlinkUrls) {
        super(prgrph, nextDecorator);
        Iterator<CTHyperlink> iterator = Arrays.asList(this.paragraph.getCTP().getHyperlinkArray()).iterator();
        while (iterator.hasNext()) {
            CTHyperlink link = iterator.next();
            Iterator<CTR> iterator2 = Arrays.asList(link.getRArray()).iterator();
            while (iterator2.hasNext()) {
                CTR r = iterator2.next();
                Iterator<CTText> iterator3 = Arrays.asList(r.getTArray()).iterator();
                while (iterator3.hasNext()) {
                    CTText text = iterator3.next();
                    this.hyperlinkText.append(text.getStringValue());
                }
            }
            if (!outputHyperlinkUrls || this.paragraph.getDocument().getHyperlinkByID(link.getId()) == null) continue;
            this.hyperlinkText.append(" <" + this.paragraph.getDocument().getHyperlinkByID(link.getId()).getURL() + ">");
        }
    }

    public String getText() {
        return String.valueOf(super.getText()) + this.hyperlinkText;
    }
}

