/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.extensions;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorderPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STBorderStyle;

public class XSSFCellBorder {
    private ThemesTable _theme;
    private CTBorder border;

    public XSSFCellBorder(CTBorder border, ThemesTable theme) {
        this(border);
        this._theme = theme;
    }

    public XSSFCellBorder(CTBorder border) {
        this.border = border;
    }

    public XSSFCellBorder() {
        this.border = CTBorder.Factory.newInstance();
    }

    public void setThemesTable(ThemesTable themes) {
        this._theme = themes;
    }

    public CTBorder getCTBorder() {
        return this.border;
    }

    public BorderStyle getBorderStyle(BorderSide side) {
        CTBorderPr ctBorder = this.getBorder(side);
        STBorderStyle.Enum border = ctBorder == null ? STBorderStyle.NONE : ctBorder.getStyle();
        return BorderStyle.values()[border.intValue() - 1];
    }

    public void setBorderStyle(BorderSide side, BorderStyle style) {
        this.getBorder(side, true).setStyle(STBorderStyle.Enum.forInt((int)(style.ordinal() + 1)));
    }

    public XSSFColor getBorderColor(BorderSide side) {
        CTBorderPr borderPr = this.getBorder(side);
        if (borderPr != null && borderPr.isSetColor()) {
            XSSFColor clr = new XSSFColor(borderPr.getColor());
            if (this._theme != null) {
                this._theme.inheritFromThemeAsRequired(clr);
            }
            return clr;
        }
        return null;
    }

    public void setBorderColor(BorderSide side, XSSFColor color) {
        CTBorderPr borderPr = this.getBorder(side, true);
        if (color == null) {
            borderPr.unsetColor();
        } else {
            borderPr.setColor(color.getCTColor());
        }
    }

    private CTBorderPr getBorder(BorderSide side) {
        return this.getBorder(side, false);
    }

    private CTBorderPr getBorder(BorderSide side, boolean ensure) {
        CTBorderPr borderPr;
        if (BorderSide.TOP.equals(side)) {
            borderPr = this.border.getTop();
            if (ensure && borderPr == null) {
                borderPr = this.border.addNewTop();
            }
        } else if (BorderSide.RIGHT.equals(side)) {
            borderPr = this.border.getRight();
            if (ensure && borderPr == null) {
                borderPr = this.border.addNewRight();
            }
        } else if (BorderSide.BOTTOM.equals(side)) {
            borderPr = this.border.getBottom();
            if (ensure && borderPr == null) {
                borderPr = this.border.addNewBottom();
            }
        } else if (BorderSide.LEFT.equals(side)) {
            borderPr = this.border.getLeft();
            if (ensure && borderPr == null) {
                borderPr = this.border.addNewLeft();
            }
        } else {
            throw new IllegalArgumentException("No suitable side specified for the border");
        }
        return borderPr;
    }

    public int hashCode() {
        return this.border.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof XSSFCellBorder)) {
            return false;
        }
        XSSFCellBorder cf = (XSSFCellBorder)o;
        return this.border.toString().equals(cf.getCTBorder().toString());
    }

    public static class BorderSide {
        public static final BorderSide TOP = new BorderSide(0);
        public static final BorderSide RIGHT = new BorderSide(1);
        public static final BorderSide BOTTOM = new BorderSide(2);
        public static final BorderSide LEFT = new BorderSide(3);
        private int _ordinal;

        public BorderSide(int i) {
            this._ordinal = i;
        }

        public int ordinal() {
            return this._ordinal;
        }

        public static final BorderSide[] values() {
            return new BorderSide[]{TOP, RIGHT, BOTTOM, LEFT};
        }
    }
}

