/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.ss.usermodel.Chart;
import org.apache.poi.ss.usermodel.charts.AxisPosition;
import org.apache.poi.ss.usermodel.charts.ChartAxis;
import org.apache.poi.ss.usermodel.charts.ChartAxisFactory;
import org.apache.poi.ss.usermodel.charts.ChartData;
import org.apache.poi.ss.usermodel.charts.ChartDataFactory;
import org.apache.poi.ss.usermodel.charts.ChartLegend;
import org.apache.poi.ss.usermodel.charts.ManualLayout;
import org.apache.poi.ss.usermodel.charts.ValueAxis;
import org.apache.poi.xssf.usermodel.XSSFGraphicFrame;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.charts.XSSFChartDataFactory;
import org.apache.poi.xssf.usermodel.charts.XSSFChartLegend;
import org.apache.poi.xssf.usermodel.charts.XSSFManualLayout;
import org.apache.poi.xssf.usermodel.charts.XSSFValueAxis;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTChartSpace;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPageMargins;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPrintSettings;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTTitle;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTValAx;
import org.openxmlformats.schemas.drawingml.x2006.chart.ChartSpaceDocument;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class XSSFChart
extends POIXMLDocumentPart
implements Chart,
ChartAxisFactory {
    private XSSFGraphicFrame frame;
    private CTChartSpace chartSpace;
    private CTChart chart;
    List axis;

    protected XSSFChart() {
        this.axis = new ArrayList();
        this.createChart();
    }

    protected XSSFChart(PackagePart part, PackageRelationship rel) throws IOException, XmlException {
        super(part, rel);
        this.chartSpace = ChartSpaceDocument.Factory.parse((InputStream)part.getInputStream()).getChartSpace();
        this.chart = this.chartSpace.getChart();
    }

    private void createChart() {
        this.chartSpace = CTChartSpace.Factory.newInstance();
        this.chart = this.chartSpace.addNewChart();
        CTPlotArea plotArea = this.chart.addNewPlotArea();
        plotArea.addNewLayout();
        this.chart.addNewPlotVisOnly().setVal(true);
        CTPrintSettings printSettings = this.chartSpace.addNewPrintSettings();
        printSettings.addNewHeaderFooter();
        CTPageMargins pageMargins = printSettings.addNewPageMargins();
        pageMargins.setB(0.75);
        pageMargins.setL(0.7);
        pageMargins.setR(0.7);
        pageMargins.setT(0.75);
        pageMargins.setHeader(0.3);
        pageMargins.setFooter(0.3);
        printSettings.addNewPageSetup();
    }

    public CTChartSpace getCTChartSpace() {
        return this.chartSpace;
    }

    public CTChart getCTChart() {
        return this.chart;
    }

    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTChartSpace.type.getName().getNamespaceURI(), "chartSpace", "c"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("http://schemas.openxmlformats.org/drawingml/2006/main", "a");
        map.put("http://schemas.openxmlformats.org/drawingml/2006/chart", "c");
        map.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
        xmlOptions.setSaveSuggestedPrefixes(map);
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.chartSpace.save(out, xmlOptions);
        out.close();
    }

    public XSSFGraphicFrame getGraphicFrame() {
        return this.frame;
    }

    protected void setGraphicFrame(XSSFGraphicFrame frame) {
        this.frame = frame;
    }

    public ChartDataFactory getChartDataFactory() {
        return XSSFChartDataFactory.getInstance();
    }

    public ChartAxisFactory getChartAxisFactory() {
        return this;
    }

    public void plot(ChartData data, ChartAxis[] axis) {
        data.fillChart((Chart)this, axis);
    }

    public ValueAxis createValueAxis(AxisPosition pos) {
        long id = this.axis.size() + 1;
        XSSFValueAxis valueAxis = new XSSFValueAxis(this, id, pos);
        if (this.axis.size() == 1) {
            ChartAxis ax = (ChartAxis)this.axis.get(0);
            ax.crossAxis((ChartAxis)valueAxis);
            valueAxis.crossAxis(ax);
        }
        this.axis.add(valueAxis);
        return valueAxis;
    }

    public List getAxis() {
        if (this.axis.isEmpty() && this.hasAxis()) {
            this.parseAxis();
        }
        return this.axis;
    }

    public ManualLayout getManualLayout() {
        return new XSSFManualLayout(this);
    }

    public boolean isPlotOnlyVisibleCells() {
        return this.chart.getPlotVisOnly().getVal();
    }

    public void setPlotOnlyVisibleCells(boolean plotVisOnly) {
        this.chart.getPlotVisOnly().setVal(plotVisOnly);
    }

    public XSSFRichTextString getTitle() {
        if (!this.chart.isSetTitle()) {
            return null;
        }
        CTTitle title = this.chart.getTitle();
        StringBuffer text = new StringBuffer();
        XmlObject[] t = title.selectPath("declare namespace a='http://schemas.openxmlformats.org/drawingml/2006/main' .//a:t");
        int m = 0;
        while (m < t.length) {
            NodeList kids = t[m].getDomNode().getChildNodes();
            int n = 0;
            while (n < kids.getLength()) {
                if (kids.item(n) instanceof Text) {
                    text.append(kids.item(n).getNodeValue());
                }
                ++n;
            }
            ++m;
        }
        return new XSSFRichTextString(text.toString());
    }

    public ChartLegend getOrCreateLegend() {
        return new XSSFChartLegend(this);
    }

    public void deleteLegend() {
        if (this.chart.isSetLegend()) {
            this.chart.unsetLegend();
        }
    }

    private boolean hasAxis() {
        CTPlotArea ctPlotArea = this.chart.getPlotArea();
        int totalAxisCount = ctPlotArea.sizeOfValAxArray() + ctPlotArea.sizeOfCatAxArray() + ctPlotArea.sizeOfDateAxArray() + ctPlotArea.sizeOfSerAxArray();
        return totalAxisCount > 0;
    }

    private void parseAxis() {
        this.parseValueAxis();
    }

    private void parseValueAxis() {
        Iterator<CTValAx> iterator = Arrays.asList(this.chart.getPlotArea().getValAxArray()).iterator();
        while (iterator.hasNext()) {
            CTValAx valAx = iterator.next();
            this.axis.add(new XSSFValueAxis(this, valAx));
        }
    }
}

