/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.AbstractWordUtils;
import org.apache.poi.hwpf.converter.DefaultFontReplacer;
import org.apache.poi.hwpf.converter.FontReplacer;
import org.apache.poi.hwpf.converter.PicturesManager;
import org.apache.poi.hwpf.converter.WordToFoUtils;
import org.apache.poi.hwpf.model.FieldsDocumentPart;
import org.apache.poi.hwpf.model.ListFormatOverride;
import org.apache.poi.hwpf.model.ListTables;
import org.apache.poi.hwpf.usermodel.Bookmark;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.Field;
import org.apache.poi.hwpf.usermodel.Notes;
import org.apache.poi.hwpf.usermodel.OfficeDrawing;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Picture;
import org.apache.poi.hwpf.usermodel.PictureType;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.hwpf.usermodel.Section;
import org.apache.poi.hwpf.usermodel.Table;
import org.apache.poi.hwpf.usermodel.TableCell;
import org.apache.poi.hwpf.usermodel.TableRow;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractWordConverter {
    private static final byte BEL_MARK = 7;
    private static final byte FIELD_BEGIN_MARK = 19;
    private static final byte FIELD_END_MARK = 21;
    private static final byte FIELD_SEPARATOR_MARK = 20;
    private static final POILogger logger;
    private static final Pattern PATTERN_HYPERLINK_EXTERNAL;
    private static final Pattern PATTERN_HYPERLINK_LOCAL;
    private static final Pattern PATTERN_PAGEREF;
    private static final byte SPECCHAR_AUTONUMBERED_FOOTNOTE_REFERENCE = 2;
    private static final byte SPECCHAR_DRAWN_OBJECT = 8;
    protected static final char UNICODECHAR_NO_BREAK_SPACE = '\u00a0';
    protected static final char UNICODECHAR_NONBREAKING_HYPHEN = '\u2011';
    protected static final char UNICODECHAR_ZERO_WIDTH_SPACE = '\u200b';
    private final Set bookmarkStack = new LinkedHashSet();
    private FontReplacer fontReplacer = new DefaultFontReplacer();
    private PicturesManager picturesManager;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.hwpf.converter.AbstractWordConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = POILogFactory.getLogger((Class)clazz);
        PATTERN_HYPERLINK_EXTERNAL = Pattern.compile("^[ \\t\\r\\n]*HYPERLINK \"(.*)\".*$");
        PATTERN_HYPERLINK_LOCAL = Pattern.compile("^[ \\t\\r\\n]*HYPERLINK \\\\l \"(.*)\"[ ](.*)$");
        PATTERN_PAGEREF = Pattern.compile("^[ \\t\\r\\n]*PAGEREF ([^ ]*)[ \\t\\r\\n]*\\\\h.*$");
    }

    private static void addToStructures(List structures, Structure structure) {
        Iterator iterator = structures.iterator();
        while (iterator.hasNext()) {
            Structure another = (Structure)iterator.next();
            if (another.start <= structure.start && another.end >= structure.start) {
                return;
            }
            if (!(structure.start < another.start && another.start < structure.end || structure.start < another.start && another.end <= structure.end) && (structure.start > another.start || another.end >= structure.end)) continue;
            iterator.remove();
        }
        structures.add(structure);
    }

    protected void afterProcess() {
    }

    protected FontReplacer.Triplet getCharacterRunTriplet(CharacterRun characterRun) {
        FontReplacer.Triplet original = new FontReplacer.Triplet();
        original.bold = characterRun.isBold();
        original.italic = characterRun.isItalic();
        original.fontName = characterRun.getFontName();
        FontReplacer.Triplet updated = this.getFontReplacer().update(original);
        return updated;
    }

    public abstract Document getDocument();

    public FontReplacer getFontReplacer() {
        return this.fontReplacer;
    }

    protected int getNumberColumnsSpanned(int[] tableCellEdges, int currentEdgeIndex, TableCell tableCell) {
        int nextEdgeIndex = currentEdgeIndex;
        int colSpan = 0;
        int cellRightEdge = tableCell.getLeftEdge() + tableCell.getWidth();
        while (tableCellEdges[nextEdgeIndex] < cellRightEdge) {
            ++colSpan;
            ++nextEdgeIndex;
        }
        return colSpan;
    }

    protected int getNumberRowsSpanned(Table table, int[] tableCellEdges, int currentRowIndex, int currentColumnIndex, TableCell tableCell) {
        if (!tableCell.isFirstVerticallyMerged()) {
            return 1;
        }
        int numRows = table.numRows();
        int count = 1;
        int r1 = currentRowIndex + 1;
        while (r1 < numRows) {
            TableRow nextRow = table.getRow(r1);
            if (currentColumnIndex >= nextRow.numCells()) break;
            boolean hasCells = false;
            int currentEdgeIndex = 0;
            int c = 0;
            while (c < nextRow.numCells()) {
                TableCell nextTableCell = nextRow.getCell(c);
                if (!nextTableCell.isVerticallyMerged() || nextTableCell.isFirstVerticallyMerged()) {
                    int colSpan = this.getNumberColumnsSpanned(tableCellEdges, currentEdgeIndex, nextTableCell);
                    currentEdgeIndex += colSpan;
                    if (colSpan != 0) {
                        hasCells = true;
                        break;
                    }
                } else {
                    currentEdgeIndex += this.getNumberColumnsSpanned(tableCellEdges, currentEdgeIndex, nextTableCell);
                }
                ++c;
            }
            if (hasCells) {
                TableCell nextCell = nextRow.getCell(currentColumnIndex);
                if (!nextCell.isVerticallyMerged() || nextCell.isFirstVerticallyMerged()) break;
                ++count;
            }
            ++r1;
        }
        return count;
    }

    public PicturesManager getPicturesManager() {
        return this.picturesManager;
    }

    protected abstract void outputCharacters(Element var1, CharacterRun var2, String var3);

    protected abstract void processBookmarks(HWPFDocumentCore var1, Element var2, Range var3, int var4, List var5);

    /*
     * Unable to fully structure code
     */
    protected boolean processCharacters(HWPFDocumentCore wordDocument, int currentTableLevel, Range range, Element block) {
        if (range == null) {
            return false;
        }
        haveAnyText = false;
        structures = new LinkedList<E>();
        if (wordDocument instanceof HWPFDocument) {
            doc = (HWPFDocument)wordDocument;
            rangeBookmarks = doc.getBookmarks().getBookmarksStartedBetween(range.getStartOffset(), range.getEndOffset());
            if (rangeBookmarks != null) {
                iterator = rangeBookmarks.values().iterator();
                while (iterator.hasNext()) {
                    lists = (List)iterator.next();
                    iterator2 = lists.iterator();
                    while (iterator2.hasNext()) {
                        bookmark = (Bookmark)iterator2.next();
                        if (this.bookmarkStack.contains(bookmark)) continue;
                        AbstractWordConverter.addToStructures(structures, new Structure(bookmark));
                    }
                }
            }
            skipUntil = -1;
            c = 0;
            while (c < range.numCharacterRuns()) {
                characterRun = range.getCharacterRun(c);
                if (characterRun == null) {
                    throw new AssertionError();
                }
                if (characterRun.getStartOffset() >= skipUntil && (text = characterRun.text()) != null && text.length() != 0 && text.charAt(0) == '\u0013') {
                    aliveField = ((HWPFDocument)wordDocument).getFields().getFieldByStartOffset(FieldsDocumentPart.MAIN, characterRun.getStartOffset());
                    if (aliveField != null) {
                        AbstractWordConverter.addToStructures(structures, new Structure(aliveField));
                    } else {
                        separatorEnd = this.tryDeadField_lookupFieldSeparatorEnd(wordDocument, range, c);
                        if (separatorEnd != null) {
                            AbstractWordConverter.addToStructures(structures, new Structure(new DeadFieldBoundaries(c, separatorEnd[0], separatorEnd[1]), characterRun.getStartOffset(), range.getCharacterRun(separatorEnd[1]).getEndOffset()));
                            c = separatorEnd[1];
                        }
                    }
                }
                ++c;
            }
        }
        structures = new ArrayList<E>(structures);
        Collections.sort(structures);
        previous = range.getStartOffset();
        iterator = structures.iterator();
        while (iterator.hasNext()) {
            structure = (Structure)iterator.next();
            if (structure.start != previous) {
                subrange = new Range(previous, structure.start, range){

                    public String toString() {
                        return "BetweenStructuresSubrange " + super.toString();
                    }
                };
                this.processCharacters(wordDocument, currentTableLevel, subrange, block);
            }
            if (structure.structure instanceof Bookmark) {
                bookmarks = new LinkedList<Bookmark>();
                iterator2 = ((List)((HWPFDocument)wordDocument).getBookmarks().getBookmarksStartedBetween(structure.start, structure.start + 1).values().iterator().next()).iterator();
                while (iterator2.hasNext()) {
                    bookmark = (Bookmark)iterator2.next();
                    if (bookmark.getStart() != structure.start || bookmark.getEnd() != structure.end) continue;
                    bookmarks.add(bookmark);
                }
                this.bookmarkStack.addAll(bookmarks);
                try {
                    end = Math.min(range.getEndOffset(), structure.end);
                    subrange = new Range(structure.start, end, range){

                        public String toString() {
                            return "BookmarksSubrange " + super.toString();
                        }
                    };
                    this.processBookmarks(wordDocument, block, subrange, currentTableLevel, bookmarks);
                }
                finally {
                    this.bookmarkStack.removeAll(bookmarks);
                }
            } else if (structure.structure instanceof Field) {
                field = (Field)structure.structure;
                this.processField((HWPFDocument)wordDocument, range, currentTableLevel, field, block);
            } else if (structure.structure instanceof DeadFieldBoundaries) {
                boundaries = (DeadFieldBoundaries)structure.structure;
                this.processDeadField(wordDocument, block, range, currentTableLevel, boundaries.beginMark, boundaries.separatorMark, boundaries.endMark);
            } else {
                throw new UnsupportedOperationException("NYI: " + structure.structure.getClass());
            }
            previous = Math.min(range.getEndOffset(), structure.end);
        }
        if (previous != range.getStartOffset()) {
            if (previous > range.getEndOffset()) {
                AbstractWordConverter.logger.log(POILogger.WARN, (Object)"Latest structure in ", (Object)range, (Object)(" ended at #" + previous), (Object)" after range boundaries [", (Object)(String.valueOf(range.getStartOffset()) + "; " + range.getEndOffset()), (Object)")");
                return true;
            }
            if (previous < range.getEndOffset()) {
                subrange = new Range(previous, range.getEndOffset(), range){

                    public String toString() {
                        return "AfterStructureSubrange " + super.toString();
                    }
                };
                this.processCharacters(wordDocument, currentTableLevel, subrange, block);
            }
            return true;
        }
        c = 0;
        while (c < range.numCharacterRuns()) {
            block54: {
                block53: {
                    characterRun = range.getCharacterRun(c);
                    if (characterRun == null) {
                        throw new AssertionError();
                    }
                    if (!(wordDocument instanceof HWPFDocument) || !((HWPFDocument)wordDocument).getPicturesTable().hasPicture(characterRun)) break block53;
                    newFormat = (HWPFDocument)wordDocument;
                    picture = newFormat.getPicturesTable().extractPicture(characterRun, true);
                    this.processImage(block, characterRun.text().charAt(0) == '\u0001', picture);
                    break block54;
                }
                text = characterRun.text();
                if (text.getBytes().length == 0) break block54;
                if (!characterRun.isSpecialCharacter()) ** GOTO lbl-1000
                if (text.charAt(0) == '\u0002' && wordDocument instanceof HWPFDocument) {
                    doc = (HWPFDocument)wordDocument;
                    this.processNoteAnchor(doc, characterRun, block);
                } else if (text.charAt(0) == '\b' && wordDocument instanceof HWPFDocument) {
                    doc = (HWPFDocument)wordDocument;
                    this.processDrawnObject(doc, characterRun, block);
                } else if (characterRun.isOle2() && wordDocument instanceof HWPFDocument) {
                    doc = (HWPFDocument)wordDocument;
                    this.processOle2(doc, characterRun, block);
                } else if (text.getBytes()[0] == 19) {
                    if (wordDocument instanceof HWPFDocument && (aliveField = ((HWPFDocument)wordDocument).getFields().getFieldByStartOffset(FieldsDocumentPart.MAIN, characterRun.getStartOffset())) != null) {
                        this.processField((HWPFDocument)wordDocument, range, currentTableLevel, aliveField, block);
                        continueAfter = aliveField.getFieldEndOffset();
                        while (c < range.numCharacterRuns() && range.getCharacterRun(c).getEndOffset() <= continueAfter) {
                            ++c;
                        }
                        if (c < range.numCharacterRuns()) {
                            --c;
                        }
                    } else {
                        skipTo = this.tryDeadField(wordDocument, range, currentTableLevel, c, block);
                        if (skipTo != c) {
                            c = skipTo;
                        }
                    }
                } else if (!(text.getBytes()[0] == 20 || text.getBytes()[0] == 21 || characterRun.isSpecialCharacter() || characterRun.isObj() || characterRun.isOle2())) {
                    if (text.endsWith("\r") || text.charAt(text.length() - 1) == '\u0007' && currentTableLevel != -2147483648) {
                        text = text.substring(0, text.length() - 1);
                    }
                    stringBuilder = new StringBuffer();
                    i = 0;
                    while (i < text.toCharArray().length) {
                        charChar = text.toCharArray()[i];
                        if (charChar == '\u000b') {
                            if (stringBuilder.length() > 0) {
                                this.outputCharacters(block, characterRun, stringBuilder.toString());
                                stringBuilder.setLength(0);
                            }
                            this.processLineBreak(block, characterRun);
                        } else if (charChar == '\u001e') {
                            stringBuilder.append('\u2011');
                        } else if (charChar == '\u001f') {
                            stringBuilder.append('\u200b');
                        } else if (charChar >= ' ' || charChar == '\t' || charChar == '\n' || charChar == '\r') {
                            stringBuilder.append(charChar);
                        }
                        ++i;
                    }
                    if (stringBuilder.length() > 0) {
                        this.outputCharacters(block, characterRun, stringBuilder.toString());
                        stringBuilder.setLength(0);
                    }
                    haveAnyText |= text.trim().length() != 0;
                }
            }
            ++c;
        }
        return haveAnyText;
    }

    protected void processDeadField(HWPFDocumentCore wordDocument, Element currentBlock, Range range, int currentTableLevel, int beginMark, int separatorMark, int endMark) {
        if (beginMark + 1 < separatorMark && separatorMark + 1 < endMark) {
            Range formulaRange = new Range(range.getCharacterRun(beginMark + 1).getStartOffset(), range.getCharacterRun(separatorMark - 1).getEndOffset(), range){

                public String toString() {
                    return "Dead field formula subrange: " + super.toString();
                }
            };
            Range valueRange = new Range(range.getCharacterRun(separatorMark + 1).getStartOffset(), range.getCharacterRun(endMark - 1).getEndOffset(), range){

                public String toString() {
                    return "Dead field value subrange: " + super.toString();
                }
            };
            String formula = formulaRange.text();
            Matcher matcher = PATTERN_HYPERLINK_LOCAL.matcher(formula);
            if (matcher.matches()) {
                String localref = matcher.group(1);
                this.processPageref(wordDocument, currentBlock, valueRange, currentTableLevel, localref);
                return;
            }
        }
        StringBuffer debug = new StringBuffer("Unsupported field type: \n");
        int i = beginMark;
        while (i <= endMark) {
            debug.append("\t");
            debug.append(range.getCharacterRun(i));
            debug.append("\n");
            ++i;
        }
        logger.log(POILogger.WARN, (Object)debug);
        Range deadFieldValueSubrage = new Range(range.getCharacterRun(separatorMark).getStartOffset() + 1, range.getCharacterRun(endMark).getStartOffset(), range){

            public String toString() {
                return "DeadFieldValueSubrange (" + super.toString() + ")";
            }
        };
        if (separatorMark + 1 < endMark) {
            this.processCharacters(wordDocument, currentTableLevel, deadFieldValueSubrage, currentBlock);
        }
    }

    public void processDocument(HWPFDocumentCore wordDocument) {
        Range docRange;
        try {
            SummaryInformation summaryInformation = wordDocument.getSummaryInformation();
            if (summaryInformation != null) {
                this.processDocumentInformation(summaryInformation);
            }
        }
        catch (Exception exc) {
            logger.log(POILogger.WARN, (Object)"Unable to process document summary information: ", (Object)exc, (Throwable)exc);
        }
        if ((docRange = wordDocument.getRange()).numSections() == 1) {
            this.processSingleSection(wordDocument, docRange.getSection(0));
            this.afterProcess();
            return;
        }
        this.processDocumentPart(wordDocument, docRange);
        this.afterProcess();
    }

    protected abstract void processDocumentInformation(SummaryInformation var1);

    protected void processDocumentPart(HWPFDocumentCore wordDocument, Range range) {
        int s = 0;
        while (s < range.numSections()) {
            this.processSection(wordDocument, range.getSection(s), s);
            ++s;
        }
    }

    protected void processDrawnObject(HWPFDocument doc, CharacterRun characterRun, Element block) {
        if (this.getPicturesManager() == null) {
            return;
        }
        OfficeDrawing officeDrawing = doc.getOfficeDrawingsMain().getOfficeDrawingAt(characterRun.getStartOffset());
        if (officeDrawing == null) {
            logger.log(POILogger.WARN, (Object)("Characters #" + characterRun + " references missing drawn object"));
            return;
        }
        byte[] pictureData = officeDrawing.getPictureData();
        if (pictureData == null) {
            return;
        }
        float width = (float)(officeDrawing.getRectangleRight() - officeDrawing.getRectangleLeft()) / 1440.0f;
        float height = (float)(officeDrawing.getRectangleBottom() - officeDrawing.getRectangleTop()) / 1440.0f;
        PictureType type = PictureType.findMatchingType(pictureData);
        String path = this.getPicturesManager().savePicture(pictureData, type, "s" + characterRun.getStartOffset() + "." + type, width, height);
        this.processDrawnObject(doc, characterRun, officeDrawing, path, block);
    }

    protected abstract void processDrawnObject(HWPFDocument var1, CharacterRun var2, OfficeDrawing var3, String var4, Element var5);

    protected abstract void processEndnoteAutonumbered(HWPFDocument var1, int var2, Element var3, Range var4);

    protected void processField(HWPFDocument wordDocument, Range parentRange, int currentTableLevel, Field field, Element currentBlock) {
        switch (field.getType()) {
            case 37: {
                String formula;
                Matcher matcher;
                Range firstSubrange = field.firstSubrange(parentRange);
                if (firstSubrange == null || !(matcher = PATTERN_PAGEREF.matcher(formula = firstSubrange.text())).find()) break;
                String pageref = matcher.group(1);
                this.processPageref(wordDocument, currentBlock, field.secondSubrange(parentRange), currentTableLevel, pageref);
                return;
            }
            case 58: {
                if (!field.hasSeparator()) {
                    logger.log(POILogger.WARN, (Object)(parentRange + " contains " + field + " with 'Embedded Object' but without separator mark"));
                    return;
                }
                CharacterRun separator = field.getMarkSeparatorCharacterRun(parentRange);
                if (!separator.isOle2()) break;
                boolean processed = this.processOle2(wordDocument, separator, currentBlock);
                if (!processed) {
                    this.processCharacters(wordDocument, currentTableLevel, field.secondSubrange(parentRange), currentBlock);
                }
                return;
            }
            case 88: {
                Range firstSubrange = field.firstSubrange(parentRange);
                if (firstSubrange == null) break;
                String formula = firstSubrange.text();
                Matcher matcher = PATTERN_HYPERLINK_EXTERNAL.matcher(formula);
                if (matcher.matches()) {
                    String hyperlink = matcher.group(1);
                    this.processHyperlink(wordDocument, currentBlock, field.secondSubrange(parentRange), currentTableLevel, hyperlink);
                    return;
                }
                matcher = PATTERN_HYPERLINK_LOCAL.matcher(formula);
                if (!matcher.matches()) break;
                String hyperlink = matcher.group(1);
                Range textRange = null;
                String text = matcher.group(2);
                if (AbstractWordUtils.isNotEmpty(text)) {
                    textRange = new Range(firstSubrange.getStartOffset() + matcher.start(2), firstSubrange.getStartOffset() + matcher.end(2), firstSubrange){

                        public String toString() {
                            return "Local hyperlink text";
                        }
                    };
                }
                this.processPageref(wordDocument, currentBlock, textRange, currentTableLevel, hyperlink);
                return;
            }
        }
        logger.log(POILogger.WARN, (Object)(parentRange + " contains " + field + " with unsupported type or format"));
        this.processCharacters(wordDocument, currentTableLevel, field.secondSubrange(parentRange), currentBlock);
    }

    protected abstract void processFootnoteAutonumbered(HWPFDocument var1, int var2, Element var3, Range var4);

    protected abstract void processHyperlink(HWPFDocumentCore var1, Element var2, Range var3, int var4, String var5);

    protected void processImage(Element currentBlock, boolean inlined, Picture picture) {
        PicturesManager fileManager = this.getPicturesManager();
        if (fileManager != null) {
            int aspectRatioX = picture.getHorizontalScalingFactor();
            int aspectRatioY = picture.getVerticalScalingFactor();
            float imageWidth = aspectRatioX > 0 ? (float)(picture.getDxaGoal() * aspectRatioX / 1000) / 1440.0f : (float)picture.getDxaGoal() / 1440.0f;
            float imageHeight = aspectRatioY > 0 ? (float)(picture.getDyaGoal() * aspectRatioY / 1000) / 1440.0f : (float)picture.getDyaGoal() / 1440.0f;
            String url = fileManager.savePicture(picture.getContent(), picture.suggestPictureType(), picture.suggestFullFileName(), imageWidth, imageHeight);
            if (WordToFoUtils.isNotEmpty(url)) {
                this.processImage(currentBlock, inlined, picture, url);
                return;
            }
        }
        this.processImageWithoutPicturesManager(currentBlock, inlined, picture);
    }

    protected abstract void processImage(Element var1, boolean var2, Picture var3, String var4);

    protected abstract void processImageWithoutPicturesManager(Element var1, boolean var2, Picture var3);

    protected abstract void processLineBreak(Element var1, CharacterRun var2);

    protected void processNoteAnchor(HWPFDocument doc, CharacterRun characterRun, Element block) {
        Notes footnotes = doc.getFootnotes();
        int noteIndex = footnotes.getNoteIndexByAnchorPosition(characterRun.getStartOffset());
        if (noteIndex != -1) {
            Range footnoteRange = doc.getFootnoteRange();
            int rangeStartOffset = footnoteRange.getStartOffset();
            int noteTextStartOffset = footnotes.getNoteTextStartOffset(noteIndex);
            int noteTextEndOffset = footnotes.getNoteTextEndOffset(noteIndex);
            Range noteTextRange = new Range(rangeStartOffset + noteTextStartOffset, rangeStartOffset + noteTextEndOffset, doc);
            this.processFootnoteAutonumbered(doc, noteIndex, block, noteTextRange);
            return;
        }
        Notes endnotes = doc.getEndnotes();
        noteIndex = endnotes.getNoteIndexByAnchorPosition(characterRun.getStartOffset());
        if (noteIndex != -1) {
            Range endnoteRange = doc.getEndnoteRange();
            int rangeStartOffset = endnoteRange.getStartOffset();
            int noteTextStartOffset = endnotes.getNoteTextStartOffset(noteIndex);
            int noteTextEndOffset = endnotes.getNoteTextEndOffset(noteIndex);
            Range noteTextRange = new Range(rangeStartOffset + noteTextStartOffset, rangeStartOffset + noteTextEndOffset, doc);
            this.processEndnoteAutonumbered(doc, noteIndex, block, noteTextRange);
            return;
        }
    }

    private boolean processOle2(HWPFDocument doc, CharacterRun characterRun, Element block) {
        Entry entry = doc.getObjectsPool().getObjectById("_" + characterRun.getPicOffset());
        if (entry == null) {
            logger.log(POILogger.WARN, (Object)"Referenced OLE2 object '", (Object)new Integer(characterRun.getPicOffset()), (Object)"' not found in ObjectPool");
            return false;
        }
        try {
            return this.processOle2(doc, block, entry);
        }
        catch (Exception exc) {
            logger.log(POILogger.WARN, (Object)"Unable to convert internal OLE2 object '", (Object)new Integer(characterRun.getPicOffset()), (Object)"': ", (Object)exc, (Throwable)exc);
            return false;
        }
    }

    protected boolean processOle2(HWPFDocument wordDocument, Element block, Entry entry) throws Exception {
        return false;
    }

    protected abstract void processPageBreak(HWPFDocumentCore var1, Element var2);

    protected abstract void processPageref(HWPFDocumentCore var1, Element var2, Range var3, int var4, String var5);

    protected abstract void processParagraph(HWPFDocumentCore var1, Element var2, int var3, Paragraph var4, String var5);

    protected void processParagraphes(HWPFDocumentCore wordDocument, Element flow, Range range, int currentTableLevel) {
        ListTables listTables = wordDocument.getListTables();
        int currentListInfo = 0;
        int paragraphs = range.numParagraphs();
        int p = 0;
        while (p < paragraphs) {
            Paragraph paragraph = range.getParagraph(p);
            if (paragraph.isInTable() && paragraph.getTableLevel() != currentTableLevel) {
                if (paragraph.getTableLevel() < currentTableLevel) {
                    throw new IllegalStateException("Trying to process table cell with higher level (" + paragraph.getTableLevel() + ") than current table level (" + currentTableLevel + ") as inner table part");
                }
                Table table = range.getTable(paragraph);
                this.processTable(wordDocument, flow, table);
                p += table.numParagraphs();
                --p;
            } else {
                if (paragraph.text().equals("\f")) {
                    this.processPageBreak(wordDocument, flow);
                }
                if (paragraph.getIlfo() != currentListInfo) {
                    currentListInfo = paragraph.getIlfo();
                }
                if (currentListInfo != 0) {
                    if (listTables != null) {
                        ListFormatOverride listFormatOverride = listTables.getOverride(paragraph.getIlfo());
                        String label = AbstractWordUtils.getBulletText(listTables, paragraph, listFormatOverride.getLsid());
                        this.processParagraph(wordDocument, flow, currentTableLevel, paragraph, label);
                    } else {
                        logger.log(POILogger.WARN, (Object)("Paragraph #" + paragraph.getStartOffset() + "-" + paragraph.getEndOffset() + " has reference to list structure #" + currentListInfo + ", but listTables not defined in file"));
                        this.processParagraph(wordDocument, flow, currentTableLevel, paragraph, "");
                    }
                } else {
                    this.processParagraph(wordDocument, flow, currentTableLevel, paragraph, "");
                }
            }
            ++p;
        }
    }

    protected abstract void processSection(HWPFDocumentCore var1, Section var2, int var3);

    protected void processSingleSection(HWPFDocumentCore wordDocument, Section section) {
        this.processSection(wordDocument, section, 0);
    }

    protected abstract void processTable(HWPFDocumentCore var1, Element var2, Table var3);

    public void setFontReplacer(FontReplacer fontReplacer) {
        this.fontReplacer = fontReplacer;
    }

    public void setPicturesManager(PicturesManager fileManager) {
        this.picturesManager = fileManager;
    }

    protected int tryDeadField(HWPFDocumentCore wordDocument, Range range, int currentTableLevel, int beginMark, Element currentBlock) {
        int[] separatorEnd = this.tryDeadField_lookupFieldSeparatorEnd(wordDocument, range, beginMark);
        if (separatorEnd == null) {
            return beginMark;
        }
        this.processDeadField(wordDocument, currentBlock, range, currentTableLevel, beginMark, separatorEnd[0], separatorEnd[1]);
        return separatorEnd[1];
    }

    private int[] tryDeadField_lookupFieldSeparatorEnd(HWPFDocumentCore wordDocument, Range range, int beginMark) {
        int separatorMark = -1;
        int endMark = -1;
        int c = beginMark + 1;
        while (c < range.numCharacterRuns()) {
            CharacterRun characterRun = range.getCharacterRun(c);
            String text = characterRun.text();
            if (text.getBytes().length != 0) {
                byte firstByte = text.getBytes()[0];
                if (firstByte == 19) {
                    int[] nested = this.tryDeadField_lookupFieldSeparatorEnd(wordDocument, range, c);
                    if (nested != null) {
                        c = nested[1];
                    }
                } else if (firstByte == 20) {
                    if (separatorMark != -1) {
                        return null;
                    }
                    separatorMark = c;
                } else if (text.getBytes()[0] == 21) {
                    if (endMark != -1) {
                        return null;
                    }
                    endMark = c;
                    break;
                }
            }
            ++c;
        }
        if (separatorMark == -1 || endMark == -1) {
            return null;
        }
        return new int[]{separatorMark, endMark};
    }

    private static class DeadFieldBoundaries {
        final int beginMark;
        final int endMark;
        final int separatorMark;

        public DeadFieldBoundaries(int beginMark, int separatorMark, int endMark) {
            this.beginMark = beginMark;
            this.separatorMark = separatorMark;
            this.endMark = endMark;
        }
    }

    private static final class Structure
    implements Comparable {
        final int end;
        final int start;
        final Object structure;

        Structure(Bookmark bookmark) {
            this.start = bookmark.getStart();
            this.end = bookmark.getEnd();
            this.structure = bookmark;
        }

        Structure(DeadFieldBoundaries deadFieldBoundaries, int start, int end) {
            this.start = start;
            this.end = end;
            this.structure = deadFieldBoundaries;
        }

        Structure(Field field) {
            this.start = field.getFieldStartOffset();
            this.end = field.getFieldEndOffset();
            this.structure = field;
        }

        public int compareTo(Object in_o) {
            Structure o = (Structure)in_o;
            return this.start < o.start ? -1 : (this.start == o.start ? 0 : 1);
        }

        public String toString() {
            return "Structure [" + this.start + "; " + this.end + "): " + this.structure.toString();
        }
    }
}

