/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Vector;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherDgRecord;
import org.apache.poi.ddf.EscherDggRecord;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.hslf.model.Background;
import org.apache.poi.hslf.model.Comment;
import org.apache.poi.hslf.model.HeadersFooters;
import org.apache.poi.hslf.model.MasterSheet;
import org.apache.poi.hslf.model.Notes;
import org.apache.poi.hslf.model.Placeholder;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.Sheet;
import org.apache.poi.hslf.model.SlideMaster;
import org.apache.poi.hslf.model.TextBox;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.model.TextShape;
import org.apache.poi.hslf.model.TitleMaster;
import org.apache.poi.hslf.record.ColorSchemeAtom;
import org.apache.poi.hslf.record.Comment2000;
import org.apache.poi.hslf.record.HeadersFootersContainer;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordContainer;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.record.SlideAtom;
import org.apache.poi.hslf.record.SlideListWithText;

public final class Slide
extends Sheet {
    private int _slideNo;
    private SlideListWithText.SlideAtomsSet _atomSet;
    private TextRun[] _runs;
    private Notes _notes;

    public Slide(org.apache.poi.hslf.record.Slide slide, Notes notes, SlideListWithText.SlideAtomsSet atomSet, int slideIdentifier, int slideNumber) {
        super(slide, slideIdentifier);
        this._notes = notes;
        this._atomSet = atomSet;
        this._slideNo = slideNumber;
        TextRun[] _otherRuns = Slide.findTextRuns(this.getPPDrawing());
        Vector textRuns = new Vector();
        if (this._atomSet != null) {
            Slide.findTextRuns(this._atomSet.getSlideRecords(), textRuns);
        }
        this._runs = new TextRun[textRuns.size() + _otherRuns.length];
        int i = 0;
        i = 0;
        while (i < textRuns.size()) {
            this._runs[i] = (TextRun)textRuns.get(i);
            this._runs[i].setSheet(this);
            ++i;
        }
        int k = 0;
        while (k < _otherRuns.length) {
            this._runs[i] = _otherRuns[k];
            this._runs[i].setSheet(this);
            this._runs[i].setIndex(-1);
            ++i;
            ++k;
        }
    }

    public Slide(int sheetNumber, int sheetRefId, int slideNumber) {
        super(new org.apache.poi.hslf.record.Slide(), sheetNumber);
        this._slideNo = slideNumber;
        this.getSheetContainer().setSheetId(sheetRefId);
    }

    public void setNotes(Notes notes) {
        this._notes = notes;
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        if (notes == null) {
            sa.setNotesID(0);
        } else {
            sa.setNotesID(notes._getSheetNumber());
        }
    }

    public void setSlideNumber(int newSlideNumber) {
        this._slideNo = newSlideNumber;
    }

    public void onCreate() {
        EscherDggRecord dgg = this.getSlideShow().getDocumentRecord().getPPDrawingGroup().getEscherDggRecord();
        EscherContainerRecord dgContainer = (EscherContainerRecord)this.getSheetContainer().getPPDrawing().getEscherRecords()[0];
        EscherDgRecord dg = (EscherDgRecord)Shape.getEscherChild(dgContainer, -4088);
        int dgId = dgg.getMaxDrawingGroupId() + 1;
        dg.setOptions((short)(dgId << 4));
        dgg.setDrawingsSaved(dgg.getDrawingsSaved() + 1);
        dgg.setMaxDrawingGroupId(dgId);
        Iterator iterator = dgContainer.getChildContainers().iterator();
        while (iterator.hasNext()) {
            EscherContainerRecord c = (EscherContainerRecord)iterator.next();
            EscherSpRecord spr = null;
            switch (c.getRecordId()) {
                case -4093: {
                    EscherContainerRecord dc = (EscherContainerRecord)c.getChild(0);
                    spr = (EscherSpRecord)dc.getChildById((short)-4086);
                    break;
                }
                case -4092: {
                    spr = (EscherSpRecord)c.getChildById((short)-4086);
                }
            }
            if (spr == null) continue;
            spr.setShapeId(this.allocateShapeId());
        }
        dg.setNumShapes(1);
    }

    public TextBox addTitle() {
        Placeholder pl = new Placeholder();
        pl.setShapeType(1);
        pl.getTextRun().setRunType(0);
        pl.setText("Click to edit title");
        pl.setAnchor(new Rectangle(54, 48, 612, 90));
        this.addShape(pl);
        return pl;
    }

    public String getTitle() {
        TextRun[] txt = this.getTextRuns();
        int i = 0;
        while (i < txt.length) {
            int type = txt[i].getRunType();
            if (type == 6 || type == 0) {
                String title = txt[i].getText();
                return title;
            }
            ++i;
        }
        return null;
    }

    public TextRun[] getTextRuns() {
        return this._runs;
    }

    public int getSlideNumber() {
        return this._slideNo;
    }

    public org.apache.poi.hslf.record.Slide getSlideRecord() {
        return (org.apache.poi.hslf.record.Slide)this.getSheetContainer();
    }

    public Notes getNotesSheet() {
        return this._notes;
    }

    protected SlideListWithText.SlideAtomsSet getSlideAtomsSet() {
        return this._atomSet;
    }

    public MasterSheet getMasterSheet() {
        TitleMaster[] titleMaster;
        SlideMaster[] master = this.getSlideShow().getSlidesMasters();
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        int masterId = sa.getMasterID();
        MasterSheet sheet = null;
        int i = 0;
        while (i < master.length) {
            if (masterId == master[i]._getSheetNumber()) {
                sheet = master[i];
                break;
            }
            ++i;
        }
        if (sheet == null && (titleMaster = this.getSlideShow().getTitleMasters()) != null) {
            int i2 = 0;
            while (i2 < titleMaster.length) {
                if (masterId == titleMaster[i2]._getSheetNumber()) {
                    sheet = titleMaster[i2];
                    break;
                }
                ++i2;
            }
        }
        return sheet;
    }

    public void setMasterSheet(MasterSheet master) {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        int sheetNo = master._getSheetNumber();
        sa.setMasterID(sheetNo);
    }

    public void setFollowMasterBackground(boolean flag) {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        sa.setFollowMasterBackground(flag);
    }

    public boolean getFollowMasterBackground() {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        return sa.getFollowMasterBackground();
    }

    public void setFollowMasterObjects(boolean flag) {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        sa.setFollowMasterObjects(flag);
    }

    public boolean getFollowMasterScheme() {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        return sa.getFollowMasterScheme();
    }

    public void setFollowMasterScheme(boolean flag) {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        sa.setFollowMasterScheme(flag);
    }

    public boolean getFollowMasterObjects() {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        return sa.getFollowMasterObjects();
    }

    public Background getBackground() {
        if (this.getFollowMasterBackground()) {
            return this.getMasterSheet().getBackground();
        }
        return super.getBackground();
    }

    public ColorSchemeAtom getColorScheme() {
        if (this.getFollowMasterScheme()) {
            return this.getMasterSheet().getColorScheme();
        }
        return super.getColorScheme();
    }

    public Comment[] getComments() {
        RecordContainer binaryTags;
        RecordContainer progBinaryTag;
        RecordContainer progTags = (RecordContainer)this.getSheetContainer().findFirstOfType(RecordTypes.ProgTags.typeID);
        if (progTags != null && (progBinaryTag = (RecordContainer)progTags.findFirstOfType(RecordTypes.ProgBinaryTag.typeID)) != null && (binaryTags = (RecordContainer)progBinaryTag.findFirstOfType(RecordTypes.BinaryTagData.typeID)) != null) {
            int count = 0;
            int i = 0;
            while (i < binaryTags.getChildRecords().length) {
                if (binaryTags.getChildRecords()[i] instanceof Comment2000) {
                    ++count;
                }
                ++i;
            }
            Comment[] comments = new Comment[count];
            count = 0;
            int i2 = 0;
            while (i2 < binaryTags.getChildRecords().length) {
                if (binaryTags.getChildRecords()[i2] instanceof Comment2000) {
                    comments[i2] = new Comment((Comment2000)binaryTags.getChildRecords()[i2]);
                    ++count;
                }
                ++i2;
            }
            return comments;
        }
        return new Comment[0];
    }

    public void draw(Graphics2D graphics) {
        int i;
        Shape[] sh;
        MasterSheet master = this.getMasterSheet();
        Background bg = this.getBackground();
        if (bg != null) {
            bg.draw(graphics);
        }
        if (this.getFollowMasterObjects()) {
            sh = master.getShapes();
            i = 0;
            while (i < sh.length) {
                if (!MasterSheet.isPlaceholder(sh[i])) {
                    sh[i].draw(graphics);
                }
                ++i;
            }
        }
        sh = this.getShapes();
        i = 0;
        while (i < sh.length) {
            sh[i].draw(graphics);
            ++i;
        }
    }

    public HeadersFooters getHeadersFooters() {
        HeadersFootersContainer hdd = null;
        Record[] ch = this.getSheetContainer().getChildRecords();
        boolean ppt2007 = false;
        int i = 0;
        while (i < ch.length) {
            if (ch[i] instanceof HeadersFootersContainer) {
                hdd = (HeadersFootersContainer)ch[i];
            } else if (ch[i].getRecordType() == (long)RecordTypes.RoundTripContentMasterId.typeID) {
                ppt2007 = true;
            }
            ++i;
        }
        boolean newRecord = false;
        if (hdd == null && !ppt2007) {
            return this.getSlideShow().getSlideHeadersFooters();
        }
        if (hdd == null) {
            hdd = new HeadersFootersContainer(63);
            newRecord = true;
        }
        return new HeadersFooters(hdd, this, newRecord, ppt2007);
    }

    protected void onAddTextShape(TextShape shape) {
        TextRun run = shape.getTextRun();
        if (this._runs == null) {
            this._runs = new TextRun[]{run};
        } else {
            TextRun[] tmp = new TextRun[this._runs.length + 1];
            System.arraycopy(this._runs, 0, tmp, 0, this._runs.length);
            tmp[tmp.length - 1] = run;
            this._runs = tmp;
        }
    }
}

