/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hmef;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hmef.Attachment;
import org.apache.poi.hmef.attribute.MAPIAttribute;
import org.apache.poi.hmef.attribute.MAPIStringAttribute;
import org.apache.poi.hmef.attribute.TNEFAttribute;
import org.apache.poi.hmef.attribute.TNEFMAPIAttribute;
import org.apache.poi.hmef.attribute.TNEFProperty;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.util.LittleEndian;

public final class HMEFMessage {
    public static final long HEADER_SIGNATURE = 574529400L;
    private int fileId;
    private List messageAttributes = new ArrayList();
    private List mapiAttributes = new ArrayList();
    private List attachments = new ArrayList();

    public HMEFMessage(InputStream inp) throws IOException {
        long sig = LittleEndian.readInt((InputStream)inp);
        if (sig != 574529400L) {
            throw new IllegalArgumentException("TNEF signature not detected in file, expected 574529400 but got " + sig);
        }
        this.fileId = LittleEndian.readUShort((InputStream)inp);
        this.process(inp, 0);
    }

    private void process(InputStream inp, int lastLevel) throws IOException {
        int level = inp.read();
        if (level == -1) {
            return;
        }
        TNEFAttribute attr = TNEFAttribute.create(inp);
        if (level == 1) {
            this.messageAttributes.add(attr);
            if (attr instanceof TNEFMAPIAttribute) {
                TNEFMAPIAttribute tnefMAPI = (TNEFMAPIAttribute)attr;
                this.mapiAttributes.addAll(tnefMAPI.getMAPIAttributes());
            }
        } else if (level == 2) {
            if (this.attachments.size() == 0 || attr.getProperty() == TNEFProperty.ID_ATTACHRENDERDATA) {
                this.attachments.add(new Attachment());
            }
            Attachment attach = (Attachment)this.attachments.get(this.attachments.size() - 1);
            attach.addAttribute(attr);
        } else {
            throw new IllegalStateException("Unhandled level " + level);
        }
        this.process(inp, level);
    }

    public List getMessageAttributes() {
        return this.messageAttributes;
    }

    public List getMessageMAPIAttributes() {
        return this.mapiAttributes;
    }

    public List getAttachments() {
        return this.attachments;
    }

    public TNEFAttribute getMessageAttribute(TNEFProperty id) {
        Iterator iterator = this.messageAttributes.iterator();
        while (iterator.hasNext()) {
            TNEFAttribute attr = (TNEFAttribute)iterator.next();
            if (attr.getProperty() != id) continue;
            return attr;
        }
        return null;
    }

    public MAPIAttribute getMessageMAPIAttribute(MAPIProperty id) {
        Iterator iterator = this.mapiAttributes.iterator();
        while (iterator.hasNext()) {
            MAPIAttribute attr = (MAPIAttribute)iterator.next();
            if (attr.getProperty() != id) continue;
            return attr;
        }
        return null;
    }

    private String getString(MAPIProperty id) {
        return MAPIStringAttribute.getAsString(this.getMessageMAPIAttribute(id));
    }

    public String getSubject() {
        return this.getString(MAPIProperty.CONVERSATION_TOPIC);
    }

    public String getBody() {
        return this.getString(MAPIProperty.RTF_COMPRESSED);
    }
}

