/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.charts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Chart;
import org.apache.poi.ss.usermodel.charts.ChartAxis;
import org.apache.poi.ss.usermodel.charts.ChartDataSource;
import org.apache.poi.ss.usermodel.charts.ScatterChartData;
import org.apache.poi.ss.usermodel.charts.ScatterChartSerie;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.apache.poi.xssf.usermodel.charts.XSSFChartUtil;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScatterChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScatterSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScatterStyle;
import org.openxmlformats.schemas.drawingml.x2006.chart.STScatterStyle;

public class XSSFScatterChartData
implements ScatterChartData {
    private List series = new ArrayList();

    public ScatterChartSerie addSerie(ChartDataSource xs, ChartDataSource ys) {
        if (!ys.isNumeric()) {
            throw new IllegalArgumentException("Y axis data source must be numeric.");
        }
        int numOfSeries = this.series.size();
        Serie newSerie = new Serie(numOfSeries, numOfSeries, xs, ys);
        this.series.add(newSerie);
        return newSerie;
    }

    public void fillChart(Chart chart, ChartAxis[] axis) {
        if (!(chart instanceof XSSFChart)) {
            throw new IllegalArgumentException("Chart must be instance of XSSFChart");
        }
        XSSFChart xssfChart = (XSSFChart)chart;
        CTPlotArea plotArea = xssfChart.getCTChart().getPlotArea();
        CTScatterChart scatterChart = plotArea.addNewScatterChart();
        this.addStyle(scatterChart);
        Iterator iterator = this.series.iterator();
        while (iterator.hasNext()) {
            Serie s = (Serie)iterator.next();
            s.addToChart(scatterChart);
        }
        int i = 0;
        while (i < axis.length) {
            ChartAxis ax = axis[i];
            scatterChart.addNewAxId().setVal(ax.getId());
            ++i;
        }
    }

    public List getSeries() {
        return this.series;
    }

    private void addStyle(CTScatterChart ctScatterChart) {
        CTScatterStyle scatterStyle = ctScatterChart.addNewScatterStyle();
        scatterStyle.setVal(STScatterStyle.LINE_MARKER);
    }

    static class Serie
    implements ScatterChartSerie {
        private int id;
        private int order;
        private ChartDataSource xs;
        private ChartDataSource ys;

        protected Serie(int id, int order, ChartDataSource xs, ChartDataSource ys) {
            this.id = id;
            this.order = order;
            this.xs = xs;
            this.ys = ys;
        }

        public ChartDataSource getXValues() {
            return this.xs;
        }

        public ChartDataSource getYValues() {
            return this.ys;
        }

        protected void addToChart(CTScatterChart ctScatterChart) {
            CTScatterSer scatterSer = ctScatterChart.addNewSer();
            scatterSer.addNewIdx().setVal((long)this.id);
            scatterSer.addNewOrder().setVal((long)this.order);
            CTAxDataSource xVal = scatterSer.addNewXVal();
            XSSFChartUtil.buildAxDataSource(xVal, this.xs);
            CTNumDataSource yVal = scatterSer.addNewYVal();
            XSSFChartUtil.buildNumDataSource(yVal, this.ys);
        }
    }
}

