/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.model.ParagraphPropertyFetcher;
import org.apache.poi.xslf.usermodel.ListAutoNumber;
import org.apache.poi.xslf.usermodel.RenderableShape;
import org.apache.poi.xslf.usermodel.TextAlign;
import org.apache.poi.xslf.usermodel.TextFragment;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFColor;
import org.apache.poi.xslf.usermodel.XSLFFontManager;
import org.apache.poi.xslf.usermodel.XSLFLineBreak;
import org.apache.poi.xslf.usermodel.XSLFRenderingHint;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFTextRun;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextAutonumberBullet;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBulletSizePercent;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBulletSizePoint;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharBullet;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextField;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextFont;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextLineBreak;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextNormalAutofit;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextSpacing;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextTabStop;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextTabStopList;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAlignType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAutonumberScheme;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;
import poi.support.Iterable;

public class XSLFTextParagraph
implements Iterable {
    private final CTTextParagraph _p;
    private final List _runs;
    private final XSLFTextShape _shape;
    private List _lines;
    private TextFragment _bullet;
    private double _maxLineHeight;

    XSLFTextParagraph(CTTextParagraph p, XSLFTextShape shape) {
        this._p = p;
        this._runs = new ArrayList();
        this._shape = shape;
        XmlObject[] xmlObj = this._p.selectPath("*");
        int i = 0;
        while (i < xmlObj.length) {
            CTRegularTextRun r;
            XmlObject ch = xmlObj[i];
            if (ch instanceof CTRegularTextRun) {
                CTRegularTextRun r2 = (CTRegularTextRun)ch;
                this._runs.add(new XSLFTextRun(r2, this));
            } else if (ch instanceof CTTextLineBreak) {
                CTTextLineBreak br = (CTTextLineBreak)ch;
                r = CTRegularTextRun.Factory.newInstance();
                r.setRPr(br.getRPr());
                r.setT("\n");
                this._runs.add(new XSLFTextRun(r, this));
            } else if (ch instanceof CTTextField) {
                CTTextField f = (CTTextField)ch;
                r = CTRegularTextRun.Factory.newInstance();
                r.setRPr(f.getRPr());
                r.setT(f.getT());
                this._runs.add(new XSLFTextRun(r, this));
            }
            ++i;
        }
    }

    public String getText() {
        StringBuffer out = new StringBuffer();
        Iterator iterator = this._runs.iterator();
        while (iterator.hasNext()) {
            XSLFTextRun r = (XSLFTextRun)iterator.next();
            out.append(r.getText());
        }
        return out.toString();
    }

    String getRenderableText() {
        StringBuffer out = new StringBuffer();
        Iterator iterator = this._runs.iterator();
        while (iterator.hasNext()) {
            XSLFTextRun r = (XSLFTextRun)iterator.next();
            out.append(r.getRenderableText());
        }
        return out.toString();
    }

    public CTTextParagraph getXmlObject() {
        return this._p;
    }

    XSLFTextShape getParentShape() {
        return this._shape;
    }

    public List getTextRuns() {
        return this._runs;
    }

    public Iterator iterator() {
        return this._runs.iterator();
    }

    public XSLFTextRun addNewTextRun() {
        CTRegularTextRun r = this._p.addNewR();
        CTTextCharacterProperties rPr = r.addNewRPr();
        rPr.setLang("en-US");
        XSLFTextRun run = new XSLFTextRun(r, this);
        this._runs.add(run);
        return run;
    }

    public XSLFTextRun addLineBreak() {
        CTTextLineBreak br = this._p.addNewBr();
        CTTextCharacterProperties brProps = br.addNewRPr();
        if (this._runs.size() > 0) {
            CTTextCharacterProperties prevRun = ((XSLFTextRun)this._runs.get(this._runs.size() - 1)).getRPr();
            brProps.set((XmlObject)prevRun);
        }
        CTRegularTextRun r = CTRegularTextRun.Factory.newInstance();
        r.setRPr(brProps);
        r.setT("\n");
        XSLFLineBreak run = new XSLFLineBreak(r, this, brProps);
        this._runs.add(run);
        return run;
    }

    public TextAlign getTextAlign() {
        ParagraphPropertyFetcher fetcher = new ParagraphPropertyFetcher(this.getLevel()){

            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetAlgn()) {
                    TextAlign val = TextAlign.values()[props.getAlgn().intValue() - 1];
                    this.setValue(val);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return (TextAlign)(fetcher.getValue() == null ? TextAlign.LEFT : fetcher.getValue());
    }

    public void setTextAlign(TextAlign align) {
        CTTextParagraphProperties pr;
        CTTextParagraphProperties cTTextParagraphProperties = pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (align == null) {
            if (pr.isSetAlgn()) {
                pr.unsetAlgn();
            }
        } else {
            pr.setAlgn(STTextAlignType.Enum.forInt((int)(align.ordinal() + 1)));
        }
    }

    public String getBulletFont() {
        ParagraphPropertyFetcher fetcher = new ParagraphPropertyFetcher(this.getLevel()){

            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetBuFont()) {
                    this.setValue(props.getBuFont().getTypeface());
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return (String)fetcher.getValue();
    }

    public void setBulletFont(String typeface) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextFont font = pr.isSetBuFont() ? pr.getBuFont() : pr.addNewBuFont();
        font.setTypeface(typeface);
    }

    public String getBulletCharacter() {
        ParagraphPropertyFetcher fetcher = new ParagraphPropertyFetcher(this.getLevel()){

            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetBuChar()) {
                    this.setValue(props.getBuChar().getChar());
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return (String)fetcher.getValue();
    }

    public void setBulletCharacter(String str) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextCharBullet c = pr.isSetBuChar() ? pr.getBuChar() : pr.addNewBuChar();
        c.setChar(str);
    }

    public Color getBulletFontColor() {
        final XSLFTheme theme = this.getParentShape().getSheet().getTheme();
        ParagraphPropertyFetcher fetcher = new ParagraphPropertyFetcher(this.getLevel()){

            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetBuClr()) {
                    XSLFColor c = new XSLFColor((XmlObject)props.getBuClr(), theme, null);
                    this.setValue(c.getColor());
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return (Color)fetcher.getValue();
    }

    public void setBulletFontColor(Color color) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTColor c = pr.isSetBuClr() ? pr.getBuClr() : pr.addNewBuClr();
        CTSRgbColor clr = c.isSetSrgbClr() ? c.getSrgbClr() : c.addNewSrgbClr();
        clr.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
    }

    public double getBulletFontSize() {
        ParagraphPropertyFetcher fetcher = new ParagraphPropertyFetcher(this.getLevel()){

            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetBuSzPct()) {
                    this.setValue(new Double((double)props.getBuSzPct().getVal() * 0.001));
                    return true;
                }
                if (props.isSetBuSzPts()) {
                    this.setValue(new Double((double)(-props.getBuSzPts().getVal()) * 0.01));
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return fetcher.getValue() == null ? 100.0 : (Double)fetcher.getValue();
    }

    public void setBulletFontSize(double bulletSize) {
        CTTextParagraphProperties pr;
        CTTextParagraphProperties cTTextParagraphProperties = pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (bulletSize >= 0.0) {
            CTTextBulletSizePercent pt = pr.isSetBuSzPct() ? pr.getBuSzPct() : pr.addNewBuSzPct();
            pt.setVal((int)(bulletSize * 1000.0));
            if (pr.isSetBuSzPts()) {
                pr.unsetBuSzPts();
            }
        } else {
            CTTextBulletSizePoint pt = pr.isSetBuSzPts() ? pr.getBuSzPts() : pr.addNewBuSzPts();
            pt.setVal((int)(-bulletSize * 100.0));
            if (pr.isSetBuSzPct()) {
                pr.unsetBuSzPct();
            }
        }
    }

    public void setIndent(double value) {
        CTTextParagraphProperties pr;
        CTTextParagraphProperties cTTextParagraphProperties = pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (value == -1.0) {
            if (pr.isSetIndent()) {
                pr.unsetIndent();
            }
        } else {
            pr.setIndent(Units.toEMU(value));
        }
    }

    public double getIndent() {
        ParagraphPropertyFetcher fetcher = new ParagraphPropertyFetcher(this.getLevel()){

            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetIndent()) {
                    this.setValue(new Double(Units.toPoints(props.getIndent())));
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return fetcher.getValue() == null ? 0.0 : (Double)fetcher.getValue();
    }

    public void setLeftMargin(double value) {
        CTTextParagraphProperties pr;
        CTTextParagraphProperties cTTextParagraphProperties = pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (value == -1.0) {
            if (pr.isSetMarL()) {
                pr.unsetMarL();
            }
        } else {
            pr.setMarL(Units.toEMU(value));
        }
    }

    public double getLeftMargin() {
        ParagraphPropertyFetcher fetcher = new ParagraphPropertyFetcher(this.getLevel()){

            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetMarL()) {
                    double val = Units.toPoints(props.getMarL());
                    this.setValue(new Double(val));
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return fetcher.getValue() == null ? 0.0 : (Double)fetcher.getValue();
    }

    public double getDefaultTabSize() {
        ParagraphPropertyFetcher fetcher = new ParagraphPropertyFetcher(this.getLevel()){

            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetDefTabSz()) {
                    double val = Units.toPoints(props.getDefTabSz());
                    this.setValue(new Double(val));
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return fetcher.getValue() == null ? 0.0 : (Double)fetcher.getValue();
    }

    public double getTabStop(final int idx) {
        ParagraphPropertyFetcher fetcher = new ParagraphPropertyFetcher(this.getLevel()){

            public boolean fetch(CTTextParagraphProperties props) {
                CTTextTabStopList tabStops;
                if (props.isSetTabLst() && idx < (tabStops = props.getTabLst()).sizeOfTabArray()) {
                    CTTextTabStop ts = tabStops.getTabArray(idx);
                    double val = Units.toPoints(ts.getPos());
                    this.setValue(new Double(val));
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return fetcher.getValue() == null ? this.getDefaultTabSize() : ((Double)fetcher.getValue()).doubleValue();
    }

    public void setLineSpacing(double linespacing) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextSpacing spc = CTTextSpacing.Factory.newInstance();
        if (linespacing >= 0.0) {
            spc.addNewSpcPct().setVal((int)(linespacing * 1000.0));
        } else {
            spc.addNewSpcPts().setVal((int)(-linespacing * 100.0));
        }
        pr.setLnSpc(spc);
    }

    public double getLineSpacing() {
        CTTextNormalAutofit normAutofit;
        double lnSpc;
        ParagraphPropertyFetcher fetcher = new ParagraphPropertyFetcher(this.getLevel()){

            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetLnSpc()) {
                    CTTextSpacing spc = props.getLnSpc();
                    if (spc.isSetSpcPct()) {
                        this.setValue(new Double((double)spc.getSpcPct().getVal() * 0.001));
                    } else if (spc.isSetSpcPts()) {
                        this.setValue(new Double((double)(-spc.getSpcPts().getVal()) * 0.01));
                    }
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        double d = lnSpc = fetcher.getValue() == null ? 100.0 : (Double)fetcher.getValue();
        if (lnSpc > 0.0 && (normAutofit = this.getParentShape().getTextBodyPr().getNormAutofit()) != null) {
            double scale = 1.0 - (double)normAutofit.getLnSpcReduction() / 100000.0;
            lnSpc *= scale;
        }
        return lnSpc;
    }

    public void setSpaceBefore(double spaceBefore) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextSpacing spc = CTTextSpacing.Factory.newInstance();
        if (spaceBefore >= 0.0) {
            spc.addNewSpcPct().setVal((int)(spaceBefore * 1000.0));
        } else {
            spc.addNewSpcPts().setVal((int)(-spaceBefore * 100.0));
        }
        pr.setSpcBef(spc);
    }

    public double getSpaceBefore() {
        ParagraphPropertyFetcher fetcher = new ParagraphPropertyFetcher(this.getLevel()){

            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetSpcBef()) {
                    CTTextSpacing spc = props.getSpcBef();
                    if (spc.isSetSpcPct()) {
                        this.setValue(new Double((double)spc.getSpcPct().getVal() * 0.001));
                    } else if (spc.isSetSpcPts()) {
                        this.setValue(new Double((double)(-spc.getSpcPts().getVal()) * 0.01));
                    }
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        double spcBef = fetcher.getValue() == null ? 0.0 : (Double)fetcher.getValue();
        return spcBef;
    }

    public void setSpaceAfter(double spaceAfter) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextSpacing spc = CTTextSpacing.Factory.newInstance();
        if (spaceAfter >= 0.0) {
            spc.addNewSpcPct().setVal((int)(spaceAfter * 1000.0));
        } else {
            spc.addNewSpcPts().setVal((int)(-spaceAfter * 100.0));
        }
        pr.setSpcAft(spc);
    }

    public double getSpaceAfter() {
        ParagraphPropertyFetcher fetcher = new ParagraphPropertyFetcher(this.getLevel()){

            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetSpcAft()) {
                    CTTextSpacing spc = props.getSpcAft();
                    if (spc.isSetSpcPct()) {
                        this.setValue(new Double((double)spc.getSpcPct().getVal() * 0.001));
                    } else if (spc.isSetSpcPts()) {
                        this.setValue(new Double((double)(-spc.getSpcPts().getVal()) * 0.01));
                    }
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return fetcher.getValue() == null ? 0.0 : (Double)fetcher.getValue();
    }

    public void setLevel(int level) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        pr.setLvl(level);
    }

    public int getLevel() {
        CTTextParagraphProperties pr = this._p.getPPr();
        if (pr == null) {
            return 0;
        }
        return pr.getLvl();
    }

    public boolean isBullet() {
        ParagraphPropertyFetcher fetcher = new ParagraphPropertyFetcher(this.getLevel()){

            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetBuNone()) {
                    this.setValue(new Boolean(false));
                    return true;
                }
                if (props.isSetBuFont() || props.isSetBuChar()) {
                    this.setValue(new Boolean(true));
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return fetcher.getValue() == null ? false : (Boolean)fetcher.getValue();
    }

    public void setBullet(boolean flag) {
        CTTextParagraphProperties pr;
        if (this.isBullet() == flag) {
            return;
        }
        CTTextParagraphProperties cTTextParagraphProperties = pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (!flag) {
            pr.addNewBuNone();
        } else {
            pr.addNewBuFont().setTypeface("Arial");
            pr.addNewBuChar().setChar("\u2022");
        }
    }

    public void setBulletAutoNumber(ListAutoNumber scheme, int startAt) {
        if (startAt < 1) {
            throw new IllegalArgumentException("Start Number must be greater or equal that 1");
        }
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextAutonumberBullet lst = pr.isSetBuAutoNum() ? pr.getBuAutoNum() : pr.addNewBuAutoNum();
        lst.setType(STTextAutonumberScheme.Enum.forInt((int)(scheme.ordinal() + 1)));
        lst.setStartAt(startAt);
    }

    public String toString() {
        return "[" + this.getClass() + "]" + this.getText();
    }

    List getTextLines() {
        return this._lines;
    }

    double getWrappingWidth(boolean firstLine, Graphics2D graphics) {
        double width;
        double leftInset = this._shape.getLeftInset();
        double rightInset = this._shape.getRightInset();
        RenderableShape rShape = new RenderableShape(this._shape);
        Rectangle2D anchor = rShape.getAnchor(graphics);
        double leftMargin = this.getLeftMargin();
        double indent = this.getIndent();
        if (!this._shape.getWordWrap()) {
            width = this._shape.getSheet().getSlideShow().getPageSize().getWidth() - anchor.getX();
        } else {
            width = anchor.getWidth() - leftInset - rightInset - leftMargin;
            if (firstLine) {
                if (this.isBullet()) {
                    if (indent > 0.0) {
                        width -= indent;
                    }
                } else if (indent > 0.0) {
                    width -= indent;
                } else if (indent < 0.0) {
                    width += leftMargin;
                }
            }
        }
        return width;
    }

    public double draw(Graphics2D graphics, double x, double y) {
        double leftInset = this._shape.getLeftInset();
        double rightInset = this._shape.getRightInset();
        RenderableShape rShape = new RenderableShape(this._shape);
        Rectangle2D anchor = rShape.getAnchor(graphics);
        double penY = y;
        double leftMargin = this.getLeftMargin();
        boolean firstLine = true;
        double indent = this.getIndent();
        double spacing = this.getLineSpacing();
        Iterator iterator = this._lines.iterator();
        while (iterator.hasNext()) {
            TextAlign textAlign;
            TextFragment line = (TextFragment)iterator.next();
            double penX = x + leftMargin;
            if (firstLine) {
                if (this._bullet != null) {
                    if (indent < 0.0) {
                        this._bullet.draw(graphics, penX + indent, penY);
                    } else if (indent > 0.0) {
                        this._bullet.draw(graphics, penX, penY);
                        penX += indent;
                    } else {
                        this._bullet.draw(graphics, penX, penY);
                        penX += (double)(this._bullet._layout.getAdvance() + 1.0f);
                    }
                } else {
                    penX += indent;
                }
            }
            if (TextAlign.CENTER.equals(textAlign = this.getTextAlign())) {
                penX += (anchor.getWidth() - leftMargin - (double)line.getWidth() - leftInset - rightInset) / 2.0;
            } else if (TextAlign.RIGHT.equals(textAlign)) {
                penX += anchor.getWidth() - (double)line.getWidth() - leftInset - rightInset;
            }
            line.draw(graphics, penX, penY);
            penY = spacing > 0.0 ? (penY += spacing * 0.01 * (double)line.getHeight()) : (penY += -spacing);
            firstLine = false;
        }
        return penY - y;
    }

    AttributedString getAttributedString(Graphics2D graphics) {
        String text = this.getRenderableText();
        AttributedString string = new AttributedString(text);
        XSLFFontManager fontHandler = (XSLFFontManager)graphics.getRenderingHint(XSLFRenderingHint.FONT_HANDLER);
        int startIndex = 0;
        Iterator iterator = this._runs.iterator();
        while (iterator.hasNext()) {
            XSLFTextRun run = (XSLFTextRun)iterator.next();
            int length = run.getRenderableText().length();
            if (length == 0) continue;
            int endIndex = startIndex + length;
            string.addAttribute(TextAttribute.FOREGROUND, run.getFontColor(), startIndex, endIndex);
            String fontFamily = run.getFontFamily();
            if (fontHandler != null) {
                fontFamily = fontHandler.getRendererableFont(fontFamily, run.getPitchAndFamily());
            }
            string.addAttribute(TextAttribute.FAMILY, fontFamily, startIndex, endIndex);
            float fontSz = (float)run.getFontSize();
            string.addAttribute(TextAttribute.SIZE, new Float(fontSz), startIndex, endIndex);
            if (run.isBold()) {
                string.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, startIndex, endIndex);
            }
            if (run.isItalic()) {
                string.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, startIndex, endIndex);
            }
            if (run.isUnderline()) {
                string.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, startIndex, endIndex);
                string.addAttribute(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_TWO_PIXEL, startIndex, endIndex);
            }
            if (run.isStrikethrough()) {
                string.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON, startIndex, endIndex);
            }
            if (run.isSubscript()) {
                string.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB, startIndex, endIndex);
            }
            if (run.isSuperscript()) {
                string.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, startIndex, endIndex);
            }
            startIndex = endIndex;
        }
        return string;
    }

    private void ensureNotEmpty() {
        XSLFTextRun r = this.addNewTextRun();
        r.setText(" ");
        CTTextCharacterProperties endPr = this._p.getEndParaRPr();
        if (endPr != null && endPr.isSetSz()) {
            r.setFontSize(endPr.getSz() / 100);
        }
    }

    List breakText(Graphics2D graphics) {
        int endIndex;
        String text;
        boolean emptyParagraph;
        this._lines = new ArrayList();
        boolean bl = emptyParagraph = this._runs.size() == 0;
        if (this._runs.size() == 0) {
            this.ensureNotEmpty();
        }
        if ((text = this.getRenderableText()).length() == 0) {
            return this._lines;
        }
        AttributedString at = this.getAttributedString(graphics);
        AttributedCharacterIterator it = at.getIterator();
        LineBreakMeasurer measurer = new LineBreakMeasurer(it, graphics.getFontRenderContext());
        do {
            TextAlign hAlign;
            TextLayout layout;
            int nextBreak;
            int startIndex = measurer.getPosition();
            double wrappingWidth = this.getWrappingWidth(this._lines.size() == 0, graphics) + 1.0;
            if (wrappingWidth < 0.0) {
                wrappingWidth = 1.0;
            }
            if ((nextBreak = text.indexOf(10, startIndex + 1)) == -1) {
                nextBreak = it.getEndIndex();
            }
            if ((layout = measurer.nextLayout((float)wrappingWidth, nextBreak, true)) == null) {
                layout = measurer.nextLayout((float)wrappingWidth, nextBreak, false);
            }
            if (layout == null) break;
            endIndex = measurer.getPosition();
            if (endIndex < it.getEndIndex() && text.charAt(endIndex) == '\n') {
                measurer.setPosition(endIndex + 1);
            }
            if ((hAlign = this.getTextAlign()) == TextAlign.JUSTIFY || hAlign == TextAlign.JUSTIFY_LOW) {
                layout = layout.getJustifiedLayout((float)wrappingWidth);
            }
            AttributedString str = new AttributedString(it, startIndex, endIndex);
            TextFragment line = new TextFragment(layout, emptyParagraph ? null : str);
            this._lines.add(line);
            this._maxLineHeight = Math.max(this._maxLineHeight, (double)line.getHeight());
        } while (endIndex != it.getEndIndex());
        if (this.isBullet() && !emptyParagraph) {
            String buCharacter = this.getBulletCharacter();
            String buFont = this.getBulletFont();
            if (buFont == null) {
                buFont = ((XSLFTextRun)this.getTextRuns().get(0)).getFontFamily();
            }
            if (buCharacter != null && buFont != null && this._lines.size() > 0) {
                AttributedString str = new AttributedString(buCharacter);
                TextFragment firstLine = (TextFragment)this._lines.get(0);
                AttributedCharacterIterator bit = firstLine._str.getIterator();
                Color buColor = this.getBulletFontColor();
                str.addAttribute(TextAttribute.FOREGROUND, buColor == null ? bit.getAttribute(TextAttribute.FOREGROUND) : buColor);
                str.addAttribute(TextAttribute.FAMILY, buFont);
                float fontSize = ((Float)bit.getAttribute(TextAttribute.SIZE)).floatValue();
                float buSz = (float)this.getBulletFontSize();
                fontSize = buSz > 0.0f ? (float)((double)fontSize * ((double)buSz * 0.01)) : -buSz;
                str.addAttribute(TextAttribute.SIZE, new Float(fontSize));
                TextLayout layout = new TextLayout(str.getIterator(), graphics.getFontRenderContext());
                this._bullet = new TextFragment(layout, str);
            }
        }
        return this._lines;
    }

    CTTextParagraphProperties getDefaultMasterStyle() {
        String defaultStyleSelector;
        CTPlaceholder ph = this._shape.getCTPlaceholder();
        if (ph == null) {
            defaultStyleSelector = "otherStyle";
        } else {
            switch (ph.getType().intValue()) {
                case 1: 
                case 3: {
                    defaultStyleSelector = "titleStyle";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    defaultStyleSelector = "otherStyle";
                    break;
                }
                default: {
                    defaultStyleSelector = "bodyStyle";
                }
            }
        }
        int level = this.getLevel();
        XSLFSheet masterSheet = this._shape.getSheet();
        while (masterSheet.getMasterSheet() != null) {
            masterSheet = masterSheet.getMasterSheet();
        }
        XmlObject[] o = masterSheet.getXmlObject().selectPath("declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' declare namespace a='http://schemas.openxmlformats.org/drawingml/2006/main' .//p:txStyles/p:" + defaultStyleSelector + "/a:lvl" + (level + 1) + "pPr");
        if (o.length == 1) {
            return (CTTextParagraphProperties)o[0];
        }
        throw new IllegalArgumentException("Failed to fetch default style for " + defaultStyleSelector + " and level=" + level);
    }

    private boolean fetchParagraphProperty(ParagraphPropertyFetcher visitor) {
        XSLFTextShape shape;
        boolean ok = false;
        if (this._p.isSetPPr()) {
            ok = visitor.fetch(this._p.getPPr());
        }
        if (!ok && !(ok = (shape = this.getParentShape()).fetchShapeProperty(visitor))) {
            CTTextParagraphProperties defaultProps;
            XMLSlideShow ppt;
            CTTextParagraphProperties themeProps;
            CTPlaceholder ph = shape.getCTPlaceholder();
            if (ph == null && (themeProps = (ppt = this.getParentShape().getSheet().getSlideShow()).getDefaultParagraphStyle(this.getLevel())) != null) {
                ok = visitor.fetch(themeProps);
            }
            if (!ok && (defaultProps = this.getDefaultMasterStyle()) != null) {
                ok = visitor.fetch(defaultProps);
            }
        }
        return ok;
    }

    void copy(XSLFTextParagraph p) {
        double lineSpacing;
        double spaceBefore;
        double spaceAfter;
        double indent;
        double leftMargin;
        boolean isBullet;
        TextAlign srcAlign = p.getTextAlign();
        if (srcAlign != this.getTextAlign()) {
            this.setTextAlign(srcAlign);
        }
        if ((isBullet = p.isBullet()) != this.isBullet()) {
            this.setBullet(isBullet);
            if (isBullet) {
                double buSize;
                Color buColor;
                String buChar;
                String buFont = p.getBulletFont();
                if (buFont != null && !buFont.equals(this.getBulletFont())) {
                    this.setBulletFont(buFont);
                }
                if ((buChar = p.getBulletCharacter()) != null && !buChar.equals(this.getBulletCharacter())) {
                    this.setBulletCharacter(buChar);
                }
                if ((buColor = p.getBulletFontColor()) != null && !buColor.equals(this.getBulletFontColor())) {
                    this.setBulletFontColor(buColor);
                }
                if ((buSize = p.getBulletFontSize()) != this.getBulletFontSize()) {
                    this.setBulletFontSize(buSize);
                }
            }
        }
        if ((leftMargin = p.getLeftMargin()) != this.getLeftMargin()) {
            this.setLeftMargin(leftMargin);
        }
        if ((indent = p.getIndent()) != this.getIndent()) {
            this.setIndent(indent);
        }
        if ((spaceAfter = p.getSpaceAfter()) != this.getSpaceAfter()) {
            this.setSpaceAfter(spaceAfter);
        }
        if ((spaceBefore = p.getSpaceBefore()) != this.getSpaceBefore()) {
            this.setSpaceBefore(spaceBefore);
        }
        if ((lineSpacing = p.getLineSpacing()) != this.getLineSpacing()) {
            this.setLineSpacing(lineSpacing);
        }
        List srcR = p.getTextRuns();
        List tgtR = this.getTextRuns();
        int i = 0;
        while (i < srcR.size()) {
            XSLFTextRun r1 = (XSLFTextRun)srcR.get(i);
            XSLFTextRun r2 = (XSLFTextRun)tgtR.get(i);
            r2.copy(r1);
            ++i;
        }
    }
}

