/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.util.HashMap;
import java.util.Map;

public class ParagraphAlignment {
    public static final ParagraphAlignment LEFT = new ParagraphAlignment(1);
    public static final ParagraphAlignment CENTER = new ParagraphAlignment(2);
    public static final ParagraphAlignment RIGHT = new ParagraphAlignment(3);
    public static final ParagraphAlignment BOTH = new ParagraphAlignment(4);
    public static final ParagraphAlignment MEDIUM_KASHIDA = new ParagraphAlignment(5);
    public static final ParagraphAlignment DISTRIBUTE = new ParagraphAlignment(6);
    public static final ParagraphAlignment NUM_TAB = new ParagraphAlignment(7);
    public static final ParagraphAlignment HIGH_KASHIDA = new ParagraphAlignment(8);
    public static final ParagraphAlignment LOW_KASHIDA = new ParagraphAlignment(9);
    public static final ParagraphAlignment THAI_DISTRIBUTE = new ParagraphAlignment(10);
    private final int value;
    private static Map imap = new HashMap();

    static {
        int i = 0;
        while (i < ParagraphAlignment.values().length) {
            ParagraphAlignment p = ParagraphAlignment.values()[i];
            imap.put(new Integer(p.getValue()), p);
            ++i;
        }
    }

    private ParagraphAlignment(int val) {
        this.value = val;
    }

    public int getValue() {
        return this.value;
    }

    public static ParagraphAlignment[] values() {
        return new ParagraphAlignment[]{LEFT, CENTER, RIGHT, BOTH, MEDIUM_KASHIDA, DISTRIBUTE, NUM_TAB, HIGH_KASHIDA, LOW_KASHIDA, THAI_DISTRIBUTE};
    }

    public static ParagraphAlignment valueOf(int type) {
        ParagraphAlignment err = (ParagraphAlignment)imap.get(new Integer(type));
        if (err == null) {
            throw new IllegalArgumentException("Unknown paragraph alignment: " + type);
        }
        return err;
    }
}

