/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataValidation;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STDataValidationErrorStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STDataValidationOperator;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STDataValidationType;

public class XSSFDataValidation
implements DataValidation {
    private CTDataValidation ctDdataValidation;
    private XSSFDataValidationConstraint validationConstraint;
    private CellRangeAddressList regions;
    static Map operatorTypeMappings;
    static Map operatorTypeReverseMappings;
    static Map validationTypeMappings;
    static Map validationTypeReverseMappings;
    static Map errorStyleMappings;

    static {
        Map.Entry entry;
        operatorTypeMappings = new HashMap();
        operatorTypeReverseMappings = new HashMap();
        validationTypeMappings = new HashMap();
        validationTypeReverseMappings = new HashMap();
        errorStyleMappings = new HashMap();
        errorStyleMappings.put(new Integer(2), STDataValidationErrorStyle.INFORMATION);
        errorStyleMappings.put(new Integer(0), STDataValidationErrorStyle.STOP);
        errorStyleMappings.put(new Integer(1), STDataValidationErrorStyle.WARNING);
        operatorTypeMappings.put(new Integer(0), STDataValidationOperator.BETWEEN);
        operatorTypeMappings.put(new Integer(1), STDataValidationOperator.NOT_BETWEEN);
        operatorTypeMappings.put(new Integer(2), STDataValidationOperator.EQUAL);
        operatorTypeMappings.put(new Integer(3), STDataValidationOperator.NOT_EQUAL);
        operatorTypeMappings.put(new Integer(4), STDataValidationOperator.GREATER_THAN);
        operatorTypeMappings.put(new Integer(6), STDataValidationOperator.GREATER_THAN_OR_EQUAL);
        operatorTypeMappings.put(new Integer(5), STDataValidationOperator.LESS_THAN);
        operatorTypeMappings.put(new Integer(7), STDataValidationOperator.LESS_THAN_OR_EQUAL);
        Iterator iterator = operatorTypeMappings.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            operatorTypeReverseMappings.put(entry.getValue(), entry.getKey());
        }
        validationTypeMappings.put(new Integer(7), STDataValidationType.CUSTOM);
        validationTypeMappings.put(new Integer(4), STDataValidationType.DATE);
        validationTypeMappings.put(new Integer(2), STDataValidationType.DECIMAL);
        validationTypeMappings.put(new Integer(3), STDataValidationType.LIST);
        validationTypeMappings.put(new Integer(0), STDataValidationType.NONE);
        validationTypeMappings.put(new Integer(6), STDataValidationType.TEXT_LENGTH);
        validationTypeMappings.put(new Integer(5), STDataValidationType.TIME);
        validationTypeMappings.put(new Integer(1), STDataValidationType.WHOLE);
        iterator = validationTypeMappings.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            validationTypeReverseMappings.put(entry.getValue(), entry.getKey());
        }
    }

    XSSFDataValidation(CellRangeAddressList regions, CTDataValidation ctDataValidation) {
        this.validationConstraint = this.getConstraint(ctDataValidation);
        this.ctDdataValidation = ctDataValidation;
        this.regions = regions;
        this.ctDdataValidation.setErrorStyle(STDataValidationErrorStyle.STOP);
        this.ctDdataValidation.setAllowBlank(true);
    }

    public XSSFDataValidation(XSSFDataValidationConstraint constraint, CellRangeAddressList regions, CTDataValidation ctDataValidation) {
        this.validationConstraint = constraint;
        this.ctDdataValidation = ctDataValidation;
        this.regions = regions;
        this.ctDdataValidation.setErrorStyle(STDataValidationErrorStyle.STOP);
        this.ctDdataValidation.setAllowBlank(true);
    }

    CTDataValidation getCtDdataValidation() {
        return this.ctDdataValidation;
    }

    public void createErrorBox(String title, String text) {
        this.ctDdataValidation.setErrorTitle(title);
        this.ctDdataValidation.setError(text);
    }

    public void createPromptBox(String title, String text) {
        this.ctDdataValidation.setPromptTitle(title);
        this.ctDdataValidation.setPrompt(text);
    }

    public boolean getEmptyCellAllowed() {
        return this.ctDdataValidation.getAllowBlank();
    }

    public String getErrorBoxText() {
        return this.ctDdataValidation.getError();
    }

    public String getErrorBoxTitle() {
        return this.ctDdataValidation.getErrorTitle();
    }

    public int getErrorStyle() {
        return this.ctDdataValidation.getErrorStyle().intValue();
    }

    public String getPromptBoxText() {
        return this.ctDdataValidation.getPrompt();
    }

    public String getPromptBoxTitle() {
        return this.ctDdataValidation.getPromptTitle();
    }

    public boolean getShowErrorBox() {
        return this.ctDdataValidation.getShowErrorMessage();
    }

    public boolean getShowPromptBox() {
        return this.ctDdataValidation.getShowInputMessage();
    }

    public boolean getSuppressDropDownArrow() {
        return !this.ctDdataValidation.getShowDropDown();
    }

    public DataValidationConstraint getValidationConstraint() {
        return this.validationConstraint;
    }

    public void setEmptyCellAllowed(boolean allowed) {
        this.ctDdataValidation.setAllowBlank(allowed);
    }

    public void setErrorStyle(int errorStyle) {
        this.ctDdataValidation.setErrorStyle((STDataValidationErrorStyle.Enum)errorStyleMappings.get(new Integer(errorStyle)));
    }

    public void setShowErrorBox(boolean show) {
        this.ctDdataValidation.setShowErrorMessage(show);
    }

    public void setShowPromptBox(boolean show) {
        this.ctDdataValidation.setShowInputMessage(show);
    }

    public void setSuppressDropDownArrow(boolean suppress) {
        if (this.validationConstraint.getValidationType() == 3) {
            this.ctDdataValidation.setShowDropDown(!suppress);
        }
    }

    public CellRangeAddressList getRegions() {
        return this.regions;
    }

    public String prettyPrint() {
        StringBuffer builder = new StringBuffer();
        int i = 0;
        while (i < this.regions.getCellRangeAddresses().length) {
            CellRangeAddress address = this.regions.getCellRangeAddresses()[i];
            builder.append(address.formatAsString());
            ++i;
        }
        builder.append(" => ");
        builder.append(this.validationConstraint.prettyPrint());
        return builder.toString();
    }

    private XSSFDataValidationConstraint getConstraint(CTDataValidation ctDataValidation) {
        XSSFDataValidationConstraint constraint = null;
        String formula1 = ctDataValidation.getFormula1();
        String formula2 = ctDataValidation.getFormula2();
        STDataValidationOperator.Enum operator = ctDataValidation.getOperator();
        STDataValidationType.Enum type = ctDataValidation.getType();
        Integer validationType = (Integer)validationTypeReverseMappings.get(type);
        Integer operatorType = (Integer)operatorTypeReverseMappings.get(operator);
        constraint = new XSSFDataValidationConstraint(validationType, operatorType, formula1, formula2);
        return constraint;
    }
}

