/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.poi.util.IOUtils;

public final class OOXMLLite {
    private static final Field _classes;
    private File _destDest;
    private File _testDir;
    private File _ooxmlJar;
    static /* synthetic */ Class class$0;

    static {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.ClassLoader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            _classes = clazz.getDeclaredField("classes");
            _classes.setAccessible(true);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    OOXMLLite(String dest, String test, String ooxmlJar) {
        this._destDest = new File(dest);
        this._testDir = new File(test);
        this._ooxmlJar = new File(ooxmlJar);
    }

    public static void main(String[] args) throws IOException {
        String dest = null;
        String test = null;
        String ooxml = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-dest")) {
                dest = args[++i];
            } else if (args[i].equals("-test")) {
                test = args[++i];
            } else if (args[i].equals("-ooxml")) {
                ooxml = args[++i];
            }
            ++i;
        }
        OOXMLLite builder = new OOXMLLite(dest, test, ooxml);
        builder.build();
    }

    void build() throws IOException {
        Object cls;
        ArrayList lst = new ArrayList();
        System.out.println("Collecting unit tests from " + this._testDir);
        OOXMLLite.collectTests(this._testDir, this._testDir, lst, ".+?\\.Test.+?\\.class$");
        TestSuite suite = new TestSuite();
        Iterator iterator = lst.iterator();
        while (iterator.hasNext()) {
            String arg = (String)iterator.next();
            if (arg.indexOf(36) != -1) continue;
            cls = arg.replaceAll("\\.class", "");
            try {
                Class<?> test = Class.forName((String)cls);
                suite.addTestSuite(test);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        TestRunner.run((Test)suite);
        System.out.println("Copying classes to " + this._destDest);
        Map classes = OOXMLLite.getLoadedClasses(this._ooxmlJar.getName());
        Iterator iterator2 = classes.values().iterator();
        while (iterator2.hasNext()) {
            cls = (Class)iterator2.next();
            String className = ((Class)cls).getName();
            String classRef = String.valueOf(className.replace('.', '/')) + ".class";
            File destFile = new File(this._destDest, classRef);
            OOXMLLite.copyFile(((Class)cls).getResourceAsStream(String.valueOf('/') + classRef), destFile);
            if (!((Class)cls).isInterface()) continue;
            int i = 0;
            while (i < ((Class)cls).getDeclaredClasses().length) {
                Class<?> fc = ((Class)cls).getDeclaredClasses()[i];
                className = fc.getName();
                classRef = String.valueOf(className.replace('.', '/')) + ".class";
                destFile = new File(this._destDest, classRef);
                OOXMLLite.copyFile(fc.getResourceAsStream(String.valueOf('/') + classRef), destFile);
                ++i;
            }
        }
        System.out.println("Copying .xsb resources");
        JarFile jar = new JarFile(this._ooxmlJar);
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry je = e.nextElement();
            if (!je.getName().matches("schemaorg_apache_xmlbeans/system/\\w+/\\w+\\.xsb")) continue;
            File destFile = new File(this._destDest, je.getName());
            OOXMLLite.copyFile(jar.getInputStream(je), destFile);
        }
        jar.close();
    }

    private static void collectTests(File root, File arg, List out, String ptrn) {
        if (arg.isDirectory()) {
            int i = 0;
            while (i < arg.listFiles().length) {
                File f = arg.listFiles()[i];
                OOXMLLite.collectTests(root, f, out, ptrn);
                ++i;
            }
        } else {
            String prefix;
            String path = arg.getAbsolutePath();
            String cls = path.substring((prefix = root.getAbsolutePath()).length() + 1).replace(File.separator.toCharArray()[0], '.');
            if (cls.matches(ptrn)) {
                out.add(cls);
            }
        }
    }

    private static Map getLoadedClasses(String ptrn) {
        ClassLoader appLoader = ClassLoader.getSystemClassLoader();
        try {
            Vector classes = (Vector)_classes.get(appLoader);
            HashMap<String, Class> map = new HashMap<String, Class>();
            Iterator iterator = classes.iterator();
            while (iterator.hasNext()) {
                Class cls = (Class)iterator.next();
                String jar = cls.getProtectionDomain().getCodeSource().getLocation().toString();
                if (jar.indexOf(ptrn) == -1) continue;
                map.put(cls.getName(), cls);
            }
            return map;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyFile(InputStream srcStream, File destFile) throws IOException {
        File destDirectory = destFile.getParentFile();
        destDirectory.mkdirs();
        FileOutputStream destStream = new FileOutputStream(destFile);
        try {
            IOUtils.copy((InputStream)srcStream, (OutputStream)destStream);
        }
        finally {
            ((OutputStream)destStream).close();
        }
    }
}

