/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

public class WorkbookUtil {
    public static final String createSafeSheetName(String nameProposal) {
        if (nameProposal == null) {
            return "null";
        }
        if (nameProposal.length() < 1) {
            return "empty";
        }
        int length = Math.min(31, nameProposal.length());
        String shortenname = nameProposal.substring(0, length);
        StringBuffer result = new StringBuffer(shortenname);
        int i = 0;
        while (i < length) {
            char ch = result.charAt(i);
            switch (ch) {
                case '*': 
                case '/': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': {
                    result.setCharAt(i, ' ');
                    break;
                }
                case '\'': {
                    if (i != 0 && i != length - 1) break;
                    result.setCharAt(i, ' ');
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static void validateSheetName(String sheetName) {
        if (sheetName == null) {
            throw new IllegalArgumentException("sheetName must not be null");
        }
        int len = sheetName.length();
        if (len < 1) {
            throw new IllegalArgumentException("sheetName must not be empty string");
        }
        int i = 0;
        while (i < len) {
            block7: {
                char ch = sheetName.charAt(i);
                switch (ch) {
                    case '*': 
                    case '/': 
                    case ':': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': {
                        break;
                    }
                    default: {
                        break block7;
                    }
                }
                throw new IllegalArgumentException("Invalid char (" + ch + ") found at index (" + i + ") in sheet name '" + sheetName + "'");
            }
            ++i;
        }
        if (sheetName.charAt(0) == '\'' || sheetName.charAt(len - 1) == '\'') {
            throw new IllegalArgumentException("Invalid sheet name '" + sheetName + "'. Sheet names must not begin or end with (').");
        }
    }

    public static void validateSheetState(int state) {
        switch (state) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Ivalid sheet state : " + state + "\n" + "Sheet state must beone of the Workbook.SHEET_STATE_* constants");
            }
        }
    }
}

