/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel;

public class FontCharset {
    public static final FontCharset ANSI = new FontCharset(0);
    public static final FontCharset DEFAULT = new FontCharset(1);
    public static final FontCharset SYMBOL = new FontCharset(2);
    public static final FontCharset MAC = new FontCharset(77);
    public static final FontCharset SHIFTJIS = new FontCharset(128);
    public static final FontCharset HANGEUL = new FontCharset(129);
    public static final FontCharset JOHAB = new FontCharset(130);
    public static final FontCharset GB2312 = new FontCharset(134);
    public static final FontCharset CHINESEBIG5 = new FontCharset(136);
    public static final FontCharset GREEK = new FontCharset(161);
    public static final FontCharset TURKISH = new FontCharset(162);
    public static final FontCharset VIETNAMESE = new FontCharset(163);
    public static final FontCharset HEBREW = new FontCharset(177);
    public static final FontCharset ARABIC = new FontCharset(178);
    public static final FontCharset BALTIC = new FontCharset(186);
    public static final FontCharset RUSSIAN = new FontCharset(204);
    public static final FontCharset THAI = new FontCharset(222);
    public static final FontCharset EASTEUROPE = new FontCharset(238);
    public static final FontCharset OEM = new FontCharset(255);
    private int charset;
    private static FontCharset[] _table = new FontCharset[256];

    static {
        int i = 0;
        while (i < FontCharset.values().length) {
            FontCharset c;
            FontCharset._table[c.getValue()] = c = FontCharset.values()[i];
            ++i;
        }
    }

    private static FontCharset[] values() {
        return new FontCharset[]{ANSI, DEFAULT, SYMBOL, MAC, SHIFTJIS, HANGEUL, JOHAB, GB2312, CHINESEBIG5, GREEK, TURKISH, VIETNAMESE, HEBREW, ARABIC, BALTIC, RUSSIAN, THAI, EASTEUROPE, OEM};
    }

    private FontCharset(int value) {
        this.charset = value;
    }

    public int getValue() {
        return this.charset;
    }

    public static FontCharset valueOf(int value) {
        return _table[value];
    }
}

