/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.hssf.record.cf.BorderFormatting;
import org.apache.poi.hssf.record.cf.FontFormatting;
import org.apache.poi.hssf.record.cf.PatternFormatting;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.Formula;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndianOutput;

public final class CFRuleRecord
extends StandardRecord {
    public static final short sid = 433;
    private byte field_1_condition_type;
    public static final byte CONDITION_TYPE_CELL_VALUE_IS = 1;
    public static final byte CONDITION_TYPE_FORMULA = 2;
    private byte field_2_comparison_operator;
    private int field_5_options;
    private static final BitField modificationBits = CFRuleRecord.bf(0x3FFFFF);
    private static final BitField alignHor = CFRuleRecord.bf(1);
    private static final BitField alignVer = CFRuleRecord.bf(2);
    private static final BitField alignWrap = CFRuleRecord.bf(4);
    private static final BitField alignRot = CFRuleRecord.bf(8);
    private static final BitField alignJustLast = CFRuleRecord.bf(16);
    private static final BitField alignIndent = CFRuleRecord.bf(32);
    private static final BitField alignShrin = CFRuleRecord.bf(64);
    private static final BitField notUsed1 = CFRuleRecord.bf(128);
    private static final BitField protLocked = CFRuleRecord.bf(256);
    private static final BitField protHidden = CFRuleRecord.bf(512);
    private static final BitField bordLeft = CFRuleRecord.bf(1024);
    private static final BitField bordRight = CFRuleRecord.bf(2048);
    private static final BitField bordTop = CFRuleRecord.bf(4096);
    private static final BitField bordBot = CFRuleRecord.bf(8192);
    private static final BitField bordTlBr = CFRuleRecord.bf(16384);
    private static final BitField bordBlTr = CFRuleRecord.bf(32768);
    private static final BitField pattStyle = CFRuleRecord.bf(65536);
    private static final BitField pattCol = CFRuleRecord.bf(131072);
    private static final BitField pattBgCol = CFRuleRecord.bf(262144);
    private static final BitField notUsed2 = CFRuleRecord.bf(0x380000);
    private static final BitField undocumented = CFRuleRecord.bf(0x3C00000);
    private static final BitField fmtBlockBits = CFRuleRecord.bf(0x7C000000);
    private static final BitField font = CFRuleRecord.bf(0x4000000);
    private static final BitField align = CFRuleRecord.bf(0x8000000);
    private static final BitField bord = CFRuleRecord.bf(0x10000000);
    private static final BitField patt = CFRuleRecord.bf(0x20000000);
    private static final BitField prot = CFRuleRecord.bf(0x40000000);
    private static final BitField alignTextDir = CFRuleRecord.bf(Integer.MIN_VALUE);
    private short field_6_not_used;
    private FontFormatting _fontFormatting;
    private BorderFormatting _borderFormatting;
    private PatternFormatting _patternFormatting;
    private Formula field_17_formula1;
    private Formula field_18_formula2;

    private static BitField bf(int i) {
        return BitFieldFactory.getInstance(i);
    }

    private CFRuleRecord(byte conditionType, byte comparisonOperation) {
        this.field_1_condition_type = conditionType;
        this.field_2_comparison_operator = comparisonOperation;
        this.field_5_options = modificationBits.setValue(this.field_5_options, -1);
        this.field_5_options = fmtBlockBits.setValue(this.field_5_options, 0);
        this.field_5_options = undocumented.clear(this.field_5_options);
        this.field_6_not_used = (short)-32766;
        this._fontFormatting = null;
        this._borderFormatting = null;
        this._patternFormatting = null;
        this.field_17_formula1 = Formula.create(Ptg.EMPTY_PTG_ARRAY);
        this.field_18_formula2 = Formula.create(Ptg.EMPTY_PTG_ARRAY);
    }

    private CFRuleRecord(byte conditionType, byte comparisonOperation, Ptg[] formula1, Ptg[] formula2) {
        this(conditionType, comparisonOperation);
        this.field_17_formula1 = Formula.create(formula1);
        this.field_18_formula2 = Formula.create(formula2);
    }

    public static CFRuleRecord create(HSSFSheet sheet, String formulaText) {
        Ptg[] formula1 = CFRuleRecord.parseFormula(formulaText, sheet);
        return new CFRuleRecord(2, 0, formula1, null);
    }

    public static CFRuleRecord create(HSSFSheet sheet, byte comparisonOperation, String formulaText1, String formulaText2) {
        Ptg[] formula1 = CFRuleRecord.parseFormula(formulaText1, sheet);
        Ptg[] formula2 = CFRuleRecord.parseFormula(formulaText2, sheet);
        return new CFRuleRecord(1, comparisonOperation, formula1, formula2);
    }

    public CFRuleRecord(RecordInputStream in) {
        this.field_1_condition_type = in.readByte();
        this.field_2_comparison_operator = in.readByte();
        int field_3_formula1_len = in.readUShort();
        int field_4_formula2_len = in.readUShort();
        this.field_5_options = in.readInt();
        this.field_6_not_used = in.readShort();
        if (this.containsFontFormattingBlock()) {
            this._fontFormatting = new FontFormatting(in);
        }
        if (this.containsBorderFormattingBlock()) {
            this._borderFormatting = new BorderFormatting(in);
        }
        if (this.containsPatternFormattingBlock()) {
            this._patternFormatting = new PatternFormatting(in);
        }
        this.field_17_formula1 = Formula.read(field_3_formula1_len, in);
        this.field_18_formula2 = Formula.read(field_4_formula2_len, in);
    }

    public byte getConditionType() {
        return this.field_1_condition_type;
    }

    public boolean containsFontFormattingBlock() {
        return this.getOptionFlag(font);
    }

    public void setFontFormatting(FontFormatting fontFormatting) {
        this._fontFormatting = fontFormatting;
        this.setOptionFlag(fontFormatting != null, font);
    }

    public FontFormatting getFontFormatting() {
        if (this.containsFontFormattingBlock()) {
            return this._fontFormatting;
        }
        return null;
    }

    public boolean containsAlignFormattingBlock() {
        return this.getOptionFlag(align);
    }

    public void setAlignFormattingUnchanged() {
        this.setOptionFlag(false, align);
    }

    public boolean containsBorderFormattingBlock() {
        return this.getOptionFlag(bord);
    }

    public void setBorderFormatting(BorderFormatting borderFormatting) {
        this._borderFormatting = borderFormatting;
        this.setOptionFlag(borderFormatting != null, bord);
    }

    public BorderFormatting getBorderFormatting() {
        if (this.containsBorderFormattingBlock()) {
            return this._borderFormatting;
        }
        return null;
    }

    public boolean containsPatternFormattingBlock() {
        return this.getOptionFlag(patt);
    }

    public void setPatternFormatting(PatternFormatting patternFormatting) {
        this._patternFormatting = patternFormatting;
        this.setOptionFlag(patternFormatting != null, patt);
    }

    public PatternFormatting getPatternFormatting() {
        if (this.containsPatternFormattingBlock()) {
            return this._patternFormatting;
        }
        return null;
    }

    public boolean containsProtectionFormattingBlock() {
        return this.getOptionFlag(prot);
    }

    public void setProtectionFormattingUnchanged() {
        this.setOptionFlag(false, prot);
    }

    public void setComparisonOperation(byte operation) {
        this.field_2_comparison_operator = operation;
    }

    public byte getComparisonOperation() {
        return this.field_2_comparison_operator;
    }

    public int getOptions() {
        return this.field_5_options;
    }

    private boolean isModified(BitField field) {
        return !field.isSet(this.field_5_options);
    }

    private void setModified(boolean modified, BitField field) {
        this.field_5_options = field.setBoolean(this.field_5_options, !modified);
    }

    public boolean isLeftBorderModified() {
        return this.isModified(bordLeft);
    }

    public void setLeftBorderModified(boolean modified) {
        this.setModified(modified, bordLeft);
    }

    public boolean isRightBorderModified() {
        return this.isModified(bordRight);
    }

    public void setRightBorderModified(boolean modified) {
        this.setModified(modified, bordRight);
    }

    public boolean isTopBorderModified() {
        return this.isModified(bordTop);
    }

    public void setTopBorderModified(boolean modified) {
        this.setModified(modified, bordTop);
    }

    public boolean isBottomBorderModified() {
        return this.isModified(bordBot);
    }

    public void setBottomBorderModified(boolean modified) {
        this.setModified(modified, bordBot);
    }

    public boolean isTopLeftBottomRightBorderModified() {
        return this.isModified(bordTlBr);
    }

    public void setTopLeftBottomRightBorderModified(boolean modified) {
        this.setModified(modified, bordTlBr);
    }

    public boolean isBottomLeftTopRightBorderModified() {
        return this.isModified(bordBlTr);
    }

    public void setBottomLeftTopRightBorderModified(boolean modified) {
        this.setModified(modified, bordBlTr);
    }

    public boolean isPatternStyleModified() {
        return this.isModified(pattStyle);
    }

    public void setPatternStyleModified(boolean modified) {
        this.setModified(modified, pattStyle);
    }

    public boolean isPatternColorModified() {
        return this.isModified(pattCol);
    }

    public void setPatternColorModified(boolean modified) {
        this.setModified(modified, pattCol);
    }

    public boolean isPatternBackgroundColorModified() {
        return this.isModified(pattBgCol);
    }

    public void setPatternBackgroundColorModified(boolean modified) {
        this.setModified(modified, pattBgCol);
    }

    private boolean getOptionFlag(BitField field) {
        return field.isSet(this.field_5_options);
    }

    private void setOptionFlag(boolean flag, BitField field) {
        this.field_5_options = field.setBoolean(this.field_5_options, flag);
    }

    public Ptg[] getParsedExpression1() {
        return this.field_17_formula1.getTokens();
    }

    public void setParsedExpression1(Ptg[] ptgs) {
        this.field_17_formula1 = Formula.create(ptgs);
    }

    public Ptg[] getParsedExpression2() {
        return Formula.getTokens(this.field_18_formula2);
    }

    public void setParsedExpression2(Ptg[] ptgs) {
        this.field_18_formula2 = Formula.create(ptgs);
    }

    public short getSid() {
        return 433;
    }

    private static int getFormulaSize(Formula formula) {
        return formula.getEncodedTokenSize();
    }

    public void serialize(LittleEndianOutput out) {
        int formula1Len = CFRuleRecord.getFormulaSize(this.field_17_formula1);
        int formula2Len = CFRuleRecord.getFormulaSize(this.field_18_formula2);
        out.writeByte(this.field_1_condition_type);
        out.writeByte(this.field_2_comparison_operator);
        out.writeShort(formula1Len);
        out.writeShort(formula2Len);
        out.writeInt(this.field_5_options);
        out.writeShort(this.field_6_not_used);
        if (this.containsFontFormattingBlock()) {
            byte[] fontFormattingRawRecord = this._fontFormatting.getRawRecord();
            out.write(fontFormattingRawRecord);
        }
        if (this.containsBorderFormattingBlock()) {
            this._borderFormatting.serialize(out);
        }
        if (this.containsPatternFormattingBlock()) {
            this._patternFormatting.serialize(out);
        }
        this.field_17_formula1.serializeTokens(out);
        this.field_18_formula2.serializeTokens(out);
    }

    protected int getDataSize() {
        return 12 + (this.containsFontFormattingBlock() ? this._fontFormatting.getRawRecord().length : 0) + (this.containsBorderFormattingBlock() ? 8 : 0) + (this.containsPatternFormattingBlock() ? 4 : 0) + CFRuleRecord.getFormulaSize(this.field_17_formula1) + CFRuleRecord.getFormulaSize(this.field_18_formula2);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CFRULE]\n");
        buffer.append("    .condition_type   =" + this.field_1_condition_type);
        buffer.append("    OPTION FLAGS=0x" + Integer.toHexString(this.getOptions()));
        return buffer.toString();
    }

    public Object clone() {
        CFRuleRecord rec = new CFRuleRecord(this.field_1_condition_type, this.field_2_comparison_operator);
        rec.field_5_options = this.field_5_options;
        rec.field_6_not_used = this.field_6_not_used;
        if (this.containsFontFormattingBlock()) {
            rec._fontFormatting = (FontFormatting)this._fontFormatting.clone();
        }
        if (this.containsBorderFormattingBlock()) {
            rec._borderFormatting = (BorderFormatting)this._borderFormatting.clone();
        }
        if (this.containsPatternFormattingBlock()) {
            rec._patternFormatting = (PatternFormatting)this._patternFormatting.clone();
        }
        rec.field_17_formula1 = this.field_17_formula1.copy();
        rec.field_18_formula2 = this.field_17_formula1.copy();
        return rec;
    }

    private static Ptg[] parseFormula(String formula, HSSFSheet sheet) {
        if (formula == null) {
            return null;
        }
        int sheetIndex = sheet.getWorkbook().getSheetIndex(sheet);
        return HSSFFormulaParser.parse(formula, (HSSFWorkbook)sheet.getWorkbook(), 0, sheetIndex);
    }

    public static final class ComparisonOperator {
        public static final byte NO_COMPARISON = 0;
        public static final byte BETWEEN = 1;
        public static final byte NOT_BETWEEN = 2;
        public static final byte EQUAL = 3;
        public static final byte NOT_EQUAL = 4;
        public static final byte GT = 5;
        public static final byte LT = 6;
        public static final byte GE = 7;
        public static final byte LE = 8;
    }
}

