/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */

package org.apache.poi.ss.usermodel;


/**
 * Charset represents the basic set of characters associated with a font (that it can display), and
 * corresponds to the ANSI codepage (8-bit or DBCS) of that character set used by a given language.
 *
 * @author Gisella Bronzetti
 */
public class FontCharset {

     public static final FontCharset ANSI = new FontCharset(0);
     public static final FontCharset DEFAULT = new FontCharset(1);
     public static final FontCharset SYMBOL = new FontCharset(2);
     public static final FontCharset MAC = new FontCharset(77);
     public static final FontCharset SHIFTJIS = new FontCharset(128);
     public static final FontCharset HANGEUL = new FontCharset(129);
     public static final FontCharset JOHAB = new FontCharset(130);
     public static final FontCharset GB2312 = new FontCharset(134);
     public static final FontCharset CHINESEBIG5 = new FontCharset(136);
     public static final FontCharset GREEK = new FontCharset(161);
     public static final FontCharset TURKISH = new FontCharset(162);
     public static final FontCharset VIETNAMESE = new FontCharset(163);
     public static final FontCharset HEBREW = new FontCharset(177);
     public static final FontCharset ARABIC = new FontCharset(178);
     public static final FontCharset BALTIC = new FontCharset(186);
     public static final FontCharset RUSSIAN = new FontCharset(204);
     public static final FontCharset THAI = new FontCharset(222);
     public static final FontCharset EASTEUROPE = new FontCharset(238);
     public static final FontCharset OEM = new FontCharset(255);

     private static FontCharset[] values() {
		return new FontCharset[] { ANSI, DEFAULT, SYMBOL, MAC, SHIFTJIS,
				HANGEUL, JOHAB, GB2312, CHINESEBIG5, GREEK, TURKISH,
				VIETNAMESE, HEBREW, ARABIC, BALTIC, RUSSIAN, THAI, EASTEUROPE,
				OEM };
     }

    private int charset;

    private FontCharset(int value){
        charset = value;
    }

    /**
     * Returns value of this charset
     *
     * @return value of this charset
     */
    public int getValue(){
        return charset;
    }

    private static FontCharset[] _table = new FontCharset[256];
    static {
    	for (int i = 0; i < values().length; i++) {
			FontCharset c = values()[i];
            _table[c.getValue()] = c;
        }
    }

    public static FontCharset valueOf(int value){
        return _table[value];
    }
}
