/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel;

public class FontUnderline {
    public static final FontUnderline SINGLE = new FontUnderline(1);
    public static final FontUnderline DOUBLE = new FontUnderline(2);
    public static final FontUnderline SINGLE_ACCOUNTING = new FontUnderline(3);
    public static final FontUnderline DOUBLE_ACCOUNTING = new FontUnderline(4);
    public static final FontUnderline NONE = new FontUnderline(5);
    private int value;
    private static FontUnderline[] _table = new FontUnderline[6];

    static {
        int i = 0;
        while (i < FontUnderline.values().length) {
            FontUnderline c;
            FontUnderline._table[c.getValue()] = c = FontUnderline.values()[i];
            ++i;
        }
    }

    public static FontUnderline[] values() {
        return new FontUnderline[]{SINGLE, DOUBLE, SINGLE_ACCOUNTING, DOUBLE_ACCOUNTING, NONE};
    }

    private FontUnderline(int val) {
        this.value = val;
    }

    public int getValue() {
        return this.value;
    }

    public byte getByteValue() {
        if (this == DOUBLE) {
            return 2;
        }
        if (this == DOUBLE_ACCOUNTING) {
            return 34;
        }
        if (this == SINGLE_ACCOUNTING) {
            return 33;
        }
        if (this == NONE) {
            return 0;
        }
        if (this == SINGLE) {
            return 1;
        }
        return 1;
    }

    public static FontUnderline valueOf(int value) {
        return _table[value];
    }

    public static FontUnderline valueOf(byte value) {
        FontUnderline val;
        switch (value) {
            case 2: {
                val = DOUBLE;
                break;
            }
            case 34: {
                val = DOUBLE_ACCOUNTING;
                break;
            }
            case 33: {
                val = SINGLE_ACCOUNTING;
                break;
            }
            case 1: {
                val = SINGLE;
                break;
            }
            default: {
                val = NONE;
            }
        }
        return val;
    }
}

