/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;

public class HSSFCreationHelper
implements CreationHelper {
    private HSSFWorkbook workbook;
    private HSSFDataFormat dataFormat;

    HSSFCreationHelper(HSSFWorkbook wb) {
        this.workbook = wb;
        this.dataFormat = new HSSFDataFormat(this.workbook.getWorkbook());
    }

    public RichTextString createRichTextString(String text) {
        return new HSSFRichTextString(text);
    }

    public DataFormat createDataFormat() {
        return this.dataFormat;
    }

    public Hyperlink createHyperlink(int type) {
        return new HSSFHyperlink(type);
    }

    public FormulaEvaluator createFormulaEvaluator() {
        return new HSSFFormulaEvaluator(this.workbook);
    }

    public ClientAnchor createClientAnchor() {
        return new HSSFClientAnchor();
    }
}

