/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.SubRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianByteArrayOutputStream;
import org.apache.poi.util.LittleEndianInputStream;

public final class ObjRecord
extends Record {
    public static final short sid = 93;
    private static final int NORMAL_PAD_ALIGNMENT = 2;
    private static int MAX_PAD_ALIGNMENT = 4;
    private List subrecords;
    private final byte[] _uninterpretedData;
    private boolean _isPaddedToQuadByteMultiple;

    public ObjRecord() {
        this.subrecords = new ArrayList(2);
        this._uninterpretedData = null;
    }

    public ObjRecord(RecordInputStream in) {
        SubRecord subRecord;
        byte[] subRecordData = in.readRemainder();
        if (LittleEndian.getUShort(subRecordData, 0) != 21) {
            this._uninterpretedData = subRecordData;
            this.subrecords = null;
            return;
        }
        this.subrecords = new ArrayList();
        ByteArrayInputStream bais = new ByteArrayInputStream(subRecordData);
        LittleEndianInputStream subRecStream = new LittleEndianInputStream(bais);
        CommonObjectDataSubRecord cmo = (CommonObjectDataSubRecord)SubRecord.createSubRecord(subRecStream, 0);
        this.subrecords.add(cmo);
        do {
            subRecord = SubRecord.createSubRecord(subRecStream, cmo.getObjectType());
            this.subrecords.add(subRecord);
        } while (!subRecord.isTerminating());
        int nRemainingBytes = bais.available();
        if (nRemainingBytes > 0) {
            this._isPaddedToQuadByteMultiple = subRecordData.length % MAX_PAD_ALIGNMENT == 0;
            if (nRemainingBytes >= (this._isPaddedToQuadByteMultiple ? MAX_PAD_ALIGNMENT : 2)) {
                if (!ObjRecord.canPaddingBeDiscarded(subRecordData, nRemainingBytes)) {
                    String msg = "Leftover " + nRemainingBytes + " bytes in subrecord data " + HexDump.toHex(subRecordData);
                    throw new RecordFormatException(msg);
                }
                this._isPaddedToQuadByteMultiple = false;
            }
        } else {
            this._isPaddedToQuadByteMultiple = false;
        }
        this._uninterpretedData = null;
    }

    private static boolean canPaddingBeDiscarded(byte[] data, int nRemainingBytes) {
        int i = data.length - nRemainingBytes;
        while (i < data.length) {
            if (data[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[OBJ]\n");
        int i = 0;
        while (i < this.subrecords.size()) {
            SubRecord record = (SubRecord)this.subrecords.get(i);
            sb.append("SUBRECORD: ").append(record.toString());
            ++i;
        }
        sb.append("[/OBJ]\n");
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public int getRecordSize() {
        block4: {
            if (this._uninterpretedData != null) {
                return this._uninterpretedData.length + 4;
            }
            size = 0;
            i = this.subrecords.size() - 1;
            while (i >= 0) {
                record = (SubRecord)this.subrecords.get(i);
                size += record.getDataSize() + 4;
                --i;
            }
            if (!this._isPaddedToQuadByteMultiple) ** GOTO lbl16
            while (size % ObjRecord.MAX_PAD_ALIGNMENT != 0) {
                ++size;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                ++size;
lbl16:
                // 2 sources

                ** while (size % 2 != 0)
            }
        }
        return size + 4;
    }

    public int serialize(int offset, byte[] data) {
        int recSize = this.getRecordSize();
        int dataSize = recSize - 4;
        LittleEndianByteArrayOutputStream out = new LittleEndianByteArrayOutputStream(data, offset, recSize);
        out.writeShort(93);
        out.writeShort(dataSize);
        if (this._uninterpretedData == null) {
            int i = 0;
            while (i < this.subrecords.size()) {
                SubRecord record = (SubRecord)this.subrecords.get(i);
                record.serialize(out);
                ++i;
            }
            int expectedEndIx = offset + dataSize;
            while (out.getWriteIndex() < expectedEndIx) {
                out.writeByte(0);
            }
        } else {
            out.write(this._uninterpretedData);
        }
        return recSize;
    }

    public short getSid() {
        return 93;
    }

    public List getSubRecords() {
        return this.subrecords;
    }

    public void clearSubRecords() {
        this.subrecords.clear();
    }

    public void addSubRecord(int index, SubRecord element) {
        this.subrecords.add(index, element);
    }

    public boolean addSubRecord(SubRecord o) {
        return this.subrecords.add(o);
    }

    public Object clone() {
        ObjRecord rec = new ObjRecord();
        int i = 0;
        while (i < this.subrecords.size()) {
            SubRecord record = (SubRecord)this.subrecords.get(i);
            rec.addSubRecord((SubRecord)record.clone());
            ++i;
        }
        return rec;
    }
}

