/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel;

import java.util.HashMap;
import java.util.Map;

public class FormulaError {
    public static final FormulaError NULL = new FormulaError(0, "#NULL!");
    public static final FormulaError DIV0 = new FormulaError(7, "#DIV/0!");
    public static final FormulaError VALUE = new FormulaError(15, "#VALUE!");
    public static final FormulaError REF = new FormulaError(23, "#REF!");
    public static final FormulaError NAME = new FormulaError(29, "#NAME?");
    public static final FormulaError NUM = new FormulaError(36, "#NUM!");
    public static final FormulaError NA = new FormulaError(42, "#N/A");
    private byte type;
    private String repr;
    private static Map smap = new HashMap();
    private static Map imap = new HashMap();

    static {
        int i = 0;
        while (i < FormulaError.values().length) {
            FormulaError error = FormulaError.values()[i];
            imap.put(new Byte(error.getCode()), error);
            smap.put(error.getString(), error);
            ++i;
        }
    }

    public static FormulaError[] values() {
        return new FormulaError[]{NULL, DIV0, VALUE, REF, NAME, NUM, NA};
    }

    private FormulaError(int type, String repr) {
        this.type = (byte)type;
        this.repr = repr;
    }

    public byte getCode() {
        return this.type;
    }

    public String getString() {
        return this.repr;
    }

    public static FormulaError forInt(byte type) {
        FormulaError err = (FormulaError)imap.get(new Byte(type));
        if (err == null) {
            throw new IllegalArgumentException("Unknown error type: " + type);
        }
        return err;
    }

    public static FormulaError forString(String code) {
        FormulaError err = (FormulaError)smap.get(code);
        if (err == null) {
            throw new IllegalArgumentException("Unknown error code: " + code);
        }
        return err;
    }
}

