/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.poifs.common.POIFSBigBlockSize;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.storage.BigBlock;
import org.apache.poi.poifs.storage.BlockWritable;

public final class PropertyBlock
extends BigBlock {
    private Property[] _properties;

    private PropertyBlock(POIFSBigBlockSize bigBlockSize, Property[] properties, int offset) {
        super(bigBlockSize);
        this._properties = new Property[bigBlockSize.getPropertiesPerBlock()];
        int j = 0;
        while (j < this._properties.length) {
            this._properties[j] = properties[j + offset];
            ++j;
        }
    }

    public static BlockWritable[] createPropertyBlockArray(POIFSBigBlockSize bigBlockSize, List properties) {
        int _properties_per_block = bigBlockSize.getPropertiesPerBlock();
        int block_count = (properties.size() + _properties_per_block - 1) / _properties_per_block;
        Property[] to_be_written = new Property[block_count * _properties_per_block];
        System.arraycopy(properties.toArray(new Property[0]), 0, to_be_written, 0, properties.size());
        int j = properties.size();
        while (j < to_be_written.length) {
            to_be_written[j] = new Property(){

                protected void preWrite() {
                }

                public boolean isDirectory() {
                    return false;
                }
            };
            ++j;
        }
        BlockWritable[] rvalue = new BlockWritable[block_count];
        int j2 = 0;
        while (j2 < block_count) {
            rvalue[j2] = new PropertyBlock(bigBlockSize, to_be_written, j2 * _properties_per_block);
            ++j2;
        }
        return rvalue;
    }

    void writeData(OutputStream stream) throws IOException {
        int _properties_per_block = this.bigBlockSize.getPropertiesPerBlock();
        int j = 0;
        while (j < _properties_per_block) {
            this._properties[j].writeData(stream);
            ++j;
        }
    }
}

