/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.ArrayList;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.MulBlankRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordBase;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;
import org.apache.poi.hssf.record.aggregates.SharedValueManager;
import org.apache.poi.hssf.record.formula.FormulaShifter;
import org.apache.poi.hssf.record.formula.Ptg;

public final class ValueRecordsAggregate {
    private static final int MAX_ROW_INDEX = 65535;
    private static final int INDEX_NOT_SET = -1;
    private int firstcell = -1;
    private int lastcell = -1;
    private CellValueRecordInterface[][] records;
    static /* synthetic */ Class class$0;

    public ValueRecordsAggregate() {
        this(-1, -1, new CellValueRecordInterface[30][]);
    }

    private ValueRecordsAggregate(int firstCellIx, int lastCellIx, CellValueRecordInterface[][] pRecords) {
        this.firstcell = firstCellIx;
        this.lastcell = lastCellIx;
        this.records = pRecords;
    }

    public void insertCell(CellValueRecordInterface cell) {
        CellValueRecordInterface[] rowCells;
        int newSize;
        short column = cell.getColumn();
        int row = cell.getRow();
        if (row >= this.records.length) {
            CellValueRecordInterface[][] oldRecords = this.records;
            newSize = oldRecords.length * 2;
            if (newSize < row + 1) {
                newSize = row + 1;
            }
            this.records = new CellValueRecordInterface[newSize][];
            System.arraycopy(oldRecords, 0, this.records, 0, oldRecords.length);
        }
        if ((rowCells = this.records[row]) == null) {
            newSize = column + 1;
            if (newSize < 10) {
                newSize = 10;
            }
            rowCells = new CellValueRecordInterface[newSize];
            this.records[row] = rowCells;
        }
        if (column >= rowCells.length) {
            CellValueRecordInterface[] oldRowCells = rowCells;
            int newSize2 = oldRowCells.length * 2;
            if (newSize2 < column + 1) {
                newSize2 = column + 1;
            }
            rowCells = new CellValueRecordInterface[newSize2];
            System.arraycopy(oldRowCells, 0, rowCells, 0, oldRowCells.length);
            this.records[row] = rowCells;
        }
        rowCells[column] = cell;
        if (column < this.firstcell || this.firstcell == -1) {
            this.firstcell = column;
        }
        if (column > this.lastcell || this.lastcell == -1) {
            this.lastcell = column;
        }
    }

    public void removeCell(CellValueRecordInterface cell) {
        if (cell == null) {
            throw new IllegalArgumentException("cell must not be null");
        }
        int row = cell.getRow();
        if (row >= this.records.length) {
            throw new RuntimeException("cell row is out of range");
        }
        CellValueRecordInterface[] rowCells = this.records[row];
        if (rowCells == null) {
            throw new RuntimeException("cell row is already empty");
        }
        short column = cell.getColumn();
        if (column >= rowCells.length) {
            throw new RuntimeException("cell column is out of range");
        }
        rowCells[column] = null;
    }

    public void removeAllCellsValuesForRow(int rowIndex) {
        if (rowIndex < 0 || rowIndex > 65535) {
            throw new IllegalArgumentException("Specified rowIndex " + rowIndex + " is outside the allowable range (0.." + 65535 + ")");
        }
        if (rowIndex >= this.records.length) {
            return;
        }
        this.records[rowIndex] = null;
    }

    public int getPhysicalNumberOfCells() {
        int count = 0;
        int r = 0;
        while (r < this.records.length) {
            CellValueRecordInterface[] rowCells = this.records[r];
            if (rowCells != null) {
                int c = 0;
                while (c < rowCells.length) {
                    if (rowCells[c] != null) {
                        ++count;
                    }
                    ++c;
                }
            }
            ++r;
        }
        return count;
    }

    public int getFirstCellNum() {
        return this.firstcell;
    }

    public int getLastCellNum() {
        return this.lastcell;
    }

    public void addMultipleBlanks(MulBlankRecord mbr) {
        int j = 0;
        while (j < mbr.getNumColumns()) {
            BlankRecord br = new BlankRecord();
            br.setColumn((short)(j + mbr.getFirstColumn()));
            br.setRow(mbr.getRow());
            br.setXFIndex(mbr.getXFAt(j));
            this.insertCell(br);
            ++j;
        }
    }

    public void construct(CellValueRecordInterface rec, RecordStream rs, SharedValueManager sfh) {
        if (rec instanceof FormulaRecord) {
            FormulaRecord formulaRec = (FormulaRecord)rec;
            Class nextClass = rs.peekNextClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.apache.poi.hssf.record.StringRecord");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringRecord cachedText = nextClass == clazz ? (StringRecord)rs.getNext() : null;
            this.insertCell(new FormulaRecordAggregate(formulaRec, cachedText, sfh));
        } else {
            this.insertCell(rec);
        }
    }

    public int getRowCellBlockSize(int startRow, int endRow) {
        int result = 0;
        int rowIx = startRow;
        while (rowIx <= endRow && rowIx < this.records.length) {
            result += ValueRecordsAggregate.getRowSerializedSize(this.records[rowIx]);
            ++rowIx;
        }
        return result;
    }

    public boolean rowHasCells(int row) {
        if (row >= this.records.length) {
            return false;
        }
        CellValueRecordInterface[] rowCells = this.records[row];
        if (rowCells == null) {
            return false;
        }
        int col = 0;
        while (col < rowCells.length) {
            if (rowCells[col] != null) {
                return true;
            }
            ++col;
        }
        return false;
    }

    private static int getRowSerializedSize(CellValueRecordInterface[] rowCells) {
        if (rowCells == null) {
            return 0;
        }
        int result = 0;
        int i = 0;
        while (i < rowCells.length) {
            RecordBase cvr = (RecordBase)((Object)rowCells[i]);
            if (cvr != null) {
                int nBlank = ValueRecordsAggregate.countBlanks(rowCells, i);
                if (nBlank > 1) {
                    result += 10 + 2 * nBlank;
                    i += nBlank - 1;
                } else {
                    result += cvr.getRecordSize();
                }
            }
            ++i;
        }
        return result;
    }

    public void visitCellsForRow(int rowIndex, RecordAggregate.RecordVisitor rv) {
        CellValueRecordInterface[] rowCells = this.records[rowIndex];
        if (rowCells == null) {
            throw new IllegalArgumentException("Row [" + rowIndex + "] is empty");
        }
        int i = 0;
        while (i < rowCells.length) {
            RecordBase cvr = (RecordBase)((Object)rowCells[i]);
            if (cvr != null) {
                int nBlank = ValueRecordsAggregate.countBlanks(rowCells, i);
                if (nBlank > 1) {
                    rv.visitRecord(this.createMBR(rowCells, i, nBlank));
                    i += nBlank - 1;
                } else if (cvr instanceof RecordAggregate) {
                    RecordAggregate agg = (RecordAggregate)cvr;
                    agg.visitContainedRecords(rv);
                } else {
                    rv.visitRecord((Record)cvr);
                }
            }
            ++i;
        }
    }

    private static int countBlanks(CellValueRecordInterface[] rowCellValues, int startIx) {
        int i = startIx;
        while (i < rowCellValues.length) {
            CellValueRecordInterface cvr = rowCellValues[i];
            if (!(cvr instanceof BlankRecord)) break;
            ++i;
        }
        return i - startIx;
    }

    private MulBlankRecord createMBR(CellValueRecordInterface[] cellValues, int startIx, int nBlank) {
        short[] xfs = new short[nBlank];
        int i = 0;
        while (i < xfs.length) {
            xfs[i] = ((BlankRecord)cellValues[startIx + i]).getXFIndex();
            ++i;
        }
        int rowIx = cellValues[startIx].getRow();
        return new MulBlankRecord(rowIx, startIx, xfs);
    }

    public void updateFormulasAfterRowShift(FormulaShifter shifter, int currentExternSheetIndex) {
        int i = 0;
        while (i < this.records.length) {
            CellValueRecordInterface[] rowCells = this.records[i];
            if (rowCells != null) {
                int j = 0;
                while (j < rowCells.length) {
                    FormulaRecord fr;
                    Ptg[] ptgs;
                    CellValueRecordInterface cell = rowCells[j];
                    if (cell instanceof FormulaRecordAggregate && shifter.adjustFormula(ptgs = (fr = ((FormulaRecordAggregate)cell).getFormulaRecord()).getParsedExpression(), currentExternSheetIndex)) {
                        fr.setParsedExpression(ptgs);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public CellValueRecordInterface[] getValueRecords() {
        ArrayList<CellValueRecordInterface> temp = new ArrayList<CellValueRecordInterface>();
        int rowIx = 0;
        while (rowIx < this.records.length) {
            CellValueRecordInterface[] rowCells = this.records[rowIx];
            if (rowCells != null) {
                int colIx = 0;
                while (colIx < rowCells.length) {
                    CellValueRecordInterface cell = rowCells[colIx];
                    if (cell != null) {
                        temp.add(cell);
                    }
                    ++colIx;
                }
            }
            ++rowIx;
        }
        CellValueRecordInterface[] result = new CellValueRecordInterface[temp.size()];
        temp.toArray(result);
        return result;
    }

    public Object clone() {
        throw new RuntimeException("clone() should not be called.  ValueRecordsAggregate should be copied via Sheet.cloneSheet()");
    }
}

