/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.eventusermodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.eventusermodel.AbortableHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactory;

public class HSSFRequest {
    private final Map _records = new HashMap(50);

    public void addListener(HSSFListener lsnr, short sid) {
        ArrayList<HSSFListener> list = (ArrayList<HSSFListener>)this._records.get(new Short(sid));
        if (list == null) {
            list = new ArrayList<HSSFListener>(1);
            this._records.put(new Short(sid), list);
        }
        list.add(lsnr);
    }

    public void addListenerForAllRecords(HSSFListener lsnr) {
        short[] rectypes = RecordFactory.getAllKnownRecordSIDs();
        int k = 0;
        while (k < rectypes.length) {
            this.addListener(lsnr, rectypes[k]);
            ++k;
        }
    }

    protected short processRecord(Record rec) throws HSSFUserException {
        Object obj = this._records.get(new Short(rec.getSid()));
        short userCode = 0;
        if (obj != null) {
            List listeners = (List)obj;
            int k = 0;
            while (k < listeners.size()) {
                HSSFListener listener;
                Object listenObj = listeners.get(k);
                if (listenObj instanceof AbortableHSSFListener) {
                    listener = (AbortableHSSFListener)listenObj;
                    userCode = ((AbortableHSSFListener)listener).abortableProcessRecord(rec);
                    if (userCode != 0) {
                        break;
                    }
                } else {
                    listener = (HSSFListener)listenObj;
                    listener.processRecord(rec);
                }
                ++k;
            }
        }
        return userCode;
    }
}

