/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.UnsupportedVariantTypeException;
import org.apache.poi.hpsf.Util;
import org.apache.poi.hpsf.VariantSupport;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class Property {
    protected long id;
    protected long type;
    protected Object value;

    public long getID() {
        return this.id;
    }

    public long getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public Property(long id, long type, Object value) {
        this.id = id;
        this.type = type;
        this.value = value;
    }

    public Property(long id, byte[] src, long offset, int length, int codepage) throws UnsupportedEncodingException {
        this.id = id;
        if (id == 0L) {
            this.value = this.readDictionary(src, offset, length, codepage);
            return;
        }
        int o = (int)offset;
        this.type = LittleEndian.getUInt(src, o);
        o += 4;
        try {
            this.value = VariantSupport.read(src, o, length, (int)this.type, codepage);
        }
        catch (UnsupportedVariantTypeException ex) {
            VariantSupport.writeUnsupportedTypeMessage(ex);
            this.value = ex.getValue();
        }
    }

    protected Property() {
    }

    protected Map readDictionary(byte[] src, long offset, int length, int codepage) throws UnsupportedEncodingException {
        if (offset < 0L || offset > (long)src.length) {
            throw new HPSFRuntimeException("Illegal offset " + offset + " while HPSF stream contains " + length + " bytes.");
        }
        int o = (int)offset;
        long nrEntries = LittleEndian.getUInt(src, o);
        o += 4;
        HashMap<Long, String> m = new HashMap<Long, String>((int)nrEntries, 1.0f);
        try {
            int i = 0;
            while ((long)i < nrEntries) {
                Long id = new Long(LittleEndian.getUInt(src, o));
                long sLength = LittleEndian.getUInt(src, o += 4);
                o += 4;
                StringBuffer b = new StringBuffer();
                switch (codepage) {
                    case -1: {
                        b.append(new String(src, o, (int)sLength));
                        break;
                    }
                    case 1200: {
                        int nrBytes = (int)(sLength * 2L);
                        byte[] h = new byte[nrBytes];
                        int i2 = 0;
                        while (i2 < nrBytes) {
                            h[i2] = src[o + i2 + 1];
                            h[i2 + 1] = src[o + i2];
                            i2 += 2;
                        }
                        b.append(new String(h, 0, nrBytes, VariantSupport.codepageToEncoding(codepage)));
                        break;
                    }
                    default: {
                        b.append(new String(src, o, (int)sLength, VariantSupport.codepageToEncoding(codepage)));
                        break;
                    }
                }
                while (b.length() > 0 && b.charAt(b.length() - 1) == '\u0000') {
                    b.setLength(b.length() - 1);
                }
                if (codepage == 1200) {
                    if (sLength % 2L == 1L) {
                        ++sLength;
                    }
                    o = (int)((long)o + (sLength + sLength));
                } else {
                    o = (int)((long)o + sLength);
                }
                m.put(id, b.toString());
                ++i;
            }
        }
        catch (RuntimeException ex) {
            POILogger l = POILogFactory.getLogger(this.getClass());
            l.log(POILogger.WARN, (Object)("The property set's dictionary contains bogus data. All dictionary entries starting with the one with ID " + this.id + " will be ignored."), ex);
        }
        return m;
    }

    protected int getSize() throws WritingNotSupportedException {
        int length = VariantSupport.getVariantLength(this.type);
        if (length >= 0) {
            return length;
        }
        if (length == -2) {
            throw new WritingNotSupportedException(this.type, null);
        }
        int PADDING = 4;
        switch ((int)this.type) {
            case 30: {
                int l = ((String)this.value).length() + 1;
                int r = l % 4;
                if (r > 0) {
                    l += 4 - r;
                }
                length += l;
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new WritingNotSupportedException(this.type, this.value);
            }
        }
        return length;
    }

    public boolean equals(Object o) {
        Class<?> pValueClass;
        if (!(o instanceof Property)) {
            return false;
        }
        Property p = (Property)o;
        Object pValue = p.getValue();
        long pId = p.getID();
        if (this.id != pId || this.id != 0L && !this.typesAreEqual(this.type, p.getType())) {
            return false;
        }
        if (this.value == null && pValue == null) {
            return true;
        }
        if (this.value == null || pValue == null) {
            return false;
        }
        Class<?> valueClass = this.value.getClass();
        if (!valueClass.isAssignableFrom(pValueClass = pValue.getClass()) && !pValueClass.isAssignableFrom(valueClass)) {
            return false;
        }
        if (this.value instanceof byte[]) {
            return Util.equal((byte[])this.value, (byte[])pValue);
        }
        return this.value.equals(pValue);
    }

    private boolean typesAreEqual(long t1, long t2) {
        return t1 == t2 || t1 == 30L && t2 == 31L || t2 == 30L && t1 == 31L;
    }

    public int hashCode() {
        long hashCode = 0L;
        hashCode += this.id;
        hashCode += this.type;
        if (this.value != null) {
            hashCode += (long)this.value.hashCode();
        }
        int returnHashCode = (int)(hashCode & 0xFFFFFFFFL);
        return returnHashCode;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.getClass().getName());
        b.append('[');
        b.append("id: ");
        b.append(this.getID());
        b.append(", type: ");
        b.append(this.getType());
        Object value = this.getValue();
        b.append(", value: ");
        b.append(value.toString());
        if (value instanceof String) {
            String s = (String)value;
            int l = s.length();
            byte[] bytes = new byte[l * 2];
            int i = 0;
            while (i < l) {
                char c = s.charAt(i);
                byte high = (byte)((c & 0xFF00) >> 8);
                byte low = (byte)((c & 0xFF) >> 0);
                bytes[i * 2] = high;
                bytes[i * 2 + 1] = low;
                ++i;
            }
            String hex = HexDump.dump(bytes, 0L, 0);
            b.append(" [");
            b.append(hex);
            b.append("]");
        }
        b.append(']');
        return b.toString();
    }
}

