#include <stream.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <time.h>
#include <sys/time.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>

#include <Xm/Xm.h>
#include <Xm/ToggleBG.h>
#include <Xm/MainW.h>
#include <Xm/Form.h>
#include <Xm/Command.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/DrawingA.h>
#include <Xm/ToggleB.h>
#include <Xm/DialogS.h>
#include <Xm/FileSB.h>
#include <Xm/TextF.h>
#include <Xm/MessageB.h>
#include <Xm/PushB.h>
//extern "C"{
#include "esrh.h"
#include "pokemun.h"
//}

/***************************
         E N U M Z
***************************/
enum fileIoMode{
  EFileIoDump, EFileIoRestore
};
/***************************
       S T R A C T Z
***************************/
struct TSoftkey{
  int    iKeycode;
  const char   *iLabel;
};

/***************************
     C O N S T A N T Z
***************************/
const unsigned long kColourBg   = 0xa0a080;
const unsigned long kColourBgBg = 0xb0b090;
const unsigned long kColourFg   = 0x000000;
const unsigned long kColourRed  = 0xff0000;
const unsigned long kColourBlue = 0x0000ff;
const int kRefreshRateUs        = (int)(1000000/60);

const int kEventQLength = 8;
const int kKeyRemapTable[][2]={  // X11 Keysym -> POEMS Keysym
  { 0xff8d, 0x0d},
  { 0xff9e, '0' },
  { 0xff9f, '.' },
  { 0xff9c, '1' },
  { 0xff99, '2' },
  { 0xff9b, '3' },
  { 0xff96, '4' },
  { 0xff9d, '5' },
  { 0xff98, '6' },
  { 0xff95, '7' },
  { 0xff97, '8' },
  { 0xff9a, '9' },
  { 0xffaf, '/' },
  { 0xffaa, '*' },
  { 0xffab, '+' },
  { 0xffad, '-' },
  { 0xffb0, '0' },
  { 0xffb1, '1' },  { 0xffb2, '2' },  { 0xffb3, '3' },
  { 0xffb4, '4' },  { 0xffb5, '5' },  { 0xffb6, '6' },
  { 0xffb7, '7' },  { 0xffb8, '8' },  { 0xffb9, '9' },
  { 0xffbe, EKeyboardCl },         // F1
  { 0xffe1, EKeyboardShift },
  { 0xffe2, EKeyboardShift },
  { 0xffe7, EKeyboardDef },
  { 0xffe8, EKeyboardDef },
  { 0xffea, EKeyboardDef },
  { 0xff1b, EKeyboardBrk },        // ESC
  { 0x1005ff76, EKeyboardBrk },    // Sun power
  { 0xff51, EKeyboardLeftArrow },
  { 0xff53, EKeyboardRightArrow },
  { 0xff52, EKeyboardUpArrow },
  { 0xff54, EKeyboardDownArrow },
  { 0x0000, 0x0000 },
};

const unsigned char kBmDataBusy[]={
  0x53,0x56,  0x55,0x51,  0x53,0x22,  0x55,0x24,  0x73,0x23
};
const unsigned char kBmDataShift[]={
  0x56, 0xdd, 0x01,
  0x51, 0x85, 0x00,
  0x72, 0x9d, 0x00,
  0x54, 0x85, 0x00,
  0x53, 0x85, 0x00,
};
const unsigned char kBmDataDef[]={
  0x73,0x07,  0x15,0x01,  0x75,0x07,  0x15,0x01,  0x73,0x01,
};
const unsigned char kBmDataP[]={
  0x03,0x05,0x03,0x01,0x01
};
const unsigned char kBmDataE[]={
  0x07,0x01,0x07,0x01,0x07
};
const unsigned char kBmDataDe[]={
  0x73,0x15,0x75,0x15,0x73
};
const unsigned char kBmDataG[]={
  0x06,0x01,0x05,0x05,0x06
};
const unsigned char kBmDataRad[]={
  0x23,0x03,  0x55,0x05,  0x73,0x05,  0x55,0x05,  0x55,0x03
};
const unsigned char kBmDataSmall[]={
  0x56, 0x92, 0x00,
  0x71, 0x95, 0x00,
  0x72, 0x97, 0x00,
  0x54, 0x95, 0x00,
  0x53, 0xb5, 0x01,
};
const unsigned char kBmDataKana[]={
  0x42, 0xef, 0x4a, 0x4a, 0x2a
};

const struct TSoftkey gSoftkey[]={
  { EKeyboardBrk, "BRK" },
  { EKeyboardCl,  "CL " },
  { EKeyboardDef, "DEF" },
  { '+', "+" },
  { '-', "-" },
  { '*', "*" },
  { '/', "/" },
  { '=', "=" },
  { EKeyboardNone, NULL },
};
const int kNumSoftkey = sizeof(gSoftkey)/sizeof(TSoftkey)-1;

/***************************
      E X T E R N Z
***************************/
extern TPocketComHw *gHw;

/***************************
      G L O B A L Z
***************************/
extern TCpuState gCpuState;  // global variable which holds CPU status and etc.
extern TCpuFunction gCpuFunction;  // global variable which holds CPU status and etc.
XtAppContext gAppCon;
Display      *gDisplay;
Widget       gToplevel, gwMain, gwLcd, gwBox0;
Widget       gwMenuBar, gwPullDownPowsw, gwPullDownModel;
Widget       gwPullDownFile, gwPullDownSpecial, gwPullDownQuestion;
Widget       gwPullDownKey, gwButtonBox;
Pixmap       gOffScreen;
Pixmap       gPixmapShiftOn, gPixmapShiftOff;
Pixmap       gPixmapDefOn, gPixmapDefOff;
Pixmap       gPixmapPOn, gPixmapPOff;
Pixmap       gPixmapBusyOn, gPixmapBusyOff;
Pixmap       gPixmapDeOn, gPixmapDeOff;
Pixmap       gPixmapGOn, gPixmapGOff;
Pixmap       gPixmapRadOn, gPixmapRadOff;
Pixmap       gPixmapEOn, gPixmapEOff;
Pixmap       gPixmapSmallOn, gPixmapSmallOff;
Pixmap       gPixmapKanaOn, gPixmapKanaOff;
XImage       *gVram;
char         *gVramData;
int          gScreen;
XtWorkProcId gMainWpId;
bool         gIsVramUpdated = false;
TPoemsEvent  gEventQueue[kEventQLength];
int          gEventQHead = 0;
int          gEventQTail = 0;
enum fileIoMode gFileIoMode;
XColor       gXColourFg;
XColor       gXColourBg;
XColor       gXColourBgBg;
long         gTodaysSec;


void PopupDialog( char *aMsg,
		  Widget (aDialogFunc(Widget,char*,ArgList,Cardinal))=XmCreateErrorDialog );



void pel_Alert( const char *aFormat, ... ){
  va_list argptr;
  char    msg[1024];
  va_start( argptr, aFormat );
  vsprintf( msg, aFormat, argptr );
  PopupDialog( msg, XmCreateWarningDialog );
  va_end( argptr );
}

void *pel_Malloc( int aAmount ){
  return malloc( aAmount );
}
void pel_Free( void *aAddress ){
  free( aAddress );
}
void pel_GetNextEvent( TPoemsEvent *aEvent ){
  if( gEventQHead == gEventQTail ){
    aEvent->iType = ENoEvent;
  }else{
    *aEvent = gEventQueue[gEventQTail];
    gEventQTail = (gEventQTail+1)%kEventQLength;
  }
}
void pel_DrawDot( int aX, int aY, int aOn ){
  if( gHw->iModel != EModelPC1350 ){
    if( (aY&0x07) == 0x07 ) return;
    aX=aX*6/5;
  }
  switch( gHw->iModel ){
    case EModelPC1245:
      if( aX>=96 ) return;
    case EModelPC1250:
    case EModelPC1251:
    case EModelPC1255:
      XSetForeground( gDisplay,
		      DefaultGC( gDisplay,DefaultScreen(gDisplay)),
		      aOn?gXColourFg.pixel:gXColourBg.pixel );
      XFillRectangle( gDisplay, gOffScreen,
		      DefaultGC( gDisplay,DefaultScreen(gDisplay)),
		      23+aX*2,aY*2+28,2,2 );
      break;
    case EModelPC1260:
    case EModelPC1261:
    case EModelPC1262:
      XSetForeground( gDisplay,
		      DefaultGC( gDisplay,DefaultScreen(gDisplay)),
		      aOn?gXColourFg.pixel:gXColourBg.pixel );
      XFillRectangle( gDisplay, gOffScreen,
		      DefaultGC( gDisplay,DefaultScreen(gDisplay)),
		      27+aX*2,aY*2+19,2,2 );
      gIsVramUpdated = true;
      break;
  }
}
void pel_DrawSymbol( enum LcdSymbol aSymbol, int aOn ){
  switch( aSymbol ){
  case ESymbolSHIFT:
    switch( gHw->iModel ){
    case EModelPC1245:
      XCopyArea( gDisplay,
		 aOn?gPixmapShiftOn:gPixmapShiftOff,
		 gOffScreen,
		 DefaultGC( gDisplay,DefaultScreen(gDisplay)),
		 0,0,18,5,196,19 );
      break;
    case EModelPC1250:
    case EModelPC1251:
    case EModelPC1255:
      XCopyArea( gDisplay,
		 aOn?gPixmapShiftOn:gPixmapShiftOff,
		 gOffScreen,
		 DefaultGC( gDisplay,DefaultScreen(gDisplay)),
		 0,0,18,5,222,19 );
      break;
    case EModelPC1260:
    case EModelPC1261:
    case EModelPC1262:
      XCopyArea( gDisplay,
		 aOn?gPixmapShiftOn:gPixmapShiftOff,
		 gOffScreen,
		 DefaultGC( gDisplay,DefaultScreen(gDisplay)),
		 0,0,18,5,7,37 );
      break;
    }
    break;
  case ESymbolDEF:
    switch( gHw->iModel ){
    case EModelPC1245:
    case EModelPC1250:
    case EModelPC1251:
    case EModelPC1255:
      XCopyArea( gDisplay,
		 aOn?gPixmapDefOn:gPixmapDefOff,
		 gOffScreen,
		 DefaultGC( gDisplay,DefaultScreen(gDisplay)),
		 0,0,12,5,70,19 );
      break;
    case EModelPC1260:
    case EModelPC1261:
    case EModelPC1262:
      XCopyArea( gDisplay,
		 aOn?gPixmapDefOn:gPixmapDefOff,
		 gOffScreen,
		 DefaultGC( gDisplay,DefaultScreen(gDisplay)),
		 0,0,12,5,11,45 );
      break;
    }
    break;
  case ESymbolP:
    XCopyArea( gDisplay,
	       aOn?gPixmapPOn:gPixmapPOff,
	       gOffScreen,
	       DefaultGC( gDisplay,DefaultScreen(gDisplay)),
	       0,0,4,5,50,19 );
    break;
  case ESymbolPRINT:
    XSetForeground( gDisplay,
		    DefaultGC( gDisplay,gScreen ),
		    aOn?gXColourFg.pixel:gXColourBg.pixel );
    XFillRectangle( gDisplay, gOffScreen,
		    DefaultGC(gDisplay, gScreen),
		    65,51,6,2 );
    break;
  case ESymbolDEGREE:
    XSetForeground( gDisplay,
		    DefaultGC( gDisplay,gScreen ),
		    aOn?gXColourFg.pixel:gXColourBg.pixel );
    XFillRectangle( gDisplay, gOffScreen,
		    DefaultGC(gDisplay, gScreen),
		    101,51,6,2 );
    break;
  case ESymbolRADIAN:
    XSetForeground( gDisplay,
		    DefaultGC( gDisplay,gScreen ),
		    aOn?gXColourFg.pixel:gXColourBg.pixel );
    XFillRectangle( gDisplay, gOffScreen,
		    DefaultGC(gDisplay, gScreen),
		    125,51,6,2 );
    break;
  case ESymbolERROR:
    XSetForeground( gDisplay,
		    DefaultGC( gDisplay,gScreen ),
		    aOn?gXColourFg.pixel:gXColourBg.pixel );
    XFillRectangle( gDisplay, gOffScreen,
		    DefaultGC(gDisplay, gScreen),
		    185,51,6,2 );
    break;
  case ESymbol207C_40:
    XSetForeground( gDisplay,
		    DefaultGC( gDisplay,gScreen ),
		    aOn?gXColourFg.pixel:gXColourBg.pixel );
    XFillRectangle( gDisplay, gOffScreen,
		    DefaultGC(gDisplay, gScreen),
		    209,51,6,2 );
    break;
  case ESymbolE:
    XCopyArea( gDisplay,
	       aOn?gPixmapEOn:gPixmapEOff,
	       gOffScreen,
	       DefaultGC( gDisplay,DefaultScreen(gDisplay)),
	       0,0,4,5,278,19 );
    break;
  case ESymbolBUSY:
    if( gHw->iModel == EModelPC1260 ||
	gHw->iModel == EModelPC1261 ||
	gHw->iModel == EModelPC1262 ){
      XSetForeground( gDisplay,
		      DefaultGC( gDisplay,gScreen ),
		      aOn?gXColourFg.pixel:gXColourBg.pixel );
      XFillRectangle( gDisplay, gOffScreen,
		      DefaultGC(gDisplay, gScreen),
		      29,51,6,2 );
    }else{
      XCopyArea( gDisplay,
		 aOn?gPixmapBusyOn:gPixmapBusyOff,
		 gOffScreen,
		 DefaultGC( gDisplay,DefaultScreen(gDisplay)),
		 0,0,16,5,23,19 );
    }
    break;
  case ESymbolDE:
    XCopyArea( gDisplay,
	       aOn?gPixmapDeOn:gPixmapDeOff,
	       gOffScreen,
	       DefaultGC( gDisplay,DefaultScreen(gDisplay)),
	       0,0,8,5,112,19 );
    break;
  case ESymbolG:
    XCopyArea( gDisplay,
	       aOn?gPixmapGOn:gPixmapGOff,
	       gOffScreen,
	       DefaultGC( gDisplay,DefaultScreen(gDisplay)),
	       0,0,12,5,120,19 );
    break;
  case ESymbolRAD:
    XCopyArea( gDisplay,
	       aOn?gPixmapRadOn:gPixmapRadOff,
	       gOffScreen,
	       DefaultGC( gDisplay,DefaultScreen(gDisplay)),
	       0,0,12,5,124,19 );
    break;
  case ESymbolSMALL:
    XCopyArea( gDisplay,
	       aOn?gPixmapSmallOn:gPixmapSmallOff,
	       gOffScreen,
	       DefaultGC( gDisplay,DefaultScreen(gDisplay)),
	       0,0,17,5,7,27 );
    break;
  case ESymbolKANA:
    XCopyArea( gDisplay,
	       aOn?gPixmapKanaOn:gPixmapKanaOff,
	       gOffScreen,
	       DefaultGC( gDisplay,DefaultScreen(gDisplay)),
	       0,0,8,5,11,19 );
    break;
  deafult:
    break;
  }
  gIsVramUpdated = true;
}
long pel_GetTickCountUsec( void ){
  struct timeval tv;
  gettimeofday( &tv,NULL );
  return tv.tv_usec + (tv.tv_sec-gTodaysSec)*1000000;
  return clock()*1000000/CLOCKS_PER_SEC;
}
void pel_SleepUsec( int aUsec ){
  struct timespec ts;
  ts.tv_sec  = 0;
  ts.tv_nsec = aUsec*1000;
  nanosleep( &ts, NULL );
}

void RedrawLcd( Widget aWidget,
		XtPointer aClientData,
		XtPointer aCallData ){
  //  XPutImage( gDisplay, gOffScreen, DefaultGC( gDisplay, gScreen ),
  //	     gVram,0,0,0,0,320,16 );
  if( gHw->iPortC & 0x08 ){
    XSetForeground( gDisplay,
		    DefaultGC( gDisplay,gScreen ),
		    gXColourBgBg.pixel );
    switch( gHw->iModel ){
    case EModelPC1245:
      XCopyArea( gDisplay, gOffScreen, XtWindow(aWidget),
		 DefaultGC(gDisplay, gScreen),
		 0,0, 320,17,0, 0 );
      XCopyArea( gDisplay, gOffScreen, XtWindow(aWidget),
		 DefaultGC(gDisplay, gScreen),
		 0,47, 320,17,0, 47 );
      XCopyArea( gDisplay, gOffScreen, XtWindow(aWidget),
		 DefaultGC(gDisplay, gScreen),
		 0,0, 17,64,0, 0 );
      XCopyArea( gDisplay, gOffScreen, XtWindow(aWidget),
		 DefaultGC(gDisplay, gScreen),
		 221,0, 99,64,221, 0 );
      XFillRectangle( gDisplay, XtWindow(aWidget),
		      DefaultGC(gDisplay, gScreen),
		      17,17,204,30 );
      break;
    case EModelPC1250:
    case EModelPC1251:
    case EModelPC1255:
      XCopyArea( gDisplay, gOffScreen, XtWindow(aWidget),
		 DefaultGC(gDisplay, gScreen),
		 0,0, 320,17,0, 0 );
      XCopyArea( gDisplay, gOffScreen, XtWindow(aWidget),
		 DefaultGC(gDisplay, gScreen),
		 0,47, 320,17,0, 47 );
      XCopyArea( gDisplay, gOffScreen, XtWindow(aWidget),
		 DefaultGC(gDisplay, gScreen),
		 0,0, 17,64,0, 0 );
      XCopyArea( gDisplay, gOffScreen, XtWindow(aWidget),
		 DefaultGC(gDisplay, gScreen),
		 313,0, 7,64,313, 0 );
      XFillRectangle( gDisplay, XtWindow(aWidget),
		      DefaultGC(gDisplay, gScreen),
		      17,17,296,30 );
      break;
    case EModelPC1260:
    case EModelPC1261:
    case EModelPC1262:
      XCopyArea( gDisplay, gOffScreen, XtWindow(aWidget),
		 DefaultGC(gDisplay, gScreen),
		 0,0, 320,16,0, 0 );
      XCopyArea( gDisplay, gOffScreen, XtWindow(aWidget),
		 DefaultGC(gDisplay, gScreen),
		 0,53, 320,11,0, 53 );
      XCopyArea( gDisplay, gOffScreen, XtWindow(aWidget),
		 DefaultGC(gDisplay, gScreen),
		 0,0, 7,64,0, 0 );
      XCopyArea( gDisplay, gOffScreen, XtWindow(aWidget),
		 DefaultGC(gDisplay, gScreen),
		 307,0, 13,64,307, 0 );
      XFillRectangle( gDisplay, XtWindow(aWidget),
		      DefaultGC(gDisplay, gScreen),
		      7,16,307,37 );
      break;
    default:
      XFillRectangle( gDisplay, XtWindow(aWidget),
		      DefaultGC(gDisplay, gScreen),
		      0,0,340,64 );
    }
  }else{
    XCopyArea( gDisplay, gOffScreen, XtWindow(aWidget),
	       DefaultGC(gDisplay, gScreen),
	       0,0, 320,64,0, 0 );
  }
}


int SetSkin( enum Model aModel ){
  const char *modelS;
  char filename[256];
  char buf[256];
  FILE *fd;
  int  x,y, curCol, lastCol;
  XColor  xColour;
  bool isQuery;     // a flag if invoke XQueryColor()

  switch( aModel ){
  case EModelPC1245:
    modelS = "1245";
    break;
  case EModelPC1250:
    modelS = "1250";
    break;
  case EModelPC1251:
    modelS = "1251";
    break;
  case EModelPC1255:
    modelS = "1255";
    break;
  case EModelPC1260:
    modelS = "1260";
    break;
  case EModelPC1261:
    modelS = "1261";
    break;
  case EModelPC1262:
    modelS = "1262";
    break;
  default:
    modelS = "generic";
  }
  strcpy( filename, "skin" );
  strcat( filename, modelS );
  strcat( filename, ".ppm" );
  fd = fopen( filename,"rb" );
  if( fd==NULL ){
    pel_Alert( "Warning: no skin file \"%s\".",filename );
    return -1;
  }
  // read ppm file
  fgets( buf, 4, fd );
  if( strncmp( buf,"P6", 2 )!=0 ){
    pel_Alert( "Warning: not a ppm file, but proceeding." );
  }
  fgets( buf, 255, fd );
  if( buf[0]=='#' ){
    fgets( buf, 255, fd );
  }
  if( strncmp( buf,"320 64", 6 )!=0 ){
    pel_Alert( "Warning: ppm size may not be 320x64, but proceeding." );
  }
  fgets( buf, 5, fd );
  lastCol=-1;
  for( y=0; y<64; y++ ){
    for( x=0; x<320; x++ ){
      xColour.red   = fgetc( fd ) << 8;
      xColour.green = fgetc( fd ) << 8;
      if( feof( fd ) ) break;
      xColour.blue  = fgetc( fd ) << 8;
      curCol = (xColour.red<<16)+(xColour.green<<8)+xColour.blue;
      if( curCol!=lastCol ){
	XAllocColor( gDisplay, DefaultColormap( gDisplay, gScreen ), &xColour );
	XSetForeground( gDisplay, DefaultGC(gDisplay,gScreen), xColour.pixel );
	lastCol=curCol;
      }
      XDrawPoint( gDisplay, gOffScreen, DefaultGC(gDisplay,gScreen), x, y );
    }
  }
  fclose( fd );
  return 0;
}

void LoadMainMemory( enum Model aModel, unsigned char *aExtRam ){
  char fileName[1024];
  char buf[1024];
  const char *modelS;
  FILE  *memimage;
  switch( aModel ){
  case EModelPC1245:
    modelS = "1245";
    break;
  case EModelPC1250:
    modelS = "1250";
    break;
  case EModelPC1251:
    modelS = "1251";
    break;
  case EModelPC1255:
    modelS = "1255";
    break;
  case EModelPC1260:
    modelS = "1260";
    break;
  case EModelPC1261:
    modelS = "1261";
    break;
  case EModelPC1262:
    modelS = "1262";
    break;
  default:
    modelS = "generic";
  }
  strcpy( fileName,"pc" );
  strcat( fileName, modelS );
  strcat( fileName,"mem.bin" );
  if( !(memimage=fopen( fileName,"rb")) ){
    pel_Alert( "Can't open \"%s\"",fileName );
    return;
  }
  fread( (void*)aExtRam, 65536,1, memimage );
  if( aModel==EModelPC1261 || aModel==EModelPC1262 ){
    gHw->iExtRam[0x5d6]=0x0b;  // PC-1262 bug fix code
  }
  fclose( memimage );  
}

Boolean MainWp( XtPointer aClientData ){
  struct timeval tv;
  static long lastTick=0;
  long curTick;

  //  printf("\n");
#ifdef NODEF
  printf("\nPC=%04x  i=%02x %02x%02x a=%02x I=%02x",gCpuState.iPc,
	 gHw->iExtRam[gCpuState.iPc],
	 gHw->iExtRam[gCpuState.iPc+1],
	 gHw->iExtRam[gCpuState.iPc+2],
	 gCpuState.iInnerRam[kRamA],
	 gCpuState.iInnerRam[kRamI]
	 );
#endif
  pe_MainCallBack();
  /*
  printf(" R=%02x (%02x %02x)",gCpuState.iR, gCpuState.iInnerRam[gCpuState.iR], gCpuState.iInnerRam[gCpuState.iR+1] );
  printf(" A=%02x",gCpuState.iInnerRam[kRamA]);
  printf(" P=%02x",gCpuState.iP);
  printf(" C=%1x",gCpuState.iCFlag);
  printf(" Z=%1x",gCpuState.iZFlag);
  */
  gettimeofday( &tv,NULL );
  curTick = tv.tv_usec + (tv.tv_sec-gTodaysSec)*1000000;
  if( curTick-lastTick > kRefreshRateUs ){
    RedrawLcd( gwLcd,NULL,NULL );
    gIsVramUpdated = false;
    lastTick = curTick;
  }
  return FALSE;
}

////// POEMS file load
int LoadFile( char *aFileName ){
}


////// File Secection dialog
void FileSBCancel( Widget aW,
		   XtPointer aClientData,
		   XtPointer aCallbackData ){
  XtUnmanageChild( aW );
}


void FileSBOkay( Widget aW,
		 XtPointer aClientData,
		 XtPointer aCallbackData ){
  FILE *fd;
  char *path;
  unsigned char buf[65536];
  int  addrS, addrE;

  path = XmTextFieldGetString(XmFileSelectionBoxGetChild(aW,XmDIALOG_TEXT));

  XtUnrealizeWidget( aW );
  if( gFileIoMode == EFileIoDump ){///////////////////////////  DUMP
    if( (fd=fopen( path,"wb" ))==NULL ){
      PopupDialog( "Cannot open file." );
    }else{
      switch( gHw->iModel ){
      case EModelPC1245:
      case EModelPC1250:
      case EModelPC1251:
      case EModelPC1255:
	addrS = 0xa000;
	addrE = 0xffff;
	break;
      case EModelPC1260:
      case EModelPC1261:
      case EModelPC1262:
	addrS = 0x2000;
	addrE = 0x67ff;
	break;
      default:
	addrS = 0x0000;
	addrE = 0xffff;
      }
      sprintf( (char*)buf,"POEMS00%c%c%c%c     ",
	       addrS>>8, addrS&0xff, addrE>>8, addrE&0xff );
      fwrite( buf, 16, 1, fd );
      fwrite( &gCpuState, 1, sizeof(gCpuState), fd );
      fwrite( &(gHw->iExtRam[addrS]), 1, addrE-addrS+1, fd );
      fclose(fd);
    }
  }else{                          ///////////////////////////  RESTORE
    if( (fd=fopen( path,"rb" ))==NULL ){
      PopupDialog( "Cannot open file." );
    }else{
      fread( buf, 16, 1, fd );
      if( strncmp( (char*)buf,"POEMS00",7 )!=0 ){
	PopupDialog( "Invalid file." );
      }else{
	fread( &gCpuState, 1, sizeof(gCpuState), fd );
	gCpuState.iExtRam=gHw->iExtRam;
	addrS = (buf[7]<<8)+buf[8];
	addrE = (buf[9]<<8)+buf[10];
	fread( &(gHw->iExtRam[addrS]), 1, addrE-addrS+1, fd );
      }
      fclose(fd);
    }
  }
}

void SelectFile( char *aTitleString=NULL ){
  Widget wDialog, wFileSB, wButton1, wButton2, wText;
  wDialog = XmCreateFileSelectionDialog( gwMain, "Files", NULL, 0);
  XmString onaraS=XmStringCreateSimple("*poe");
  XtVaSetValues( wDialog,
		 XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
		 XmNfileTypeMask, XmFILE_REGULAR,
		 XmNdirMask,onaraS,
		 NULL );
  XmStringFree(onaraS);
  if( aTitleString ){
    onaraS = XmStringCreateSimple( aTitleString );
    XtVaSetValues( XmFileSelectionBoxGetChild(wDialog, XmDIALOG_OK_BUTTON),
		  XmNlabelString, onaraS,
		  NULL );
    XmStringFree(onaraS);
  }
  XtUnmanageChild(XmFileSelectionBoxGetChild(wDialog, XmDIALOG_HELP_BUTTON));
  XtManageChild(wDialog);
  XtAddCallback(wDialog, XmNcancelCallback,FileSBCancel, NULL);
  XtAddCallback(wDialog, XmNokCallback,FileSBOkay, NULL);
}

void PopupDialog( char *aMsg, Widget (aDialogFunc(Widget,char*,ArgList,Cardinal))=XmCreateErrorDialog ){
  Widget wDialog;
  XmString msgS = XmStringCreateSimple( aMsg );
  //wDialog = XmCreateErrorDialog( gwMain, "INFO",
  wDialog = (*aDialogFunc)( gwMain, "INFO", NULL, 0 );
  XtVaSetValues( wDialog,
		 XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
		 XmNmessageString, msgS,
		 NULL );
  XtUnmanageChild(XmMessageBoxGetChild(wDialog, XmDIALOG_CANCEL_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(wDialog, XmDIALOG_HELP_BUTTON));

  XtManageChild(wDialog);
  XtAddCallback(wDialog, XmNcancelCallback,FileSBCancel, NULL);
  XtAddCallback(wDialog, XmNokCallback,FileSBCancel, NULL);
  XmStringFree( msgS );
}

////// software key callback
void KeyButtonPressCB( Widget aMenuItem,
		       XtPointer aClientData,
		       XtPointer aCallbackData ){
  gEventQueue[gEventQHead].iType = EKeyPressEvent;
  gEventQueue[gEventQHead].iArg1.iKeyCode = (int)aClientData;
  gEventQHead = (gEventQHead+1)%kEventQLength;
}
void KeyButtonReleaseCB( Widget aMenuItem,
			 XtPointer aClientData,
			 XtPointer aCallbackData ){
    gEventQueue[gEventQHead].iType = EKeyReleaseEvent;
    gEventQueue[gEventQHead].iArg1.iKeyCode = (int)aClientData;
    gEventQHead = (gEventQHead+1)%kEventQLength;
}

////// power switch pull down menu callback
void PowerSwitchCB( Widget aMenuItem,
		    XtPointer aClientData,
		    XtPointer aCallbackData ){
  int itemNo = (int)aClientData;
  char namebuf[256];
  Widget w;
  for( int i=0; i<4; i++ ){
    sprintf( namebuf, "button_%d",i );
    w = XtNameToWidget( gwPullDownPowsw, namebuf );
    if( w==NULL ) continue;
    XmToggleButtonGadgetSetState( w, i==itemNo, FALSE );
  }
  gEventQueue[gEventQHead].iType = ESwitchChangeEvent;
  switch( itemNo ){
  case 3:
    gEventQueue[gEventQHead].iArg1.iPowerSwitchState = EPowerSwitchOff;
    break;
  case 2:
    gEventQueue[gEventQHead].iArg1.iPowerSwitchState = EPowerSwitchRun;
    break;
  case 1:
    gEventQueue[gEventQHead].iArg1.iPowerSwitchState = EPowerSwitchPro;
    break;
  case 0:
    gEventQueue[gEventQHead].iArg1.iPowerSwitchState = EPowerSwitchReserve;
    break;
  }
  gEventQHead = (gEventQHead+1)%kEventQLength;
}

void ModelCB( Widget aMenuItem,
	      XtPointer aClientData,
	      XtPointer aCallbackData ){
  const enum Model model[]={
    EModelPC1245, EModelPC1250, EModelPC1251, EModelPC1255, EModelPC1260, EModelPC1261, EModelPC1262, EModelPC1450, EModelPC1350
  };
  int itemNo = (int)aClientData;
  char namebuf[256];
  Widget w;
  for( int i=0; i<8; i++ ){
    sprintf( namebuf, "button_%d",i );
    w = XtNameToWidget( gwPullDownModel, namebuf );
    if( w==NULL ) continue;
    XmToggleButtonGadgetSetState( w, i==itemNo, FALSE );
  }
  gEventQueue[gEventQHead].iType = EModelChangeEvent;
  gEventQueue[gEventQHead].iArg1.iModel = model[itemNo];
  gEventQHead = (gEventQHead+1)%kEventQLength;
  pe_InitializeAll();
  LoadMainMemory( model[itemNo], gHw->iExtRam );
  SetSkin( model[itemNo] );
}

void QuestionCB( Widget aMenuItem,
		 XtPointer aClientData,
		 XtPointer aCallbackData ){
  switch( (int)aClientData ){
  case 0:
    PopupDialog( "xpc12xx: PC-12xx emulator by Yagshi 2002",
		 XmCreateInformationDialog);
    break;
  }
}
void SpecialCB( Widget aMenuItem,
		XtPointer aClientData,
		XtPointer aCallbackData ){
  switch( (int)aClientData ){
  case 0:
    gEventQueue[gEventQHead].iType = EResetEvent;
    gEventQHead = (gEventQHead+1)%kEventQLength;
    break;
  }
}



void FileCB( Widget aMenuItem,
	     XtPointer aClientData,
	     XtPointer aCallbackData ){
  switch( (int)aClientData ){
  case 0:
    gFileIoMode = EFileIoDump;
    SelectFile("DUMP");
    break;
  case 1:
    gFileIoMode = EFileIoRestore;
    SelectFile("RESTORE");
    break;
  case 2:
    exit(0);
  default:
    break;
  }
  
}


XtEventHandler KeyEventHandler( Widget aW, XtPointer aClosure,
				XEvent* aEv, Boolean *aCont ){
  int  i;
  int  keysym =XKeycodeToKeysym(gDisplay, ((XKeyEvent*)aEv)->keycode,0);
  if( aEv->type== KeyPress ){
    gEventQueue[gEventQHead].iType = EKeyPressEvent;
  }else{
    gEventQueue[gEventQHead].iType = EKeyReleaseEvent;
  }
  gEventQueue[gEventQHead].iArg1.iKeyCode = toupper(keysym)&0xff;
  i = 0;
  while( kKeyRemapTable[i][0] ){
    if( keysym==kKeyRemapTable[i][0] ){
      gEventQueue[gEventQHead].iArg1.iKeyCode = kKeyRemapTable[i][1];
    }
    i++;
  }
  gEventQHead = (gEventQHead+1)%kEventQLength;
}

int main( int argc, char *argv[] ){
  FILE *memimage;
  struct timeval tv;

  gettimeofday( &tv,NULL );
  gTodaysSec = tv.tv_sec;


  // X11 Setup
  gToplevel = XtVaAppInitialize( &gAppCon, "XPc12xx", NULL, 0,
				 &argc, argv,
				 NULL, NULL );
  gDisplay = XtDisplay( gToplevel );
  gScreen  = DefaultScreen( gDisplay );

  ////////////////////  S T R i N G Z /////////////////////////
  // FILE
  XmString  fileS    = XmStringCreateSimple("File");
  XmString  dumpS    = XmStringCreateSimple("Dump");
  XmString  restoreS = XmStringCreateSimple("Restore");
  XmString  quitS    = XmStringCreateSimple("Quit");
  // POWER SWITCH
  XmString  powswS   = XmStringCreateSimple("PowerSW");
  XmString  reserveS = XmStringCreateSimple("RESERVE");
  XmString  proS     = XmStringCreateSimple("PRO");
  XmString  runS     = XmStringCreateSimple("RUN");
  XmString  offS     = XmStringCreateSimple("OFF");
  // SPECIAL MENU
  XmString specialS  = XmStringCreateSimple("Special");
  XmString resetS    = XmStringCreateSimple("Reset");
  // MODEL MENU
  XmString modelS    = XmStringCreateSimple("Model");
  XmString pc1245S   = XmStringCreateSimple("PC-1245");
  XmString pc1250S   = XmStringCreateSimple("PC-1250");
  XmString pc1251S   = XmStringCreateSimple("PC-1251");
  XmString pc1255S   = XmStringCreateSimple("PC-1255");
  XmString pc1260S   = XmStringCreateSimple("PC-1260");
  XmString pc1261S   = XmStringCreateSimple("PC-1261");
  XmString pc1262S   = XmStringCreateSimple("PC-1262");
  XmString pc1450S   = XmStringCreateSimple("PC-1450");
  XmString pc1350S   = XmStringCreateSimple("PC-1350");
  // HELP
  XmString questionS = XmStringCreateSimple("?");
  XmString aboutS    = XmStringCreateSimple("About");
  ////////////////////  C O L O U R Z /////////////////////////
  gXColourFg.red   = (kColourFg&0xff0000)>>8;
  gXColourFg.green = (kColourFg&0x00ff00);
  gXColourFg.blue  = (kColourFg&0xff)<<8;
  XAllocColor( gDisplay, DefaultColormap( gDisplay, gScreen ), &gXColourFg );
  XQueryColor( gDisplay, DefaultColormap( gDisplay, gScreen ), &gXColourFg );
  gXColourBg.red   = (kColourBg&0xff0000)>>8;
  gXColourBg.green = (kColourBg&0x00ff00);
  gXColourBg.blue  = (kColourBg&0xff)<<8;
  XAllocColor( gDisplay, DefaultColormap( gDisplay, gScreen ), &gXColourBg );
  XQueryColor( gDisplay, DefaultColormap( gDisplay, gScreen ), &gXColourBg );
  gXColourBgBg.red   = (kColourBgBg&0xff0000)>>8;
  gXColourBgBg.green = (kColourBgBg&0x00ff00);
  gXColourBgBg.blue  = (kColourBgBg&0xff)<<8;
  XAllocColor( gDisplay, DefaultColormap( gDisplay, gScreen ), &gXColourBgBg );
  XQueryColor( gDisplay, DefaultColormap( gDisplay, gScreen ), &gXColourBgBg );
  /////////////////////////////////////////////////////////////
  gwMain = XtVaCreateWidget("main_w", xmMainWindowWidgetClass,
			    gToplevel,
			    XmNshowSeparator, False,
			    NULL);
  gwMenuBar = XmVaCreateSimpleMenuBar( gwMain, "menubar",
				       XmVaCASCADEBUTTON, fileS,'F',
				       XmVaCASCADEBUTTON, powswS,'P',
				       XmVaCASCADEBUTTON, specialS,'S',
				       XmVaCASCADEBUTTON, modelS,'M',
				       XmVaCASCADEBUTTON, questionS,'?',
				       NULL );
  gwPullDownPowsw =
    XmVaCreateSimplePulldownMenu( gwMenuBar,"pdpowsw",
				  1,PowerSwitchCB,
				  XmVaRADIOBUTTON,reserveS,'V',NULL,NULL,
				  XmVaRADIOBUTTON,proS,'P',NULL,NULL,
				  XmVaRADIOBUTTON,runS,'R',NULL,NULL,
				  XmVaRADIOBUTTON,offS,'O',NULL,NULL,
				  NULL);
  XmToggleButtonGadgetSetState(
			       XtNameToWidget( gwPullDownPowsw,"button_2" ),
			       TRUE, FALSE );
  gwPullDownFile =
    XmVaCreateSimplePulldownMenu( gwMenuBar,"pdfile",
				  0,FileCB,
				  XmVaPUSHBUTTON,dumpS,'D',NULL,NULL,
				  XmVaPUSHBUTTON,restoreS,'R',NULL,NULL,
				  XmVaSEPARATOR,
				  XmVaPUSHBUTTON,quitS,'Q',NULL,NULL,
				  NULL);
  gwPullDownSpecial = 
    XmVaCreateSimplePulldownMenu( gwMenuBar,"pdspecial",
				  2,SpecialCB,
				  XmVaPUSHBUTTON,resetS,'R',NULL,NULL,
				  NULL
				  );
  gwPullDownQuestion = 
    XmVaCreateSimplePulldownMenu( gwMenuBar,"pdquestion",
				  4,QuestionCB,
				  XmVaPUSHBUTTON, aboutS,'A',NULL,NULL,
				  NULL );
  gwPullDownModel =
    XmVaCreateSimplePulldownMenu( gwMenuBar,"pdmodel",
				  3,ModelCB,
				  XmVaRADIOBUTTON, pc1245S,'4',NULL,NULL,
				  XmVaRADIOBUTTON, pc1250S,'0',NULL,NULL,
				  XmVaRADIOBUTTON, pc1251S,'1',NULL,NULL,
				  XmVaRADIOBUTTON, pc1255S,'5',NULL,NULL,
				  XmVaRADIOBUTTON, pc1260S,'6',NULL,NULL,
				  XmVaRADIOBUTTON, pc1261S,'X',NULL,NULL,
				  XmVaRADIOBUTTON, pc1262S,'2',NULL,NULL,
				  //XmVaRADIOBUTTON, pc1450S,'F',NULL,NULL,
				  //XmVaRADIOBUTTON, pc1350S,'3',NULL,NULL,
				  NULL );
  XmToggleButtonGadgetSetState(
			       XtNameToWidget( gwPullDownModel,"button_0" ),
			       TRUE, FALSE );
  gwBox0 = XtVaCreateWidget("box0",xmFormWidgetClass, gwMain, 
  			    NULL, NULL );
  gwLcd = XtVaCreateManagedWidget("lcd", xmDrawingAreaWidgetClass,
  				  gwBox0,
				  XmNwidth,320,XmNheight,64,
				  XmNtopAttachment,XmATTACH_FORM,
				  NULL,NULL );
  gwButtonBox =XtVaCreateManagedWidget("btnbox",xmRowColumnWidgetClass, gwBox0,
					XmNtopAttachment,XmATTACH_WIDGET,
					XmNtopWidget, gwLcd,
					XmNcursorPositionVisible, false,
					XmNeditable, false,
					XmNresizeHeight, true,
				       XmNorientation, XmHORIZONTAL,
					NULL,NULL);
  Widget wid;
  for( int i=0; i<kNumSoftkey; i++ ){
    wid=XtVaCreateManagedWidget(gSoftkey[i].iLabel,
				xmPushButtonWidgetClass,
				gwButtonBox,
				NULL,NULL );
    XtAddCallback( wid,XmNarmCallback,KeyButtonPressCB,
		   (XtPointer)(gSoftkey[i].iKeycode) );
    XtAddCallback( wid,XmNdisarmCallback,KeyButtonReleaseCB,
		   (XtPointer)(gSoftkey[i].iKeycode) );
  }
  XtVaSetValues( gwMain,
		 XmNcommandWindow, NULL,
		 XmNcommandWindowLocation, XmCOMMAND_ABOVE_WORKSPACE,
		 XmNmenuBar, gwMenuBar,
		 XmNworkWindow, gwBox0,
		 NULL );
  gOffScreen = XCreatePixmap( gDisplay, DefaultRootWindow( gDisplay ),
			      340,320,
			      DefaultDepth(gDisplay,gScreen));
  ///////////////     SET UP SYMBOL PICTUREZ     //////////////
  gPixmapBusyOn =
    XCreatePixmapFromBitmapData( gDisplay, DefaultRootWindow( gDisplay ),
				 (char*)kBmDataBusy, 16,5,
				 gXColourFg.pixel, gXColourBgBg.pixel,
				 DefaultDepth(gDisplay,gScreen));
  gPixmapBusyOff =
    XCreatePixmapFromBitmapData( gDisplay, DefaultRootWindow( gDisplay ),
				 (char*)kBmDataBusy, 16,5,
				 gXColourBg.pixel, gXColourBgBg.pixel,
				 DefaultDepth(gDisplay,gScreen));
  gPixmapShiftOn =
    XCreatePixmapFromBitmapData( gDisplay, DefaultRootWindow( gDisplay ),
				 (char*)kBmDataShift, 18,5,
				 gXColourFg.pixel, gXColourBgBg.pixel,
				 DefaultDepth(gDisplay,gScreen));
  gPixmapShiftOff =
    XCreatePixmapFromBitmapData( gDisplay, DefaultRootWindow( gDisplay ),
				 (char*)kBmDataShift, 18,5,
				 gXColourBg.pixel, gXColourBgBg.pixel,
				 DefaultDepth(gDisplay,gScreen));
  gPixmapDefOn =
    XCreatePixmapFromBitmapData( gDisplay, DefaultRootWindow( gDisplay ),
				 (char*)kBmDataDef, 12,5,
				 gXColourFg.pixel, gXColourBgBg.pixel,
				 DefaultDepth(gDisplay,gScreen));
  gPixmapDefOff =
    XCreatePixmapFromBitmapData( gDisplay, DefaultRootWindow( gDisplay ),
				 (char*)kBmDataDef, 12,5,
				 gXColourBg.pixel, gXColourBgBg.pixel,
				 DefaultDepth(gDisplay,gScreen));
  gPixmapEOn =
    XCreatePixmapFromBitmapData( gDisplay, DefaultRootWindow( gDisplay ),
				 (char*)kBmDataE, 4,5,
				 gXColourFg.pixel, gXColourBgBg.pixel,
				 DefaultDepth(gDisplay,gScreen));
  gPixmapEOff =
    XCreatePixmapFromBitmapData( gDisplay, DefaultRootWindow( gDisplay ),
				 (char*)kBmDataE, 4,5,
				 gXColourBg.pixel, gXColourBgBg.pixel,
				 DefaultDepth(gDisplay,gScreen));
  gPixmapPOn =
    XCreatePixmapFromBitmapData( gDisplay, DefaultRootWindow( gDisplay ),
				 (char*)kBmDataP, 4,5,
				 gXColourFg.pixel, gXColourBgBg.pixel,
				 DefaultDepth(gDisplay,gScreen));
  gPixmapPOff =
    XCreatePixmapFromBitmapData( gDisplay, DefaultRootWindow( gDisplay ),
				 (char*)kBmDataP, 4,5,
				 gXColourBg.pixel, gXColourBgBg.pixel,
				 DefaultDepth(gDisplay,gScreen));
  gPixmapDeOn =
    XCreatePixmapFromBitmapData( gDisplay, DefaultRootWindow( gDisplay ),
				 (char*)kBmDataDe, 8,5,
				 gXColourFg.pixel, gXColourBgBg.pixel,
				 DefaultDepth(gDisplay,gScreen));
  gPixmapDeOff =
    XCreatePixmapFromBitmapData( gDisplay, DefaultRootWindow( gDisplay ),
				 (char*)kBmDataDe, 8,5,
				 gXColourBg.pixel, gXColourBgBg.pixel,
				 DefaultDepth(gDisplay,gScreen));
  gPixmapGOn =
    XCreatePixmapFromBitmapData( gDisplay, DefaultRootWindow( gDisplay ),
				 (char*)kBmDataG, 4,5,
				 gXColourFg.pixel, gXColourBgBg.pixel,
				 DefaultDepth(gDisplay,gScreen));
  gPixmapGOff =
    XCreatePixmapFromBitmapData( gDisplay, DefaultRootWindow( gDisplay ),
				 (char*)kBmDataG, 4,5,
				 gXColourBg.pixel, gXColourBgBg.pixel,
				 DefaultDepth(gDisplay,gScreen));
  gPixmapRadOn =
    XCreatePixmapFromBitmapData( gDisplay, DefaultRootWindow( gDisplay ),
				 (char*)kBmDataRad, 12,5,
				 gXColourFg.pixel, gXColourBgBg.pixel,
				 DefaultDepth(gDisplay,gScreen));
  gPixmapRadOff =
    XCreatePixmapFromBitmapData( gDisplay, DefaultRootWindow( gDisplay ),
				 (char*)kBmDataRad, 12,5,
				 gXColourBg.pixel, gXColourBgBg.pixel,
				 DefaultDepth(gDisplay,gScreen));
  gPixmapSmallOn =
    XCreatePixmapFromBitmapData( gDisplay, DefaultRootWindow( gDisplay ),
				 (char*)kBmDataSmall, 17,5,
				 gXColourFg.pixel, gXColourBgBg.pixel,
				 DefaultDepth(gDisplay,gScreen));
  gPixmapSmallOff =
    XCreatePixmapFromBitmapData( gDisplay, DefaultRootWindow( gDisplay ),
				 (char*)kBmDataSmall, 17,5,
				 gXColourBg.pixel, gXColourBgBg.pixel,
				 DefaultDepth(gDisplay,gScreen));
  gPixmapKanaOn =
    XCreatePixmapFromBitmapData( gDisplay, DefaultRootWindow( gDisplay ),
				 (char*)kBmDataKana, 8,5,
				 gXColourFg.pixel, gXColourBgBg.pixel,
				 DefaultDepth(gDisplay,gScreen));
  gPixmapKanaOff =
    XCreatePixmapFromBitmapData( gDisplay, DefaultRootWindow( gDisplay ),
				 (char*)kBmDataKana, 8,5,
				 gXColourBg.pixel, gXColourBgBg.pixel,
				 DefaultDepth(gDisplay,gScreen));
  gVramData = (char *)malloc( 320/*width*/*4/*BGR0*/*32/*height*/ );
  gVram = XCreateImage( gDisplay, DefaultVisual( gDisplay, gScreen ),
			DefaultDepth( gDisplay, gScreen ),
			ZPixmap, 0, gVramData,
			320,16, 8, 0 );
  XInitImage( gVram );
  XSetForeground( gDisplay,
		  DefaultGC( gDisplay,gScreen ),
		  gXColourBgBg.pixel );
  XFillRectangle( gDisplay, gOffScreen,
		  DefaultGC( gDisplay, gScreen ),
		  0,0,340,320 );
  SetSkin( EModelPC1245 );
  XtAddCallback( gwLcd, XmNexposeCallback, (XtCallbackProc)RedrawLcd,NULL );

  XmStringFree( powswS );
  XmStringFree( proS );
  XmStringFree( runS );
  XmStringFree( reserveS );
  XmStringFree( fileS );
  XmStringFree( dumpS );
  XmStringFree( restoreS );
  XmStringFree( quitS );
  XmStringFree( specialS );
  XmStringFree( resetS );
  XmStringFree( questionS );
  XmStringFree( aboutS );
  XmStringFree( modelS );
  XmStringFree( pc1245S );
  XmStringFree( pc1250S );
  XmStringFree( pc1251S );
  XmStringFree( pc1255S );
  XmStringFree( pc1260S );
  XmStringFree( pc1261S );
  XmStringFree( pc1262S );
  XmStringFree( pc1450S );
  XmStringFree( pc1350S );
  //
  XtManageChild(gwMenuBar);
  XtManageChild(gwBox0);
  XtManageChild(gwMain);
  XtRealizeWidget(gToplevel);


  XtAppAddWorkProc( gAppCon, MainWp, NULL );
  XtAddEventHandler( gwLcd, KeyPressMask|KeyReleaseMask,False,
		     (XtEventHandler)KeyEventHandler, NULL );


  pe_InitializeAll();
  LoadMainMemory( EModelPC1245, gHw->iExtRam );
  XtAppMainLoop(gAppCon);

}



