/*  pokemun.h  */
#ifndef __POKEMUN_H
#define __POKEMUN_H

enum LcdSymbol{
  ESymbolDEF,ESymbolP,ESymbolG,ESymbolDE,
  ESymbolBUSY,ESymbolSHIFT,ESymbolRAD,ESymbolE,
  ESymbolPRINT,ESymbolKANA,ESymbolSMALL,ESymbolDEGREE,
  ESymbolRADIAN,ESymbolERROR,
  ESymbolRUN,ESymbolPRO,ESymbolSML,ESymbolGRAD,
  ESymbolSTAT,ESymbolHYP,ESymbolCAL,ESymbolM,
  ESymbolBrace,    /* () */
  ESymbol207C_40,  /* PC-126x unknown symbol */
};

enum Model{
  EModelPC1245,
  EModelPC1250,EModelPC1251,EModelPC1255,
  EModelPC1260,EModelPC1261,EModelPC1262,
  EModelPC1450,
  EModelPC1350,
};

enum PowerSwitchState{
  EPowerSwitchOff=0, EPowerSwitchRun=1, EPowerSwitchPro=2,
  EPowerSwitchReserve=3, EPowerSwitchOn=1,
};

enum EventType{
  ENoEvent,
  EKeyPressEvent, EKeyReleaseEvent,
  ESwitchChangeEvent,
  EModelChangeEvent,
  EResetEvent,
};

#define kNumKeyMapRow  10
#define kNumKeyMapColumn 8

#define EKeyboardNone  0
#define EKeyboardBrk   1
#define EKeyboardDef   2
#define EKeyboardShift 3
#define EKeyboardCl    4
//#define EKeyboardDownArrow   -1
#define EKeyboardDownArrow   8
//#define EKeyboardUpArrow     -1
#define EKeyboardUpArrow     7
//#define EKeyboardRightArrow  -1
#define EKeyboardRightArrow  6
//#define EKeyboardLeftArrow   -1
#define EKeyboardLeftArrow   5
#define EKeyboardEnter       0x0d



typedef struct __HardWare{
  unsigned char *iExtRam;
  enum Model iModel;
  enum PowerSwitchState iPowerSwitch;  // power switch
  const int (*iKeyMap)[8];         // reference to corresponding keymap
  int iKeyboard[256];        // keyboard state
  unsigned char iPortA;       // PORT A latch
  unsigned char iPortB;       // PORT B latch
  unsigned char iPortC;       // PORT C latch
  unsigned char iPortT;       // PORT Test latch
  int iTickUsec;      // micro second tick counter 0--511
}TPocketComHw;

typedef struct __PoemsEvent{
  enum EventType iType;       // kind of event
  union{
    int iKeyCode;
    enum PowerSwitchState iPowerSwitchState;
    enum Model iModel;
  }iArg1;
}TPoemsEvent;

/////////////////////////////////////////////
// Low Level Layer
// Platform dependent functions
// ($B%W%i%C%H%U%)!<%`0MB8opZK(B)
//
// You must implement those functions begin with "pel_".


// miscellaneous convenient services
void pel_Alert( const char *aFormat, ... /* args */ ); // similar to printf()

// memory allocation
void *pel_Malloc( int aAmount ); // return NULL if fails.
void pel_Free( void *aAddress );

// main loop related funcs
// Note: The argument aEvent is set properly by Pokemun. You must not
//       change.
void pel_GetNextEvent( TPoemsEvent* const aEvent );

// clock
// return absolute count [ micro sec. ]
long pel_GetTickCountUsec( void );
// sleep micro seconds
void pel_SleepUsec( int aUsec );

// Draw 1 dot. Arguments refer screen pixel position.
// ( i.e. You don't need to count LCD gaps of PC-12xx )
// 1$B%I%C%HIA2h!#K\J*$N%I%C%H:BI8!#$D$^$j(B PC-12 $B7O$N$h$&$K7d4V$,(B
// $B6u$$$F$$$F$b$=$NJ*M}E*6u4V$O?t$($J$$!#(B
// aOn $B$,(B 0 $B$J$i(B (aX,aY) $B$r>C5n(B
// aOn $B$,Hs(B0$B$J$i(B (aX,aY) $B$rE@Et(B
void pel_DrawDot( int aX, int aY, int aOn );

// This is not implemented yet. Please write empty function.
void pel_Buzzer( int aOnOff );

// draw symbol sucu as "BUSY", "SHIFT", "DEF" and so on.
// Turn symbol on if aOn is not zero.
void pel_DrawSymbol( enum LcdSymbol aSymbol, int aOn );


/////////////////////////////////////////////
// $B%W%i%C%H%U%)!<%`Hs0MB8opZK(B
// You don't need to write these functions.
// They are already in "pokemun.c".
/////////////////////////////////////////////
// misc.
void pe_Panic( void );

// 1st initializer
// Call this function when the application is launched or
// pocket-com model is changed.
void pe_InitializeAll( void );

// main loop
// Call this function every time.  It performs 1 CPU instruction
// for 1 call.  It returns zero normally.
// (1$BL?Na<B9TKh$K%j%?!<%s$9$k!#(B 0 $B$G$"$l$P@5>o<B9TCf!#(B)
int pe_MainCallBack( void );

void pe_WriteExternalRam( unsigned short aAddr, unsigned char aData );
unsigned char pe_ReadExternalRam( unsigned short aAddr );
unsigned char pe_ReadExternalRamPc( unsigned short aAddr );
unsigned char pe_ReadPortA(void);
unsigned char pe_ReadPortB(void);
unsigned char pe_ReadPortTest(void);
void pe_WritePortA( unsigned char aData );
void pe_WritePortB( unsigned char aData );
void pe_WritePortC( unsigned char aData );
#endif
