// Smtp.cpp: CSmtp NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "pochy.h"
#include "Smtp.h"
#include "base64.h"
#include "cram.h"
#include "lib.h" // for debug

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CSmtp::CSmtp()
{

}

CSmtp::~CSmtp()
{

}

BOOL CSmtp::Helo(CString &ret)
{
	CString hostname;
	CString send;
	CStringArray line_array;
	char buf[256];

	ret.Empty();

	if(gethostname(buf, 255) == -1){
		hostname = "unknown";
	}else{
		hostname = buf;
	}

	// send helo command
	send.Format("helo %s\r\n", hostname);;
	SockWrite(send, send.GetLength());

	// get reply from server
	if(!ReadMultipleLineReply(line_array)){
		ret = "ReadMultipleLineReply error";
		return FALSE;
	}
	g_cstringarray2cstring(line_array, ret);
	if(line_array[line_array.GetSize()-1].Find("250") == 0){
		return TRUE;
	}else{
		return FALSE;
	}
}

BOOL CSmtp::Ehlo(LPCTSTR user, LPCTSTR password, CString &ret)
{
	CString hostname;
	CString send;
	CStringArray line_array;
	CString auth_response;
	char buf[512];

	ret.Empty();

	if(gethostname(buf, 255) == -1){
		hostname = "unknown";
	}else{
		hostname = buf;
	}

	// send ehlo command
	send.Format("ehlo %s\r\n", hostname);
	SockWrite(send, send.GetLength());

	// get reply from server
	if(!ReadMultipleLineReply(line_array)){
		ret = "ReadMultipleLineReply error";
		return FALSE;
	}

	// keep auth response for later reference
	auth_response = GetAuthResponse(line_array);

	g_cstringarray2cstring(line_array, ret);
	if(line_array[line_array.GetSize()-1].Find("250") != 0){
		return FALSE;
	}

	// smtp auth
	return Auth(user, password, auth_response, ret);
}

BOOL CSmtp::Auth(LPCTSTR user, LPCTSTR password, LPCTSTR auth_response, CString &ret)
{
	char buf[512];
	char b64buf[512];
	CString send;
	CStringArray line_array;
	CString tmp = auth_response;
	int len;

	ret.Empty();

	// if server allow cram-md5 authentification, below is done
	if(tmp.Find("CRAM-MD5") != -1){
		CString challenge;
		unsigned char digest[16];
		memset(digest, 0, sizeof(digest));

		// send auth command
		send = "AUTH CRAM-MD5\r\n";
		SockWrite(send, send.GetLength());

		// get server's reply
		if(!ReadMultipleLineReply(line_array)){
			ret = "ReadMultipleLineReply error";
			return FALSE;
		}
		g_cstringarray2cstring(line_array, ret);
		if(line_array[line_array.GetSize()-1].Find("334") != 0){
			return FALSE;
		}

		// get token for making md5 authentification
		int p = line_array[line_array.GetSize()-1].Find(" ", 0);
		challenge = line_array[line_array.GetSize()-1].Mid(p+1);

		memset(buf, 0, sizeof(buf));
		if((len = from64tobits(buf, challenge, sizeof(buf)-1)) <= 0){
			ret = "from64tobits error";
			return FALSE;
		}
		buf[len] = '\0';

		hmac_md5((unsigned char *)password, strlen(password), 
			(unsigned char *)buf, strlen(buf), 
			(unsigned char *)digest, sizeof(digest));

		memset(buf, 0, sizeof(buf));
		sprintf(buf,
		"%s %02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x",
		user, digest[0], digest[1], digest[2], digest[3],
		digest[4], digest[5], digest[6], digest[7], digest[8],
		digest[9], digest[10], digest[11], digest[12], digest[13],
		digest[14], digest[15]);

		memset(b64buf, 0, sizeof(b64buf));
		to64frombits((unsigned char *)b64buf, (const unsigned char *)buf, strlen(buf));
		send.Format("%s\r\n", b64buf);
		SockWrite(send, send.GetLength());
	// below is for plain authentification
	}else if(tmp.Find("PLAIN") != -1){
		sprintf(buf, "%s^%s^%s", user, user, password);
		len = strlen(buf);
		for(int c = len-1; c >= 0; c--){
			if (buf[c] == '^')
				buf[c] = '\0';
		}
		to64frombits((unsigned char *)b64buf, (const unsigned char *)buf, len);
		send.Format("AUTH PLAIN %s\r\n", b64buf);
		SockWrite(send, send.GetLength());
	}else{
		return FALSE;
	}

	// get reply from server
	if(!ReadMultipleLineReply(line_array)){
		ret = "ReadMultipleLineReply error";
		return FALSE;
	}
	g_cstringarray2cstring(line_array, ret);
	if(line_array[line_array.GetSize()-1].Find("235") != 0){
		return FALSE;
	}

	return TRUE;
}

BOOL CSmtp::Quit(CString &ret)
{
	CStringArray line_array;

	ret.Empty();

	// send quit command
	SockWrite("quit\r\n", strlen("quit\r\n"));

	// get reply from server
	if(!ReadMultipleLineReply(line_array)){
		ret = "ReadMultipleLineReply error";
		return FALSE;
	}
	g_cstringarray2cstring(line_array, ret);
	// check reply code
	if(line_array[line_array.GetSize()-1].Find("221") != 0){
		return FALSE;
	}

	return TRUE;
}

BOOL CSmtp::MailFrom(LPCTSTR buf, CString &ret)
{
	CString send;
	CStringArray line_array;

	ret.Empty();

	// send mail from command
	send.Format("mail from: <%s>\r\n", buf);
	SockWrite(send, send.GetLength());

	// get reply from server
	if(!ReadMultipleLineReply(line_array)){
		ret = "ReadMultipleLineReply error";
		return FALSE;
	}
	g_cstringarray2cstring(line_array, ret);
	//check reply code
	if(line_array[line_array.GetSize()-1].Find("250") != 0){
		return FALSE;
	}

	return TRUE;
}

BOOL CSmtp::RcptTo(CStringArray &address_array, CString &ret)
{
	CString send;
	CStringArray line_array;
	int max = address_array.GetSize();

	ret.Empty();

	for(int i=0; i<max; i++){
		// send rcpt to command
		send.Format("rcpt to: <%s>\r\n", address_array.GetAt(i));
		SockWrite(send, send.GetLength());

		// get reply from server
		if(!ReadMultipleLineReply(line_array)){
			ret = "ReadMultipleLineReply error";
			return FALSE;
		}
		g_cstringarray2cstring(line_array, ret);
		// check reply code
		if(line_array[line_array.GetSize()-1].Find("250") != 0){
			return FALSE;
		}
	}
	return TRUE;
}

BOOL CSmtp::DataStart(CString &ret)
{
	CStringArray line_array;

	// send data command
	SockWrite("data\r\n", strlen("data\r\n"));

	// get reply from server
	if(!ReadMultipleLineReply(line_array)){
		ret = "ReadMultipleLineReply error";
		return FALSE;
	}
	ret.Empty();
	g_cstringarray2cstring(line_array, ret);
	// check reply code
	if(line_array[line_array.GetSize()-1].Find("354") != 0 &&
		line_array[line_array.GetSize()-1].Find("250") != 0){
		return FALSE;
	}

	return TRUE;
}

BOOL CSmtp::DataEnd(CString &ret)
{
	CStringArray line_array;

	ret.Empty();

	// send data end mark "\r\n.\r\."
	SockWrite("\r\n.\r\n", strlen("\r\n.\r\n"));

	// get reply from server
	if(!ReadMultipleLineReply(line_array)){
		ret = "ReadMultipleLineReply error";
		return FALSE;
	}
	g_cstringarray2cstring(line_array, ret);
	// check reply code
	if(line_array[line_array.GetSize()-1].Find("250") != 0){
		return FALSE;
	}

	return TRUE;
}

BOOL CSmtp::StartSession(LPCTSTR address, LPCTSTR port, CString &ret)
{
	CStringArray line_array;

	ret.Empty();

	// connect smtp server
	if(INVALID_SOCKET == Connect6(address, port)){
		ret.Format("cannot connect %s:%s", address, port);
		return FALSE;
	}

	// get reply from server
	if(!ReadMultipleLineReply(line_array)){
		ret = "ReadMultipleLineReply error";
		return FALSE;
	}
	g_cstringarray2cstring(line_array, ret);
	// check reply code
	if(line_array[line_array.GetSize()-1].Find("220") != 0){
		return FALSE;
	}

	return TRUE;
}

void CSmtp::EndSession()
{
	DisConnect();
}

// in some case, smtp server reply with multiple line
BOOL CSmtp::ReadMultipleLineReply(CStringArray &line_array)
{
	CString receive;

	line_array.RemoveAll();

	for(;;){
		if(ReadLine(receive) == -1){
			return FALSE;
		}
		if(receive[3] == ' '){
			line_array.Add(receive);
			return TRUE;
		}
		line_array.Add(receive);
	}
}

CString CSmtp::GetAuthResponse(CStringArray &line_array)
{
	CString tmp;

	for(int i=0; i<line_array.GetSize(); i++){
		tmp = line_array[i];
		tmp.MakeLower();
		if(tmp.Find("auth") != -1){
			return line_array[i];
		}
	}

	// if not find out auth response, return empty
	tmp.Empty();
	return tmp;
}
