/*
 * Copyright (C) 2002-2003 chik, hiranaka
 * For license terms, see the file COPYING in this directory.
 */

// MimeDecode.cpp: CMimeDecode NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Pochy.h"
#include "MimeDecode.h"
#include <afxtempl.h>	// CArrayev[gNXɕKv
#include "lib.h"


//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CMimeDecode::CMimeDecode()
{

}

CMimeDecode::~CMimeDecode()
{

}

// partŎw肳ꂽmultipartbodydstiCStringArrayj֏
void CMimeDecode::GetBody(int part, CStringArray &dst)
{
	ASSERT(part < HowManyPart());
	int start;
	int end;

	start = m_data.GetAt(part).end_header+2;
	end = m_data.GetAt(part).end;
	g_cstringarray_getpart(m_mail, dst, start, end);
}

CString CMimeDecode::GetContentType(int part)
{
	ASSERT(part < HowManyPart());
	return m_data[part].content_type;
}

int CMimeDecode::GetEncodingType(int part)
{
	ASSERT(part < HowManyPart());
	return m_data[part].encoding_type;
}

CString CMimeDecode::GetFileName(int part)
{
	ASSERT(part < HowManyPart());
	return m_data[part].name;
}

CString CMimeDecode::GetRawCT(int part)
{
	ASSERT(part < HowManyPart());
	return m_data[part].raw_content_type;
}

CString CMimeDecode::GetRawCD(int part)
{
	ASSERT(part < HowManyPart());
	return m_data[part].raw_content_disposition;
}

CString CMimeDecode::GetRawCTE(int part)
{
	ASSERT(part < HowManyPart());
	return m_data[part].raw_content_transfer_encoding;
}

CString CMimeDecode::GetMultipartType()
{
	CString buf;
	int start;
	int end;

	if(IsMultipart()){
		buf = m_hi.GetCT();
		start = buf.Find("/")+1;
		end = buf.Find(";", start);
		return buf.Mid(start, end-start);
	}

	buf.Empty();
	return buf;
}

int CMimeDecode::HowManyPart()
{
	return m_data.GetSize();
}

BOOL CMimeDecode::IsMultipart()
{
	return m_hi.IsMultipart();
}

BOOL CMimeDecode::GetHeaderEndPoint(CStringArray &mail, int &p)
{
	int n;
	int max = mail.GetSize();

	for(n=0; n<max; n++){
		mail.GetAt(n);
		if(mail.GetAt(n) == "\x0D\x0A"){
			p = n-1;
			break;
		}
	}
	return TRUE;
}

BOOL CMimeDecode::DoIt2(CString mail)
{
	Initialize();

	int p = 0; // headeȑI
	g_string2cstringarray(mail, m_mail, "\r\n", TRUE);
	GetHeaderEndPoint(m_mail, p);
	if(p == -1){
		AfxMessageBox("[Ă܂iwb_܂j");
		return FALSE;
	}

	CStringArray header;
	g_cstringarray_getpart(m_mail, header, 0, p);
	m_hi.DoIt(header);

	MULTIPART_STRUCT data;
	int n;

	if(IsMultipart()){
		if(!AnalyzeMultiPart(0, m_hi.GetBoundary())){
			AfxMessageBox("MIME̍\ςł");
			return FALSE;
		}
		int max=m_data.GetSize();
		for(n=0; n<max; n++){
			if(!m_data.GetAt(n).boundary.IsEmpty())
				if(!AnalyzeMultiPart(m_data.GetAt(n).start, m_data.GetAt(n).boundary)){
					AfxMessageBox("MIME̍\ςł");
					return FALSE;
				}
		}

		// multipartq\̐e폜
		for(n=0; n<m_data.GetSize(); n++){
			if(!m_data.GetAt(n).boundary.IsEmpty()){
				m_data.RemoveAt(n);
			}
		}
	}else{
		data.start = 0;
		GetHeaderEndPoint(m_mail, p);
		data.end_header = p;
		data.end = m_mail.GetSize()-1;
		data.name = m_hi.GetFilename();
		if(data.name.IsEmpty())
			data.name = m_hi.GetName();
		data.content_type = m_hi.GetCType();
		data.encoding_type = m_hi.GetEnc();
		m_data.Add(data);
	}
	return TRUE;
}
BOOL CMimeDecode::DoIt(CString path)
{
	Initialize();

	CString message;
	if(!g_is_there(path)){
		message.Format("%s ݂ȂߊJ܂", path);
		AfxMessageBox(message);
		message.Empty();
		return FALSE;
	}

	int p = 0; // headeȑI
	CStringArray header;
	g_file2cstringarray(path, m_mail);
	GetHeaderEndPoint(m_mail, p);
	if(p == -1){
		AfxMessageBox("[Ă܂iwb_܂j");
		return FALSE;
	}
	g_cstringarray_getpart(m_mail, header, 0, p);
	m_hi.DoIt(header);

	MULTIPART_STRUCT data;
	int n;

	if(IsMultipart()){
		if(!AnalyzeMultiPart(0, m_hi.GetBoundary())){
			AfxMessageBox("MIME̍\ςł");
			return FALSE;
		}
		int max = m_data.GetSize();
		for(n=0; n<max; n++){
			if(!m_data.GetAt(n).boundary.IsEmpty())
				if(!AnalyzeMultiPart(m_data.GetAt(n).start, m_data.GetAt(n).boundary)){
					AfxMessageBox("MIME̍\ςł");
					return FALSE;
				}
		}

		// multipartq\̐e폜
		for(n=0; n<m_data.GetSize(); n++){
			if(!m_data.GetAt(n).boundary.IsEmpty()){
				m_data.RemoveAt(n);
			}
		}
	}else{
		data.start = 0;
		GetHeaderEndPoint(m_mail, p);
		data.end_header = p;
		data.end = m_mail.GetSize()-1;
		data.name = m_hi.GetFilename();
		if(data.name.IsEmpty())
			data.name = m_hi.GetName();
		data.content_type = m_hi.GetCType();
		data.encoding_type = m_hi.GetEnc();
		data.raw_content_type = m_hi.GetCT();
		data.raw_content_transfer_encoding = m_hi.GetCTE();
		data.raw_content_disposition = m_hi.GetCD();
		m_data.Add(data);
	}
	return TRUE;
}

BOOL CMimeDecode::AnalyzeMultiPart(int start, LPCTSTR boundary)
{
	int n1;
	int n2;
	int p;
	int max;
	CUIntArray ia;
	CHeaderInfo hi;
	CStringArray part;
	CString sep;// = "--"+boundary+"\r\n";
	CString last;// = "--"+boundary+"--"+"\r\n";
	CStringArray pheader;
	MULTIPART_STRUCT data;

	sep.Format("--%s\r\n", boundary);
	last.Format("--%s--\r\n", boundary);

	max = m_mail.GetSize();
	for(n1=start; n1<max; n1++){
		if(m_mail.GetAt(n1) == sep){
			ia.Add(n1);
			continue;
		}
		if(m_mail.GetAt(n1) == last){
			ia.Add(n1);
			break;
		}
	}

	if(ia.GetSize() < 2)
		return FALSE;

	max = ia.GetSize();
	for(n2=0; n2+1<max; n2++){
		g_cstringarray_getpart(m_mail, part, ia.GetAt(n2)+1, ia.GetAt(n2+1)-1);
		GetHeaderEndPoint(part, p);
		g_cstringarray_getpart(m_mail, pheader, ia.GetAt(n2)+1, ia.GetAt(n2)+1+p);
		hi.DoIt(pheader);

		data.start = ia.GetAt(n2)+1;
		data.end_header = data.start+p;
		data.end = ia.GetAt(n2+1)-1;
		data.boundary = hi.GetBoundary();
		data.content_type = hi.GetCType();
		data.encoding_type = hi.GetEnc();
		data.name = hi.GetFilename();
		if(data.name.IsEmpty())
			data.name = hi.GetName();
		data.raw_content_type = hi.GetCT();
		data.raw_content_transfer_encoding = hi.GetCTE();
		data.raw_content_disposition = hi.GetCD();
		m_data.Add(data);
	}
	return TRUE;
}

void CMimeDecode::Initialize()
{
	// ϐ̏
	m_data.RemoveAll();
	m_mail.RemoveAll();
}

BOOL CMimeDecode::IsPgpMime()
{
	return g_string_compare_no_case(m_hi.GetProtocol(), "application/pgp-encrypted");
}

CString CMimeDecode::GetCharSet()
{
	return m_hi.GetCharset();
}
