/*
 * Copyright (C) 2002-2003 chik & s.hiranaka
 * For license terms, see the file COPYING in this directory.
 */

#include "stdafx.h"
#include "Pochy.h"
#include "MainFrm.h"
#include "DraftFrame.h"
#include "Smtp.h"
#include "CodeConvert.h"
#include "sendmail.h"
#include "direct.h"
#include "PassPhraseDlg.h"
#include "lib.h"
#include "DraftSendDlg.h"
#include "md5ify.h"

#define send_command(mes) \
		send(Smtp.m_sock, command, command.GetLength(), 0);\
		if(Smtp.SockRead(buf) == -1)\
			throw mes;\
		if(buf.Find("250") != 0 && buf.Find("354") != 0 && buf.Find("221") != 0)\
			throw buf.GetBuffer(0);\
		df->m_send_dlg->m_status.SetWindowText(buf);\
		buf.Empty()

UINT SendMail(LPVOID pParam)
{
	CSmtp Smtp;
	CSock PopSocket;
	CString smtp_ip;
  	CString smtp_addr;
	CString smtp_port;
	CString smtp_auth_id;
	CString smtp_auth_pass;
	CString buf;
	CString command;
	int left;
	int right;
	BOOL pop_before_smtp;

	CDraftFrame *df = (CDraftFrame *)pParam;
	CPochyApp* app = (CPochyApp*)AfxGetApp();
	CMainFrame *mf = (CMainFrame *)app->m_pMainWnd;

	mf->StartTaskTrayAnimation();

	// prepare for ini file
	CString path = app->m_app_path + "\\" + df->m_account + "\\account.ini";

	// confirmation of header
	if(df->m_me.GetTo().IsEmpty()){
		df->MessageBox("To: tB[hł", df->m_account+" - header error");
		df->m_send_dlg->EndDialog(0);
		df->m_send_dlg = NULL;
		df->EnableWindow(TRUE);
		mf->StopTaskTrayAnimation();
		return FALSE;
	}
	if(df->m_me.GetFrom().IsEmpty()){
		df->MessageBox("From: tB[hł", df->m_account+" - header error");
		df->m_send_dlg->EndDialog(0);
		df->m_send_dlg = NULL;
		df->EnableWindow(TRUE);
		mf->StartTaskTrayAnimation();
		return FALSE;
	}

	// pop before smtp
	pop_before_smtp = GetPrivateProfileInt("smtp", "pop_before_smtp", 0, path);
	if(pop_before_smtp){
		try{
			CString message;
			CString pop_addr;
			GetPrivateProfileString("pop", "server_addr", "", pop_addr.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
			CString pop_port;
			GetPrivateProfileString("pop", "port", "", pop_port.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

			if(INVALID_SOCKET == PopSocket.Connect6(pop_addr.GetBuffer(0), pop_port.GetBuffer(0))){
				throw "cannot establish connection";
			}
			PopSocket.SockRead(buf);
			df->m_send_dlg->m_status.SetWindowText(buf);
			buf.Empty();

			// get user name from ini file.
			CString pop_user;
			GetPrivateProfileString("pop", "user", "", pop_user.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
			pop_user.ReleaseBuffer();

			// get password from ini file.
			CString pop_pass;
			GetPrivateProfileString("pop", "pass", "", pop_pass.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
			pop_pass.ReleaseBuffer();
			if(pop_pass.IsEmpty() && !mf->m_pAcntV->GetAccountPopPass(df->m_account).IsEmpty()){
				pop_pass = mf->m_pAcntV->GetAccountPopPass(df->m_account);
			}else if(pop_pass.IsEmpty() && mf->m_pAcntV->GetAccountPopPass(df->m_account).IsEmpty()){
				// if getting no password from ini file, then show dialog for input password.
				CPassPhraseDlg passDlg(df);
				if(IDOK == passDlg.DoModal()){
					pop_pass = passDlg.GetPass();
					mf->m_pAcntV->SetAccountPopPass(df->m_account, pop_pass);
				}else{
					throw "";
				}
			}

			CString md5_in;
			CString md5_out;
			CString apop;
			if(GetPrivateProfileInt("pop", "apop", 0, path)){
				// if using apop, below is done.
				md5_in += pop_pass;
				md5_out = MD5Digest((unsigned char *)md5_in.GetBuffer(0));
				apop = "apop "+pop_user+" "+md5_out+"\r\n";
				send(PopSocket.m_sock, apop.GetBuffer(0), apop.GetLength(), 0);
				if(PopSocket.SockRead(buf) == -1)
					throw "error is occured in pass session";
				if(buf.Find("-ERR") == 0 || buf.Find("-err") == 0){
					message.Format("%s", buf.GetBuffer(0));
					pop_pass.Empty();
					mf->m_pAcntV->SetAccountPopPass(df->m_account, pop_pass);
					throw message.GetBuffer(0);
				}
				buf = apop;
				df->m_send_dlg->m_status.SetWindowText(buf);
				buf.Empty();
			}else{
				// below is normal authentification using user and pass command.
				// user
				pop_user = "user " + pop_user + "\r\n";
				send(PopSocket.m_sock, pop_user.GetBuffer(10), pop_user.GetLength(), 0);
				if(PopSocket.SockRead(buf) == -1)
					throw "error is occured in user session";
				if(buf.Find("-ERR") == 0 || buf.Find("-err") == 0){
					message.Format("%s", buf.GetBuffer(0));
					throw message.GetBuffer(0);
				}
				df->m_send_dlg->m_status.SetWindowText(buf);
				buf.Empty();

				// pass
				pop_pass = "pass "+pop_pass+"\r\n";
				send(PopSocket.m_sock, pop_pass.GetBuffer(0), pop_pass.GetLength(), 0);
				if(PopSocket.SockRead(buf) == -1)
					throw "error is occured in pass session";
				if(buf.Find("-ERR") == 0 || buf.Find("-err") == 0){
					message.Format("%s", buf.GetBuffer(0));
					pop_pass.Empty();
					mf->m_pAcntV->SetAccountPopPass(df->m_account, pop_pass);
					throw message.GetBuffer(0);
				}
				buf = "pass ********";
				df->m_send_dlg->m_status.SetWindowText(buf);
				buf.Empty();
			}

			// quit
			send(PopSocket.m_sock, "quit\r\n", strlen("quit\r\n"), 0);
			PopSocket.SockRead(buf);
			buf.Empty();
			PopSocket.DisConnect();
		}
		catch(char *errorstr){
			send(PopSocket.m_sock, "quit\r\n", strlen("quit\r\n"), 0);
			// close socket
			PopSocket.DisConnect();
			if(strlen(errorstr)){
				df->MessageBox(errorstr, df->m_account+" - pop before smtp error");
			}
			df->m_send_dlg->EndDialog(0);
			df->m_send_dlg = NULL;
			df->EnableWindow(TRUE);
			mf->StopTaskTrayAnimation();
			return FALSE;
		}
	}

	try{
		// prepare for smtp
		GetPrivateProfileString("smtp", "server_addr", "", smtp_addr.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
		GetPrivateProfileString("smtp", "port", "", smtp_port.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);

		if(INVALID_SOCKET == Smtp.Connect6(smtp_addr.GetBuffer(0), smtp_port.GetBuffer(0))){
			throw "cannot establish connection";
		}
//============== start smtp session ============
		CString date;
		CTime t = CTime::GetCurrentTime();
		date.Format("%02d/%02d/%d %02d:%02d:%02d",t.GetDay(),t.GetMonth(),t.GetYear(),t.GetHour(),t.GetMinute(),t.GetSecond());
		g_log("log-sendmail", "------- "+ date +" -------\r\n");
		if(Smtp.SockRead(buf) == -1)
			throw "in connection";
		g_log("log-sendmail", buf);
		df->m_send_dlg->m_status.SetWindowText(buf);
		buf.Empty();
	//-------------- helo ------------------
		if(GetPrivateProfileInt("smtp", "auth", 0, path)){
			GetPrivateProfileString("smtp", "auth_id", "", smtp_auth_id.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
			smtp_auth_id.ReleaseBuffer();
			GetPrivateProfileString("smtp", "auth_pass", "", smtp_auth_pass.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
			smtp_auth_pass.ReleaseBuffer();
			if(!Smtp.Ehlo(smtp_auth_id, smtp_auth_pass)){
				throw "smtp auth error";
			}
		}else{
			Smtp.Helo();
		}
	//-------------- mail from -------------
		command = "mail from: <"+g_cstr_chop2(g_ma(df->m_me.GetFrom()))+">\r\n";
		send_command("at MAIL FROM command");
	//-------------- rcpt ------------------
		left = 0;
		CString to = df->m_me.GetTo();
		if(!df->m_me.GetCc().IsEmpty())
			to += ", "+df->m_me.GetCc();
		if(!df->m_me.GetBcc().IsEmpty())
			to += ", "+df->m_me.GetBcc();
		g_strip_part(to, "\""); // ""̕폜iRgɁA,Ƃ΂̂Łj
		right = to.Find(",");
		while(right != -1){
			command = "rcpt to: <"+g_cstr_chop2(g_ma(to.Mid(left, right-left)))+">\r\n";
			send_command("at RCPT TO command");
			left = right+1;
			right = to.Find(",", left);
		}
		command = "rcpt to: <"+g_cstr_chop2(g_ma(to.Mid(left,to.GetLength()-left)))+">\r\n";
		send_command("at RCPT TO command");

		//-------------- body ------------------
		CString path = app->m_app_path + "\\" + df->m_account + "\\outbox";

		// send body
		command = "data\r\n";
		send_command("at BODY command");
		CString mail = df->m_me.GetMail(ME_GET_SEND);
		mail.Replace("\r\n.", "\r\n..");

		int whole_len = mail.GetLength();
		int current_len;
		int part_len;
		part_len = current_len = mail.GetLength()/8;

		df->m_send_dlg->m_progress.SetRange32(0, whole_len);
		df->m_send_dlg->m_progress.SetPos(0);
		while(current_len < whole_len){
			buf = mail.Left(part_len);
			mail = mail.Mid(part_len);
			send(Smtp.m_sock, buf, buf.GetLength(), 0);
			buf.Empty();
			df->m_send_dlg->m_progress.SetPos(current_len);
			current_len += part_len;
		}
		send(Smtp.m_sock, mail, mail.GetLength(), 0);
		df->m_send_dlg->m_progress.SetPos(whole_len);

		send(Smtp.m_sock, "\r\n.\r\n", strlen("\r\n.\r\n"), 0);

		CSummaryView *sv = mf->m_pListV;
		sv->SaveMail(path, df->m_me.GetMail(ME_GET_OUTBOX), SMRY_STATUS_NONE, SMRY_COLUMN_TO);

		if(Smtp.SockRead(buf) == -1)
			throw "at BODY command";
		g_log("log-sendmail", buf);
		df->m_send_dlg->m_status.SetWindowText(buf);
		buf.Empty();

	//-------------- quit ----------------
		command = "quit\r\n";
		send_command("at QUIT command");
		// close socket
		Smtp.DisConnect();
	}
	catch(char* errorstr){
		send(Smtp.m_sock, "quit\r\n", 6, 0);
		// close socket
		Smtp.DisConnect();
		df->MessageBox(errorstr, df->m_account+" - smtp error");
		df->EnableWindow(TRUE);
		df->m_send_dlg->m_status.SetWindowText("");
		df->m_send_dlg->EndDialog(0);
		df->m_send_dlg = NULL;
		mf->StopTaskTrayAnimation();
		return FALSE;
	}

	df->m_send_dlg->m_status.SetWindowText("");
	df->EnableWindow(TRUE);

	for(int i=0; i<app->m_draft_array.GetSize(); i++){
		if(df == app->m_draft_array[i])
			app->m_draft_array.RemoveAt(i);
	}

	df->m_send_dlg->EndDialog(0);
	df->m_send_dlg = NULL;
	PostMessage(df->m_hWnd, WM_COMMAND, WM_END, NULL);
	mf->StopTaskTrayAnimation();
	return TRUE;
}
