// Memory DC class - Copyright(C) 2003 minamina
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <assert.h>
#include "MemoryDC.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CMemoryDC::CMemoryDC() : m_hDC(NULL), m_hBaseDC(NULL), m_hBitmap(NULL), m_hOldBitmap(NULL),
	m_lpvBits(NULL), m_bCreateDIB(false)
{
}

CMemoryDC::~CMemoryDC()
{
	DeleteAll();
}

void CMemoryDC::DeleteAll()
{
	if (m_hDC != NULL)
	{
		if (m_hOldBitmap != NULL)
		{
			::SelectObject(m_hDC, m_hOldBitmap);
			m_hOldBitmap = NULL;
		}

		::DeleteDC(m_hDC);
		m_hDC = NULL;
	}

	if (m_hBitmap != NULL)
	{
		::DeleteObject(m_hBitmap);
		m_hBitmap = NULL;
	}

	if (!m_bCreateDIB)
	{
		if (m_lpvBits != NULL)
		{
			delete[] m_lpvBits;
			m_lpvBits = NULL;
		}
	}
	m_bCreateDIB = false;
	m_hBaseDC = NULL;
}

bool CMemoryDC::IsValid()
{
	return (m_hDC != NULL && m_hBitmap != NULL);
}

bool CMemoryDC::Create(HDC hDC, const int nWidth, const int nHeight)
{
	assert(hDC != NULL);
	assert(nWidth > 0 && nHeight > 0);

	DeleteAll();

	bool bResult = false;

	m_hDC = ::CreateCompatibleDC(hDC);
	m_hBaseDC = hDC;
	if (m_hDC != NULL)
	{
		m_hBitmap = ::CreateCompatibleBitmap(hDC, nWidth, nHeight);
		if (m_hBitmap != NULL)
		{
			m_hOldBitmap = static_cast<HBITMAP>(::SelectObject(m_hDC, m_hBitmap));
			if (m_hOldBitmap != NULL)
			{
				if (::GetObject(m_hBitmap, sizeof(BITMAP), &m_bitmap) > 0)
				{
					bResult = true;
				}
			}
		}
	}

	if (bResult == false)
	{
		DeleteAll();
	}

	return bResult;
}

bool CMemoryDC::CreateFromBitmap(HDC hDC, HINSTANCE hInstance, WORD wResourceID)
{
	assert(hDC != NULL);
	assert(hInstance != NULL);

	DeleteAll();

	bool bResult = false;

	m_hDC = ::CreateCompatibleDC(hDC);
	m_hBaseDC = hDC;
	if (m_hDC != NULL)
	{
		m_hBitmap = (HBITMAP)::LoadImage(hInstance, MAKEINTRESOURCE(wResourceID), IMAGE_BITMAP, 0, 0, LR_DEFAULTCOLOR);
		if (m_hBitmap != NULL)
		{
			m_hOldBitmap = static_cast<HBITMAP>(::SelectObject(m_hDC, m_hBitmap));
			if (m_hOldBitmap != NULL)
			{
				if (::GetObject(m_hBitmap, sizeof(BITMAP), &m_bitmap) > 0)
				{
					bResult = true;
				}
			}
		}
	}

	if (bResult == false)
	{
		DeleteAll();
	}

	return bResult;
}

bool CMemoryDC::CreateFromBitmap(HDC hDC, LPCTSTR lpszFilename)
{
	assert(hDC != NULL);
	assert(lpszFilename != NULL);

	DeleteAll();

	bool bResult = false;

	m_hDC = ::CreateCompatibleDC(hDC);
	m_hBaseDC = hDC;
	if (m_hDC != NULL)
	{
		m_hBitmap = (HBITMAP)::LoadImage(NULL, lpszFilename, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE);
		if (m_hBitmap != NULL)
		{
			m_hOldBitmap = static_cast<HBITMAP>(::SelectObject(m_hDC, m_hBitmap));
			if (m_hOldBitmap != NULL)
			{
				if (::GetObject(m_hBitmap, sizeof(BITMAP), &m_bitmap) > 0)
				{
					bResult = true;
				}
			}
		}
	}

	if (bResult == false)
	{
		DeleteAll();
	}

	return bResult;
}

bool CMemoryDC::CreateDIB(HDC hDC, const int nWidth, const int nHeight, WORD wBitCount)
{
	assert(hDC != NULL);
	assert(nWidth > 0 && nHeight > 0);
	assert(wBitCount > 8); // 16, 24, 32 ̂

	DeleteAll();

	bool bResult = false;

	m_hDC = ::CreateCompatibleDC(hDC);
	m_hBaseDC = hDC;
	if (m_hDC != NULL)
	{
		BITMAPINFO bitmapInfo;
		::ZeroMemory(&bitmapInfo, sizeof(BITMAPINFO));
		bitmapInfo.bmiHeader.biSize = sizeof(BITMAPINFO);
		bitmapInfo.bmiHeader.biWidth = nWidth;
		bitmapInfo.bmiHeader.biHeight = nHeight;
		bitmapInfo.bmiHeader.biBitCount = wBitCount;
		bitmapInfo.bmiHeader.biPlanes = 1;
		bitmapInfo.bmiHeader.biCompression = BI_RGB;
		bitmapInfo.bmiHeader.biSizeImage = 0;

		m_hBitmap = ::CreateDIBSection(hDC, &bitmapInfo, DIB_RGB_COLORS, &m_lpvBits, NULL, 0);
		if (m_hBitmap != NULL)
		{
			m_hOldBitmap = static_cast<HBITMAP>(::SelectObject(m_hDC, m_hBitmap));
			if (m_hOldBitmap != NULL)
			{
				if (::GetObject(m_hBitmap, sizeof(BITMAP), &m_bitmap) > 0)
				{
					m_bCreateDIB = true;
					bResult = true;
				}
			}
		}
	}

	if (bResult == false)
	{
		DeleteAll();
	}

	return bResult;
}

HDC CMemoryDC::GetDC()
{
	assert(IsValid());
	return m_hDC;
}

// }XN Memory DC Ԃ
// new  CMemoryDC Ԃ邽ߌĂяo delete Kv
// g DIB łKv
// Ԃ}XN DIB ł
// 16 bit  32 bit łKv
// G[Ȃ NULL Ԃ
CMemoryDC* CMemoryDC::CreateMaskDC(COLORREF maskColor)
{
	assert(IsValid());
	assert(m_bCreateDIB);

	WORD wBitCount = m_bitmap.bmBitsPixel;
	assert(wBitCount == 16 || wBitCount == 32);

	const int nWidth = m_bitmap.bmWidth;
	const int nHeight = m_bitmap.bmHeight;

	CMemoryDC* pMaskDC = new CMemoryDC;
	if (pMaskDC->CreateDIB(m_hBaseDC, nWidth, nHeight, wBitCount))
	{
		int nX, nY;
		if (wBitCount == 32)
		{
			DWORD dwMaskColor = GetDIBColor(maskColor);
			DWORD dwWhiteColor = GetDIBColor(RGB(255, 255, 255));
			DWORD dwBlackColor = GetDIBColor(RGB(0, 0, 0));

			DWORD* pSource = reinterpret_cast<DWORD*>(m_lpvBits);
			DWORD* pDest = reinterpret_cast<DWORD*>(pMaskDC->m_lpvBits);
			for (nY = 0; nY < nHeight; nY++)
			{
				for (nX = 0; nX < nWidth; nX++)
				{
					if (pSource[nX] == dwMaskColor)
					{
						pDest[nX] = dwBlackColor;
					}
					else
					{
						pDest[nX] = dwWhiteColor;
					}
				}
				pSource += nWidth;
				pDest += nWidth;
			}
		}
		else
		{
			WORD wMaskColor = static_cast<WORD>(GetDIBColor(maskColor));
			WORD wWhiteColor = static_cast<WORD>(GetDIBColor(RGB(255, 255, 255)));
			WORD wBlackColor = static_cast<WORD>(GetDIBColor(RGB(0, 0, 0)));

			int nPitch = nWidth + (nWidth % 2);
			WORD* pSource = reinterpret_cast<WORD*>(m_lpvBits);
			WORD* pDest = reinterpret_cast<WORD*>(pMaskDC->m_lpvBits);
			for (nY = 0; nY < nHeight; nY++)
			{
				for (nX = 0; nX < nWidth; nX++)
				{
					if (pSource[nX] == wMaskColor)
					{
						pDest[nX] = wBlackColor;
					}
					else
					{
						pDest[nX] = wWhiteColor;
					}
				}
				pSource += nPitch;
				pDest += nPitch;
			}
		}
	}

	if (pMaskDC->IsValid())
	{
		return pMaskDC;
	}
	else
	{
		delete pMaskDC;
		return NULL;
	}
}

// ۂɕ`悵ĐF𓾂
DWORD CMemoryDC::GetDIBColor(COLORREF color)
{
	assert(IsValid());
	assert(m_bCreateDIB);

	DWORD dwColor = color;
	CMemoryDC tempDC;
	if (tempDC.CreateDIB(m_hBaseDC, 1, 1, m_bitmap.bmBitsPixel))
	{
		::SetPixel(tempDC.GetDC(), 0, 0, color);
		dwColor = reinterpret_cast<DWORD*>(tempDC.m_lpvBits)[0];
	}
	return dwColor;
}

BITMAP& CMemoryDC::GetBitmap()
{
	return m_bitmap;
}
