/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.internal;

import java.util.AbstractList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayQueue<T>
extends AbstractList<T> {
    private int capacity;
    private T[] queue;
    private int head;
    private int tail;

    public ArrayQueue(int n) {
        this.capacity = n + 1;
        this.queue = new Object[n + 1];
        this.head = 0;
        this.tail = 0;
    }

    public void resize(int n) {
        int n2 = this.size();
        if (n < n2) {
            throw new IndexOutOfBoundsException("Resizing would lose data");
        }
        if (++n == this.capacity) {
            return;
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = this.get(i);
        }
        this.capacity = n;
        this.queue = objectArray;
        this.head = 0;
        this.tail = n2;
    }

    @Override
    public boolean add(T t) {
        this.queue[this.tail] = t;
        int n = (this.tail + 1) % this.capacity;
        if (n == this.head) {
            throw new IndexOutOfBoundsException("Queue full");
        }
        this.tail = n;
        return true;
    }

    @Override
    public T remove(int n) {
        if (n != 0) {
            throw new IllegalArgumentException("Can only remove head of queue");
        }
        if (this.head == this.tail) {
            throw new IndexOutOfBoundsException("Queue empty");
        }
        T t = this.queue[this.head];
        this.queue[this.head] = null;
        this.head = (this.head + 1) % this.capacity;
        return t;
    }

    @Override
    public T get(int n) {
        int n2 = this.size();
        if (n < 0 || n >= n2) {
            String string = "Index " + n + ", queue size " + n2;
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = (this.head + n) % this.capacity;
        return this.queue[n3];
    }

    @Override
    public int size() {
        int n = this.tail - this.head;
        if (n < 0) {
            n += this.capacity;
        }
        return n;
    }
}

