package jp.oarts.pirka.test.view;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

import javax.imageio.ImageIO;

import jp.oarts.pirka.core.ctrl.SelectList;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.kernel.PirkaImage;
import jp.oarts.pirka.core.win.PirkaWindow;

public class CtrlTest05 extends PirkaWindow {

	public CtrlTest05() {
		FieldMap field = getFieldMap();

		SelectList selectList = new SelectList();
		selectList.add("yahoo", "yahoo");
		selectList.add("oriental arts", "oarts");
		selectList.add("eXgj[֖߂", "menue");
		field.setSelectList("select", selectList);
	}

	public void selectButton() {
		FieldMap field = getFieldMap();

		String[] selectedList = field.getValueStrings("mselect");
		StringBuilder sb = new StringBuilder();
		if (selectedList.length > 0) {
			for (String sel : selectedList) {
				if (sb.length() > 0) {
					sb.append(", ");
				}
				sb.append(sel);
			}
			sb.append("I܂");
		} else {
			sb.append("ȂɂIĂ܂");
		}
		field.setValue("selectMsg", sb.toString());

	}

	public void select2Button() {
		FieldMap field = getFieldMap();

		List<String> selectedList = new ArrayList<String>();
		selectedList.add("a002");
		selectedList.add("a004");
		field.setValue("mselect", (String[]) selectedList.toArray(new String[0]));
	}

	public void changeButton() {
		FieldMap field = getFieldMap();

		String sel = (String) field.getValueString("select");
		if ("yahoo".equalsIgnoreCase(sel)) {
			field.setOption("jump", "href", "http://yahoo.co.jp");
			field.setValue("title", "yahoo!!");
		} else if ("oarts".equalsIgnoreCase(sel)) {
			field.setOption("jump", "href", "http://www.oarts.jp");
			field.setValue("title", "IG^A[cz[y[W");
		} else {
			field.setOption("jump", "href", "");
			field.setValue("title", "eXgj[֖߂");
		}
	}

	public PirkaWindow jump() {
		return null;
	}

	public PirkaWindow returnButton() {
		return null;
	}

}
