import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.res.PirkaFileDownloaderFromBytes;
import jp.oarts.pirka.core.util.check.PirkaChecker;
import jp.oarts.pirka.core.util.check.PirkaCheckerLength;
import jp.oarts.pirka.core.util.check.PirkaCheckerString;
import jp.oarts.pirka.core.util.check.PirkaCheckerStringChars;
import jp.oarts.pirka.core.win.PirkaWindow;




/**
 * IndexNX
 *  @author
 */
public class Index extends  PirkaWindow {


	/**
	 * RXgN^
	 * 
	 */
	public Index() {

		///////////////////////////////////////////////////
		//  ̓`FbN
		///////////////////////////////////////////////////
		FieldMap field = getFieldMap();

		//@̓`FbNȂ\bh
		field.setAutoCheck("returnBtn", false);

		//@G[ɍڂƃG[̕\郁\bh
		field.setOfficialFieldName("userName" , "userName");
		field.setOfficialFieldName("userID" , "userID");
		field.setOfficialFieldName("address" , "address");
		field.setOfficialFieldName("tel" , "tel");



		//@̓`FbN̐錾
		addCheck("userName", PirkaChecker.required );
		addCheck("userName", new PirkaCheckerLength(PirkaCheckerLength.RANGE, 20, 20));
		addCheck("userName", new PirkaCheckerString(PirkaCheckerStringChars.WIDE , PirkaCheckerStringChars.HIGHT_ALPHABET , PirkaCheckerStringChars.NUM , PirkaCheckerStringChars.HALF_KANA ));
		addCheck("userID", PirkaChecker.required );
		addCheck("userID", new PirkaCheckerLength(PirkaCheckerLength.RANGE, 20, 20));
		addCheck("userID", new PirkaCheckerString(PirkaCheckerStringChars.WIDE , PirkaCheckerStringChars.HIGHT_ALPHABET , PirkaCheckerStringChars.NUM , PirkaCheckerStringChars.HALF_KANA ));
		addCheck("address", PirkaChecker.required );
		addCheck("address", new PirkaCheckerLength(PirkaCheckerLength.RANGE, 20, 20));
		addCheck("address", new PirkaCheckerString(PirkaCheckerStringChars.WIDE , PirkaCheckerStringChars.HIGHT_ALPHABET , PirkaCheckerStringChars.NUM , PirkaCheckerStringChars.HALF_KANA ));
		addCheck("tel", PirkaChecker.required );
		addCheck("tel", new PirkaCheckerLength(PirkaCheckerLength.RANGE, 20, 20));
		addCheck("tel", new PirkaCheckerString(PirkaCheckerStringChars.WIDE , PirkaCheckerStringChars.HIGHT_ALPHABET , PirkaCheckerStringChars.NUM , PirkaCheckerStringChars.HALF_KANA ));

		//@G[̏ꍇANV\bhĂ΂Ȃ
		addErrorCheckReturner();

		//@G[ĂĂANV\bh͌Ăяo
		// addErrorChaeckBreak();



	}




	/**
	 * `O
	 */
	public void preDraw(){


		///////////////////////////////////////////////////
		//  `eݒ肷
		///////////////////////////////////////////////////

		FieldMap field = getFieldMap();

		field.setValue("userName", "");
		field.setValue("userID", "");
		field.setValue("address", "");
		field.setValue("tel", "");




	}





	/**
	 * doitBtn
	 * @return ʃNX
	 */
	public PirkaWindow doitBtn(){
		System.out.println("---------doitBtn");


	



		///////////////////////////////////////////////////
		//  ͒l擾B
		///////////////////////////////////////////////////
		FieldMap field = getFieldMap();

		String userName = (String)field.getValueString("userName");
		String userID = (String)field.getValueString("userID");
		String address = (String)field.getValueString("address");
		String tel = (String)field.getValueString("tel");



		return this;
	}



	/**
	 * returnBtn
	 * @return ʃNX
	 */
	public PirkaWindow returnBtn(){
		System.out.println("---------returnBtn");



		return this;
	}




}


