package jp.oarts.pirka.test.view;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.kernel.PirkaImage;
import jp.oarts.pirka.core.win.PirkaWindow;

public class CtrlTest07 extends PirkaWindow {

	public void sendButton() {
		try {
			FieldMap field = getFieldMap();

			field.setValue("imageSwitch", false);
			field.setValue("textSwitch", false);

			// t@CAbv[h
			do {
				String fileName = (String) field.getValueString("inputFile");
				if (fileName != null && fileName.length() > 0) {

					int index = fileName.lastIndexOf('.');
					if (index <= 0 || index >= (fileName.length() - 1)) {
						field.setError("inputFile", true);
						addError("C[Wt@Cw肵Ă");
						break;
					}

					InputStream is = field.getInputStream("inputFile");
					byte[] buffer = getByte(is);

					String suffix = fileName.substring(index + 1);
					if ("gif".equalsIgnoreCase(suffix)) {
						field.setValue("imageSwitch", true);
						field.setImage("img", new TestImage(buffer, PirkaImage.MIME_TYPE_GIF));
					} else if ("jpg".equalsIgnoreCase(suffix) || "jpeg".equalsIgnoreCase(suffix)) {
						field.setValue("imageSwitch", true);
						field.setImage("img", new TestImage(buffer, PirkaImage.MIME_TYPE_JPEG));
					} else if ("png".equalsIgnoreCase(suffix) || "jpeg".equalsIgnoreCase(suffix)) {
						field.setValue("imageSwitch", true);
						field.setImage("img", new TestImage(buffer, PirkaImage.MIME_TYPE_PNG));
					} else {
						field.setError("inputFile", true);
						addError("T|[gȂC[Wł");
						break;
					}
				}
			} while (false);

			// t@CAbv[h
			do {
				String fileName = (String) field.getValueString("inputFile2");
				if (fileName != null && fileName.length() > 0) {

					int index = fileName.lastIndexOf('.');
					if (index <= 0 || index >= (fileName.length() - 1)) {
						field.setError("inputFile2", true);
						addError("eLXgt@Cw肵Ă");
						break;
					}

					String suffix = fileName.substring(index + 1);
					if (!"txt".equalsIgnoreCase(suffix)) {
						field.setError("inputFile2", true);
						addError("eLXgt@Cw肵Ă");
						break;
					}

					InputStream is = field.getInputStream("inputFile2");
					byte[] buffer = getByte(is);

					field.setValue("textSwitch", true);
					field.setValue("text", new String(buffer, "ms932"));
				}
			} while (false);

		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public PirkaWindow returnButton() {
		return null;
	}

	private byte[] getByte(InputStream is) {
		if (is == null) {
			return new byte[0];
		}

		byte[] buffer = new byte[2048];
		ByteArrayOutputStream baos = null;

		try {
			try {
				baos = new ByteArrayOutputStream();

				while (true) {
					int len = is.read(buffer);
					if (len <= 0) {
						break;
					}
					baos.write(buffer, 0, len);
				}
				baos.flush();
				return baos.toByteArray();
			} finally {
				if (baos != null) {
					baos.close();
				}
				if (is != null) {
					is.close();
				}
			}
		} catch (IOException e) {
			return new byte[0];
		}
	}

	class TestImage extends PirkaImage {

		String mime;

		byte[] buffer;

		public TestImage(byte[] buffer, String mime) {
			this.buffer = buffer;
			this.mime = mime;
		}

		@Override
		public byte[] getImage() throws IOException {
			return buffer;
		}

		@Override
		public String getMimeType() {
			return mime;
		}

	}
}
