package jp.oarts.example.addressbook3.view;

import org.seasar.dao.NotSingleRowUpdatedRuntimeException;

import jp.oarts.example.addressbook3.dao.AddressDao;
import jp.oarts.example.addressbook3.dto.Address;
import jp.oarts.example.addressbook3.tools.S2;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.check.PirkaChecker;
import jp.oarts.pirka.core.util.check.PirkaCheckerLength;
import jp.oarts.pirka.core.util.check.PirkaCheckerString;
import jp.oarts.pirka.core.util.check.PirkaCheckerStringChars;
import jp.oarts.pirka.core.win.PirkaWindow;

/**
 * AhXҏW
 */
public class NewAddressBook extends PirkaWindow {

	private static final String ZENKAKU_KANA = 
		"ĂƂȂɂʂ˂̂͂Ђӂւق܂݂ނ߂" +
		"񂪂Âłǂ΂тԂׂڂς҂Ղ؂" +
		"[|B";
	private static final String PHONE_STRING = "0123456789-";
	private Address address;
	
	/**
	 * RXgN^
	 */
	public NewAddressBook(Address address) {
		setCheck();
		if (address != null) {
			this.address = address;
			setBean(address);
		}
	}

	/**
	 * `FbNݒ肷B
	 * @param field
	 */
	private void setCheck() {
		FieldMap field = getFieldMap();
		field.setAutoCheck("cancel", false);

		field.setOfficialFieldName("lastNameFurigana", "ӂ肪ȁij");
		field.setOfficialFieldName("firstNameFurigana", "ӂ肪ȁij");
		field.setOfficialFieldName("lastName", "ij");
		field.setOfficialFieldName("firstName", "ij");
		field.setOfficialFieldName("mail", "[AhX");
		field.setOfficialFieldName("phone", "Гdbԍ");
		field.setOfficialFieldName("mobilePhone", "gѓdbԍ");
		addCheck("lastNameFurigana", "K{ڂłB", PirkaChecker.required);
		addCheck("lastNameFurigana", "SpЂ炪Ȃœ͂ĂB", new PirkaCheckerString(new PirkaCheckerStringChars(ZENKAKU_KANA)));
		addCheck("firstNameFurigana", "K{ڂłB", PirkaChecker.required);
		addCheck("firstNameFurigana", "SpЂ炪Ȃœ͂ĂB", new PirkaCheckerString(new PirkaCheckerStringChars(ZENKAKU_KANA)));
		addCheck("lastName", "K{ڂłB", PirkaChecker.required);
		addCheck("firstName", "K{ڂłB", PirkaChecker.required);
		addCheck("mail", "K{ڂłB", PirkaChecker.required);
		addCheck("mail", "[AhXŎg镶͂ĂB", new PirkaCheckerString(PirkaCheckerStringChars.MAIL));
		addCheck("phone", "K{ڂłB", PirkaChecker.required);
		addCheck("phone", "pƃnCtœ͂ĂB", new PirkaCheckerString(new PirkaCheckerStringChars(PHONE_STRING)));
		addCheck("phone", "X`PQ͈̔͂œ͂ĂB", new PirkaCheckerLength(PirkaCheckerLength.RANGE, 9, 12));
		addCheck("mobilePhone", "pƃnCtœ͂ĂB", new PirkaCheckerString(new PirkaCheckerStringChars(PHONE_STRING)));
		addCheck("mobilePhone", "PP`PR͈̔͂œ͂ĂB", new PirkaCheckerLength(PirkaCheckerLength.RANGE, 11, 13));
		addErrorCheckReturner();
	}
	
	/**
	 * ۑ
	 * @return ߂EBhEBG[̏ꍇthisB
	 */
	public PirkaWindow save() {
		PirkaWindow result = null;
		Address newAddress = new Address();
		getBean(newAddress);
		AddressDao dao = (AddressDao)S2.getComponent(AddressDao.class);
		if (address != null) {
			newAddress.setId(address.getId());
			newAddress.setTimestamp(address.getTimestamp());
			try {
				dao.update(newAddress);
			} catch (NotSingleRowUpdatedRuntimeException ex) {
				addError("ŕύXĂ܂Bꗗʂɖ߂čēxҏWĂB");
				result = this;
			}
		} else {
			dao.insert(newAddress);
		}
		return result;
	}

	/**
	 * LZ
	 * @return nulli߂j
	 */
	public PirkaWindow cancel() {
		return null;
	}

}
