/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.util.check;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.check.CheckAndTeller;
import jp.oarts.pirka.core.util.check.Checker;
import jp.oarts.pirka.core.util.check.CheckerItem;
import jp.oarts.pirka.core.util.check.CheckerStocker;
import jp.oarts.pirka.core.util.check.PirkaCheckException;
import jp.oarts.pirka.core.util.field.FieldItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCheck
implements Serializable {
    int errorCount = 0;
    private boolean isReturn = false;

    public boolean isReturn() {
        return this.isReturn;
    }

    public int runCheck(CheckerStocker checkerStocker, Map<String, FieldItem> rootFieldMap, FieldMap fieldMap, ErrorMessageStocker errorMessageStocker) {
        int i = 0;
        while (i < checkerStocker.size()) {
            CheckerItem checkerItem = checkerStocker.getCheckItem(i);
            if (checkerItem.getMode() == 1) {
                Iterator<String> iterator = rootFieldMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String fieldName;
                    String baseFieldName = fieldName = iterator.next();
                    int index = fieldName.indexOf(36);
                    if (index >= 0) {
                        baseFieldName = fieldName.substring(0, index);
                    }
                    if (!baseFieldName.equals(checkerItem.getFieldName())) continue;
                    FieldItem fieldItem = rootFieldMap.get(fieldName);
                    String value = (String)fieldItem.getValue();
                    try {
                        Checker[] checkerArray = checkerItem.getCheckers();
                        int n = 0;
                        int n2 = checkerArray.length;
                        while (n < n2) {
                            Checker checker = checkerArray[n];
                            checker.check(value);
                            ++n;
                        }
                    }
                    catch (PirkaCheckException e) {
                        ++this.errorCount;
                        fieldItem.setErrorFlag(true);
                        if (checkerItem.getPrikaMessage() == null) {
                            if (checkerItem.getErrorMessage() == null || checkerItem.getErrorMessage().length() <= 0) {
                                errorMessageStocker.addError(fieldItem.getCtrl().getOfficialFieldName(), e.getMessage());
                                continue;
                            }
                            errorMessageStocker.addError(fieldItem.getCtrl().getOfficialFieldName(), checkerItem.getErrorMessage());
                            continue;
                        }
                        errorMessageStocker.addError(fieldItem.getCtrl().getOfficialFieldName(), checkerItem.getPrikaMessage());
                    }
                }
            } else if (checkerItem.getMode() == 2) {
                CheckAndTeller[] checkAndTellerArray = checkerItem.getCheckAndTellers();
                int n = 0;
                int n3 = checkAndTellerArray.length;
                while (n < n3) {
                    CheckAndTeller checkAndTeller = checkAndTellerArray[n];
                    checkAndTeller.setFieldMap(fieldMap);
                    checkAndTeller.setErrorMessageStocker(errorMessageStocker);
                    if (!checkAndTeller.check()) {
                        ++this.errorCount;
                    }
                    ++n;
                }
            } else if (checkerItem.getMode() == 3) {
                if (this.errorCount > 0) {
                    return this.errorCount;
                }
            } else if (checkerItem.getMode() == 4 && this.errorCount > 0) {
                this.isReturn = true;
                return this.errorCount;
            }
            ++i;
        }
        return this.errorCount;
    }
}

