/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.analyzer.html;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.HtmlPartsType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlTools
implements Serializable {
    private static final long serialVersionUID = -8207798152943945086L;
    private static final String TAG_HAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789$_";
    private static final String TAG_IN_SEPARATOR = " \t\r\n";

    static boolean isTagInSeparator(char c) {
        return TAG_IN_SEPARATOR.indexOf(c) >= 0;
    }

    static boolean isTagChar(char c) {
        return TAG_HAR.indexOf(c) >= 0;
    }

    static String makeHtmlString(List<HtmlParts> partsList) {
        StringBuilder sb = new StringBuilder();
        for (HtmlParts parts : partsList) {
            sb.append(parts.getOrgString());
            if (parts.getChild() == null) continue;
            sb.append(HtmlTools.makeHtmlString(parts.getChild()));
            sb.append(parts.getEndTag());
        }
        return sb.toString();
    }

    static TreeMap<String, String> getOptionMap(String tagString) {
        String[] strList = HtmlTools.tagSplit(tagString);
        TreeMap<String, String> map = new TreeMap<String, String>();
        int i = 1;
        while (i < strList.length) {
            char c = strList[i].charAt(0);
            if (c != '\'' && c != '\"' && c != '=') {
                if (i < strList.length - 1) {
                    if (strList[i + 1].charAt(0) == '=') {
                        if (i < strList.length - 2) {
                            map.put(strList[i], HtmlTools.cutQuotation(strList[i + 2]));
                            i += 2;
                        } else {
                            map.put(strList[i], "");
                            ++i;
                        }
                    } else {
                        map.put(strList[i], null);
                    }
                } else {
                    map.put(strList[i], null);
                }
            }
            ++i;
        }
        return map;
    }

    static String[] tagSplit(String tagString) {
        ArrayList<String> list = new ArrayList<String>();
        char q = '\u0000';
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < tagString.length() - 1) {
            char c = tagString.charAt(i);
            if (q != '\u0000') {
                sb.append(c);
                if (q == c) {
                    list.add(sb.toString());
                    sb.setLength(0);
                    q = '\u0000';
                }
            } else if (c == '\'' || c == '\"') {
                if (sb.length() > 0) {
                    list.add(sb.toString());
                    sb.setLength(0);
                }
                sb.append(c);
                q = c;
            } else if (c == '=') {
                if (sb.length() > 0) {
                    list.add(sb.toString());
                    sb.setLength(0);
                }
                list.add("=");
            } else if (sb.length() <= 0) {
                if (!HtmlTools.isTagInSeparator(c)) {
                    sb.append(c);
                }
            } else if (HtmlTools.isTagInSeparator(c)) {
                list.add(sb.toString());
                sb.setLength(0);
            } else {
                sb.append(c);
            }
            ++i;
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list.toArray(new String[0]);
    }

    static String cutQuotation(String str) {
        if (str == null || str.length() < 1) {
            return str;
        }
        char c = str.charAt(0);
        if (c != '\'' && c != '\"') {
            return str;
        }
        char ec = str.charAt(str.length() - 1);
        if (c == ec) {
            if (str.length() > 2) {
                return str.substring(1, str.length() - 1);
            }
            return "";
        }
        return str.substring(1);
    }

    static void stringStart(StringBuilder sb, Reader r, char s) throws IOException {
        int cint;
        while ((cint = r.read()) >= 0) {
            char c = (char)cint;
            sb.append(c);
            if (c != s) continue;
            return;
        }
    }

    public static List<HtmlParts> cloneHtmlPartsList(List<HtmlParts> list) {
        ArrayList<HtmlParts> cloneList = new ArrayList<HtmlParts>();
        for (HtmlParts parts : list) {
            cloneList.add((HtmlParts)parts.clone());
        }
        return cloneList;
    }

    public static String makeName(String baseName, String loopSufix) {
        if (loopSufix == null || loopSufix.length() <= 0) {
            return baseName;
        }
        return String.valueOf(baseName) + loopSufix;
    }

    public static String changeSuffix(String loopSufix, int groupLoopLevel) {
        if (groupLoopLevel <= 0) {
            return loopSufix;
        }
        String[] loopStrs = loopSufix.split("\\$");
        int count = loopStrs.length - 1 - groupLoopLevel;
        if (count <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 1;
        while (i <= count) {
            sb.append('$');
            sb.append(loopStrs[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String toSimpleString(List<HtmlParts> list) {
        StringBuilder sb = new StringBuilder();
        if (list != null) {
            for (HtmlParts parts : list) {
                if (parts.getType() == HtmlPartsType.TAG) {
                    sb.append('<');
                    sb.append(parts.getTagName());
                    sb.append(HtmlTools.changeHtmlOption2String(parts.getOption()));
                    sb.append('>');
                    if (parts.getChild() == null) continue;
                    sb.append(HtmlTools.toSimpleString(parts.getChild()));
                    sb.append("</");
                    sb.append(parts.getTagName());
                    sb.append('>');
                    continue;
                }
                sb.append(parts.getOrgString());
            }
        }
        return sb.toString();
    }

    private static String changeHtmlOption2String(Map<String, String> optionMap) {
        StringBuilder sb = new StringBuilder();
        HtmlTools.addOption(sb, optionMap, "type");
        HtmlTools.addOption(sb, optionMap, "name");
        for (String key : optionMap.keySet()) {
            if (key.equalsIgnoreCase("type") || key.equalsIgnoreCase("name")) continue;
            HtmlTools.addOption(sb, optionMap, key);
        }
        return sb.toString();
    }

    private static boolean addOption(StringBuilder sb, Map<String, String> optionMap, String optionName) {
        if (optionMap.containsKey(optionName)) {
            sb.append(' ');
            sb.append(optionName);
            String value = optionMap.get(optionName);
            if (value != null) {
                sb.append('=');
                sb.append('\"');
                sb.append(value);
                sb.append('\"');
            }
            return true;
        }
        return false;
    }

    public static String webString(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String webStringWithSpace(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case ' ': {
                    sb.append("&nbsp;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

