/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.analyzer.html;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesserManager;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.HtmlPartsType;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.field.FieldItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlFieldMapAnalyzer
implements Serializable {
    private static final long serialVersionUID = -6342236803595233193L;

    public static FieldMap getFieldMap(List<HtmlParts> list, Map<String, CtrlProcesser> ctrlProcesserMap) {
        if (list == null) {
            return null;
        }
        FieldMap fieldMap = new FieldMap();
        HtmlFieldMapAnalyzer.getFieldMain(fieldMap, list, ctrlProcesserMap, 0);
        return fieldMap;
    }

    private static void getFieldMain(FieldMap fieldMap, List<HtmlParts> list, Map<String, CtrlProcesser> ctrlProcesserMap, int loopDeepLevel) {
        for (HtmlParts parts : list) {
            if (parts.getType() != HtmlPartsType.TAG) continue;
            String name = parts.getOption().get("name");
            if (name != null && name.length() > 0) {
                if (fieldMap.containsKey(name)) {
                    throw new RuntimeException("\u540c\u3058\u540d\u524d\u3092\u6301\u3064\u30bf\u30b0\u304c\u8907\u6570\u5b58\u5728\u3057\u307e\u3059 " + name);
                }
                HtmlCtrlParts ctrl = new HtmlCtrlParts(parts.getTagName(), parts.getOption(), parts.getChild() != null);
                CtrlProcesser ctrlProcesser = CtrlProcesserManager.getCtrlProseccer(ctrl.getProcesserNmae(), ctrlProcesserMap);
                ctrl.setCtrlProcesser(ctrlProcesser);
                ctrlProcesser.analyzeInitValue(ctrl, parts.getChild());
                if (ctrlProcesser.isLoop()) {
                    FieldMap childMap = new FieldMap();
                    ArrayList<FieldMap> childList = new ArrayList<FieldMap>();
                    childList.add(childMap);
                    FieldItem fieldItem = new FieldItem(childList, false, 0L, ctrl, null, loopDeepLevel);
                    fieldMap.setFieldItem(name, fieldItem);
                    if (parts.getChild() == null) continue;
                    HtmlFieldMapAnalyzer.getFieldMain(childMap, parts.getChild(), ctrlProcesserMap, loopDeepLevel + 1);
                    continue;
                }
                FieldItem fieldItem = new FieldItem(ctrl.getDefaultValue(), false, 0L, ctrl, null, loopDeepLevel);
                if (ctrlProcesser.isCheckCtrl()) {
                    if (ctrl.getOptionMap().containsKey("checked")) {
                        fieldItem.setChecked(true);
                    } else {
                        fieldItem.setChecked(false);
                    }
                }
                fieldMap.setFieldItem(name, fieldItem);
                if (parts.getChild() == null) continue;
                HtmlFieldMapAnalyzer.getFieldMain(fieldMap, parts.getChild(), ctrlProcesserMap, loopDeepLevel);
                continue;
            }
            if (parts.getChild() == null) continue;
            HtmlFieldMapAnalyzer.getFieldMain(fieldMap, parts.getChild(), ctrlProcesserMap, loopDeepLevel);
        }
    }
}

