<?php
require_once(RENDERER_DIR . "SmartyRenderer.class.php");

class SmartyFilter extends Filter {
	function execute (&$filterChain, &$controller, &$request, &$user) {
		// see if renderer is already loaded
		$loaded =& $request->getAttribute("SmartyRenderer");

		if ($loaded == NULL) {
			// smarty init params
			$params =  array(
				"cache_dir"			=> SMARTY_CACHE_DIR,
				"caching"			=> SMARTY_CACHING,
				"force_compile"		=> SMARTY_FORCE_COMPILE,
				"compile_dir"		=> SMARTY_COMPILE_DIR,
				"config_dir"		=> $controller->getModuleDir()."config/",
				"app_name"			=> $controller->getCurrentModule(),
				"debug_tpl"			=> SMARTY_DEBUG_TPL,
				"debugging_ctrl"	=> SMARTY_DEBUGGING_CTRL,
				"debugging"			=> SMARTY_DEBUGGING,
				"compile_id"		=> $controller->currentModule
			);

			$renderer =& new SmartyRenderer($controller, $request, $user);
			$smarty = & $renderer->getEngine();
			
			foreach ($params as $key => $value) {
				$smarty->$key = $value;
			}

			// add param
			$smarty->assign("static_path", WEB_MODULE_DIR.$controller->currentModule."/");

			// set the renderer as a request attribute so we can retrieve it
			$request->setAttributeByRef("SmartyRenderer", $renderer);

			// execute chain
			$filterChain->execute($controller, $request, $user);

			// remove renderer
			$request->removeAttribute("SmartyRenderer");

		} else {
			$filterChain->execute($controller, $request, $user);
		}
	}
}
?>