/****************************************************************
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License or any later
 * version.  This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details. You should have received a copy
 * of the GNU Lesser General Public License along with this program; if not,
 * write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307 USA.
 ****************************************************************
 * copyright (c) 2005 TOMITA, Ryuzo(r-tomita01@sda.nagoya-cu.ac.jp)
 */

#ifndef PHP_RAST_H
#define PHP_RAST_H

extern zend_module_entry rast_module_entry;
#define phpext_rast_ptr &rast_module_entry

#ifdef PHP_WIN32
#define PHP_RAST_API __declspec(dllexport)
#else
#define PHP_RAST_API
#endif

#ifdef ZTS
#include "TSRM.h"
#endif

PHP_MINIT_FUNCTION(rast);
PHP_MSHUTDOWN_FUNCTION(rast);
PHP_RINIT_FUNCTION(rast);
PHP_RSHUTDOWN_FUNCTION(rast);
PHP_MINFO_FUNCTION(rast);

PHP_FUNCTION(rast_db_create);
PHP_FUNCTION(rast_open);
PHP_FUNCTION(rast_merger_open);
PHP_FUNCTION(rast_close);
PHP_FUNCTION(rast_register);
PHP_FUNCTION(rast_update);
PHP_FUNCTION(rast_delete);
PHP_FUNCTION(rast_search);
PHP_FUNCTION(rast_get_encoding);
PHP_FUNCTION(rast_get_properties);
PHP_FUNCTION(rast_result_get_terms);
PHP_FUNCTION(rast_result_get_hit_count);
PHP_FUNCTION(rast_result_get_items);


#ifdef ZTS
#define RAST_G(v) TSRMG(rast_globals_id, zend_rast_globals *, v)
#else
#define RAST_G(v) (rast_globals.v)
#endif

#endif	/* PHP_RAST_H */
/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: t
 * End:
 */
