# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl Win32-Dokan.t'

use strict;

#########################

# change 'tests => 2' to 'tests => last_test_to_print';

use Test::More tests => 7;

use_ok('Win32::Dokan');
use_ok('Win32::Dokan::Mounter');
use_ok('Win32::Dokan::FS');
use_ok('Win32::Dokan::Const');

use Win32::Dokan::Const qw(:all);

my $fail = 0;
foreach my $constname (qw(
	FILE_ATTRIBUTE_DIRECTORY FILE_ATTRIBUTE_NORMAL
	DOKAN_DRIVER_INSTALL_ERROR
	DOKAN_DRIVE_LETTER_ERROR DOKAN_ERROR DOKAN_MOUNT_ERROR
	DOKAN_START_ERROR DOKAN_SUCCESS)) {
  next if (eval "my \$a = $constname; 1");
  if ($@ =~ /^Your vendor has not defined Win32::Dokan macro $constname/) {
    print "# pass: $@";
  } else {
    print "# fail: $@";
    $fail = 1;
  }

}

ok( $fail == 0 , 'Constants' );
#########################

# use lib './t';
# use TestFS;
# use Win32::Dokan::DokanOptions;

# my $fs = TestFS->new("D:/tmp");
# my $options = Win32::Dokan::DokanOptions->new({debug_mode => 1,
# 					       use_std_err => 1});
# my $dokan = Win32::Dokan->new($options);
# $dokan->mount('W', $fs);

my $utf16le_abc = "a\0b\0c\0";
is(Win32::Dokan->convert_unicode_to_native($utf16le_abc), "abc");
is(Win32::Dokan->convert_native_to_unicode("abc"), $utf16le_abc);
