/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hakyukoka;

import java.util.LinkedList;
import java.util.List;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.AreaEditStep;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.hakyukoka.Area;
import pencilbox.hakyukoka.DigitPatternHint;
import pencilbox.resource.Messages;

public class Board
extends BoardBase {
    static final int BLANK = 0;
    static final int UNKNOWN = 0;
    static final int UNDETERMINED = -2;
    private List<Area> areaList;
    private int[][] state;
    private int[][] number;
    private Area[][] area;
    private int[][] multi;
    private int[][] multi2;
    private DigitPatternHint hint;

    @Override
    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.number = new int[this.rows()][this.cols()];
        this.area = new Area[this.rows()][this.cols()];
        this.areaList = new LinkedList<Area>();
        this.multi = new int[this.rows()][this.cols()];
        this.multi2 = new int[this.rows()][this.cols()];
        this.hint = new DigitPatternHint();
        this.hint.setupHint(this);
    }

    @Override
    public void clearBoard() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            this.setState(p, 0);
            ++n2;
        }
        this.initBoard();
    }

    public boolean isStable(int r, int c) {
        return this.number[r][c] != 0;
    }

    public boolean isStable(Address pos) {
        return this.isStable(pos.r(), pos.c());
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public int getState(Address pos) {
        return this.getState(pos.r(), pos.c());
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public void setState(Address pos, int st) {
        this.setState(pos.r(), pos.c(), st);
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address pos) {
        return this.getNumber(pos.r(), pos.c());
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public void setNumber(Address pos, int n) {
        this.setNumber(pos.r(), pos.c(), n);
    }

    public int getNumberOrState(Address p) {
        return this.isStable(p) ? this.getNumber(p) : this.getState(p);
    }

    public Area getArea(int r, int c) {
        return this.area[r][c];
    }

    public Area getArea(Address pos) {
        return this.getArea(pos.r(), pos.c());
    }

    public void setArea(int r, int c, Area a) {
        this.area[r][c] = a;
    }

    public void setArea(Address pos, Area a) {
        this.setArea(pos.r(), pos.c(), a);
    }

    public boolean isError(Address p) {
        return this.isTooClose(p) || this.isMultipleNumber(p) || this.isTooLarge(p);
    }

    public boolean isTooClose(Address p) {
        return this.multi[p.r()][p.c()] > 1;
    }

    public boolean isMultipleNumber(Address p) {
        return this.multi2[p.r()][p.c()] > 1;
    }

    public boolean isTooLarge(Address p) {
        return this.getArea(p) != null && this.getNumberOrState(p) > this.getArea(p).size();
    }

    int getPattern(Address p) {
        return this.hint.getPattern(p);
    }

    boolean canPlace(Address p, int n) {
        return this.hint.canPlace(p, n);
    }

    public void changeAnswerNumber(Address p, int n) {
        int prev = this.getState(p);
        if (n == prev) {
            return;
        }
        if (this.isStable(p)) {
            this.changeFixedNumber(p, 0);
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.NUMBER, p, prev, n));
        }
        this.setState(p, n);
        this.changeNumber1(p, prev, n);
    }

    public void changeFixedNumber(Address p, int n) {
        int prev = this.getNumber(p);
        if (n == prev) {
            return;
        }
        if (this.getState(p) > 0) {
            this.changeAnswerNumber(p, 0);
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.FIXED, p, prev, n));
        }
        this.setNumber(p, n);
        this.changeNumber1(p, prev, n);
    }

    private void changeNumber1(Address p, int prev, int n) {
        this.updateMulti(p, prev, n);
        if (this.getArea(p) != null) {
            this.updateMulti2(p, prev, n);
        }
        if (prev == 0 && n > 0) {
            this.hint.checkUsedNumber(p, n);
        } else {
            this.hint.initHint();
        }
    }

    @Override
    public void undo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            if (s.getType() == AbstractStep.EditType.NUMBER) {
                this.changeAnswerNumber(s.getPos(), s.getBefore());
            } else if (s.getType() == AbstractStep.EditType.FIXED) {
                this.changeFixedNumber(s.getPos(), s.getBefore());
            }
        } else if (step instanceof AreaEditStep) {
            AreaEditStep s = (AreaEditStep)step;
            if (s.getOperation() == 1) {
                this.removeCell(s.getPos());
            } else if (s.getOperation() == 0) {
                this.addCell(s.getP0(), s.getPos());
            }
        }
    }

    @Override
    public void redo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            if (s.getType() == AbstractStep.EditType.NUMBER) {
                this.changeAnswerNumber(s.getPos(), s.getAfter());
            } else if (s.getType() == AbstractStep.EditType.FIXED) {
                this.changeFixedNumber(s.getPos(), s.getAfter());
            }
        } else if (step instanceof AreaEditStep) {
            AreaEditStep s = (AreaEditStep)step;
            if (s.getOperation() == 1) {
                this.addCell(s.getP0(), s.getPos());
            } else if (s.getOperation() == 0) {
                this.removeCell(s.getPos());
            }
        }
    }

    void addCell(Address p0, Address p) {
        if (Address.NOWHERE.equals(p0)) {
            Area a = new Area();
            this.addCellToArea(p, a);
        } else {
            Area a = this.getArea(p0);
            if (a != null) {
                this.addCellToArea(p, a);
            }
        }
    }

    void removeCell(Address p) {
        Area a = this.getArea(p);
        if (a != null) {
            this.removeCellFromArea(p, a);
        }
    }

    public void addCellToArea(Address p, Area a) {
        if (this.isRecordUndo()) {
            Address p0 = Address.NOWHERE;
            if (a.size() > 0) {
                p0 = a.getTopCell(Address.NOWHERE);
            }
            this.fireUndoableEditUpdate(new AreaEditStep(p, p0, 1));
        }
        if (a.isEmpty()) {
            this.areaList.add(a);
        }
        this.setArea(p, a);
        a.add(p);
    }

    public void removeCellFromArea(Address p, Area a) {
        if (this.isRecordUndo()) {
            Address p0 = Address.NOWHERE;
            if (a.size() > 1) {
                p0 = a.getTopCell(p);
            }
            this.fireUndoableEditUpdate(new AreaEditStep(p, p0, 0));
        }
        this.setArea(p, null);
        a.remove(p);
        if (a.isEmpty()) {
            this.areaList.remove(a);
        }
    }

    public void addArea(Area newArea) {
        for (Address p : newArea) {
            this.setArea(p, newArea);
        }
        this.areaList.add(newArea);
    }

    public void addWholeArea(Area newArea) {
        Address[] cells;
        Address[] addressArray = cells = newArea.toArray(new Address[0]);
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            this.addCellToArea(p, newArea);
            ++n2;
        }
    }

    public void removeWholeArea(Area oldArea) {
        Address[] cells;
        Address[] addressArray = cells = oldArea.toArray(new Address[0]);
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            this.removeCellFromArea(p, oldArea);
            ++n2;
        }
    }

    List<Area> getAreaList() {
        return this.areaList;
    }

    int[][] getNumber() {
        return this.number;
    }

    int[][] getState() {
        return this.state;
    }

    @Override
    public void initBoard() {
        this.initMulti();
        this.initMulti2();
        this.hint.initHint();
    }

    void initMulti() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int n3 = this.getNumberOrState(p);
            if (n3 > 0) {
                this.multi[p.r()][p.c()] = 1;
                this.updateMulti1(p, n3, 1, 0);
            } else {
                this.multi[p.r()][p.c()] = 0;
            }
            ++n2;
        }
    }

    void updateMulti(Address p0, int prev, int num) {
        int c0;
        int r0 = p0.r();
        if (this.multi[r0][c0 = p0.c()] > 1) {
            this.updateMulti1(p0, prev, 0, -1);
        }
        if (num > 0) {
            this.multi[r0][c0] = 1;
            this.updateMulti1(p0, num, 1, 1);
        } else if (num <= 0) {
            this.multi[r0][c0] = 0;
        }
    }

    private void updateMulti1(Address p0, int num, int m, int k) {
        int d = 0;
        while (d < 4) {
            Address p = p0;
            int l = 1;
            while (l <= num) {
                if (!this.isOn(p = Address.nextCell(p, d))) break;
                if (this.getNumberOrState(p) == num) {
                    int[] nArray = this.multi[p.r()];
                    int n = p.c();
                    nArray[n] = nArray[n] + k;
                    int[] nArray2 = this.multi[p0.r()];
                    int n2 = p0.c();
                    nArray2[n2] = nArray2[n2] + m;
                }
                ++l;
            }
            ++d;
        }
    }

    void initMulti2() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int n3 = this.getNumberOrState(p);
            if (n3 > 0 && this.getArea(p) != null) {
                this.multi2[p.r()][p.c()] = 1;
                this.updateMulti21(p, n3, 1, 0);
            } else {
                this.multi2[p.r()][p.c()] = 0;
            }
            ++n2;
        }
    }

    void updateMulti2(Address p0, int prev, int num) {
        int c0;
        int r0 = p0.r();
        if (this.multi2[r0][c0 = p0.c()] > 1) {
            this.updateMulti21(p0, prev, 0, -1);
        }
        if (num > 0) {
            this.multi2[r0][c0] = 1;
            this.updateMulti21(p0, num, 1, 1);
        } else if (num <= 0) {
            this.multi2[r0][c0] = 0;
        }
    }

    private void updateMulti21(Address p0, int num, int m, int k) {
        for (Address p : this.getArea(p0)) {
            if (p.equals(p0) || this.getNumberOrState(p) != num) continue;
            int[] nArray = this.multi2[p.r()];
            int n = p.c();
            nArray[n] = nArray[n] + k;
            int[] nArray2 = this.multi2[p0.r()];
            int n2 = p0.c();
            nArray2[n2] = nArray2[n2] + m;
        }
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getNumberOrState(p) > 0 && this.isMultipleNumber(p)) {
                result |= 2;
            }
            if (this.isTooLarge(p)) {
                result |= 4;
            }
            if (this.isTooClose(p)) {
                result |= 8;
            }
            if (this.getNumberOrState(p) <= 0) {
                result |= 1;
            }
            ++n2;
        }
        return result;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        if (result == 1) {
            return Messages.getString("hakyukoka.AnswerCheckMessage1");
        }
        StringBuffer message = new StringBuffer();
        if ((result & 2) == 2) {
            message.append(Messages.getString("hakyukoka.AnswerCheckMessage2"));
        }
        if ((result & 4) == 4) {
            message.append(Messages.getString("hakyukoka.AnswerCheckMessage3"));
        }
        if ((result & 8) == 8) {
            message.append(Messages.getString("hakyukoka.AnswerCheckMessage4"));
        }
        return message.toString();
    }
}

