/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.bijutsukan;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.bijutsukan.Board;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;

public class Panel
extends PanelBase {
    private Board board;

    public Panel() {
        this.setMarkStyle(3);
        this.setNumberColor(Color.WHITE);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.drawCells(g);
        this.drawGrid(g);
        this.drawBoardBorder(g);
    }

    private void drawCells(Graphics2D g) {
        g.setFont(this.getNumberFont());
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int state = this.board.getState(p);
            int l = this.board.getHorizIlluminated(p);
            int m = this.board.getVertIlluminated(p);
            if (this.isPaintIlluminatedCellMode() && (l > 0 || m > 0)) {
                g.setColor(this.getIlluminatedCellColor());
                this.paintCell(g, p);
            }
            if (state >= 0 && state <= 4) {
                g.setColor(this.getWallColor());
                this.paintCell(g, p);
                g.setColor(this.getNumberColor());
                if (this.isIndicateErrorMode() && this.board.checkAdjacentBulbs(p) <= 0) {
                    g.setColor(this.getErrorColor());
                }
                this.placeNumber(g, p, state);
            } else if (state == 5) {
                g.setColor(this.getWallColor());
                this.paintCell(g, p);
            } else if (state == -2) {
                g.setColor(this.getBulbColor());
                if (this.isIndicateErrorMode() && this.board.isMultiIlluminated(p)) {
                    g.setColor(this.getErrorColor());
                }
                this.placeFilledCircle(g, p);
            } else if (state == -3) {
                g.setColor(this.getNoBulbColor());
                this.placeMark(g, p);
            }
            if (this.isShowBeamMode()) {
                g.setColor(this.getBulbColor());
                if (l > 0) {
                    if (this.isIndicateErrorMode() && l > 1) {
                        g.setColor(this.getErrorColor());
                    }
                    this.placeCenterLine(g, p, 1);
                }
                g.setColor(this.getBulbColor());
                if (m > 0) {
                    if (this.isIndicateErrorMode() && m > 1) {
                        g.setColor(this.getErrorColor());
                    }
                    this.placeCenterLine(g, p, 0);
                }
            }
            ++n2;
        }
    }
}

