/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.satogaeri;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.io.XmlWriterBase;
import pencilbox.satogaeri.Board;

public class XmlWriter
extends XmlWriterBase {
    @Override
    protected void setBoardData(BoardBase theboard) {
        int c;
        Board board = (Board)theboard;
        this.outAreas(board.getAreaList().size());
        int rows = board.rows();
        int cols = board.cols();
        int r = 0;
        while (r < rows) {
            this.startBrow(r);
            c = 0;
            while (c < cols) {
                if (board.getArea(r, c) == null) {
                    this.out("u");
                } else {
                    this.outN(board.getAreaList().indexOf(board.getArea(r, c)));
                }
                ++c;
            }
            this.endBrow();
            ++r;
        }
        r = 0;
        while (r < rows) {
            c = 0;
            while (c < cols) {
                int n = board.getNumber(r, c);
                if (n >= 0) {
                    this.outNumber(r, c, n);
                } else if (n == -2) {
                    this.outNumber(r, c, -2);
                }
                ++c;
            }
            ++r;
        }
    }

    @Override
    protected void setAnswerData(BoardBase theboard) {
        Board board = (Board)theboard;
        int rows = board.rows();
        int cols = board.cols();
        int r = 0;
        while (r < rows) {
            this.startArow(r);
            int c = 0;
            while (c < cols) {
                int s = board.getRoute(Address.address(r, c));
                this.outN(s);
                ++c;
            }
            this.endArow();
            ++r;
        }
    }

    void outAreas(int v) {
        this.startTag(2, "areas");
        this.attribute("N", v);
        this.emptyTag();
    }
}

