/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.satogaeri;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.satogaeri.Area;
import pencilbox.satogaeri.Board;
import pencilbox.satogaeri.Panel;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int currentState = -9;
    private static final int NULLSTATE = -9;
    private static final int BALL = -19;
    private static final int NUMBER = -20;
    private static final int MOVE = -21;
    private int dragState = 0;
    private static final int INIT = 0;
    private static final int PRESS_NEW = 1;
    private static final int PRESS_EXISTING = 2;
    private static final int DRAG_ADD = 3;
    private static final int DRAG_REMOVE = 4;

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.setMaxInputNumber(9);
    }

    Area getDraggingArea() {
        return ((Panel)this.getPanel()).getDraggingArea();
    }

    void setDraggingArea(Area draggingArea) {
        ((Panel)this.getPanel()).setDraggingArea(draggingArea);
    }

    @Override
    protected void leftPressed(Address pos) {
        if (this.isProblemEditMode()) {
            Area area = this.board.getArea(pos);
            if (area == null) {
                area = new Area();
                this.board.addCellToArea(pos, area);
                this.dragState = 1;
            } else {
                this.dragState = 2;
            }
            this.setDraggingArea(area);
        } else {
            this.currentState = this.board.getRoute(pos) == 8 ? -19 : (this.board.hasNumber(pos) ? -20 : -9);
        }
    }

    @Override
    protected void leftDragged(Address oldPos, Address pos) {
        if (this.isProblemEditMode()) {
            Area draggingArea = this.getDraggingArea();
            if (draggingArea == null) {
                return;
            }
            Area oldArea = this.board.getArea(pos);
            if (this.dragState == 1 || this.dragState == 2) {
                this.dragState = oldArea == null || oldArea != draggingArea ? 3 : 4;
            }
            if (this.dragState == 3) {
                if (oldArea != null && oldArea != draggingArea) {
                    this.board.removeCellFromArea(pos, oldArea);
                    this.board.addCellToArea(pos, draggingArea);
                } else if ((oldArea == null || oldArea != draggingArea) && oldArea == null) {
                    this.board.addCellToArea(pos, draggingArea);
                }
            } else if (this.dragState == 4) {
                if (!this.isOn(oldPos)) {
                    return;
                }
                Area oldoldArea = this.board.getArea(oldPos);
                if (oldoldArea != null) {
                    this.board.removeCellFromArea(oldPos, oldoldArea);
                }
            }
        } else if (this.currentState == -19 || this.currentState == -20 || this.currentState == -21) {
            this.changeRoute(oldPos, pos);
            this.currentState = -21;
        }
    }

    @Override
    protected void leftReleased(Address pos) {
        if (this.isProblemEditMode()) {
            if (this.dragState == 2) {
                this.board.removeCellFromArea(pos, this.board.getArea(pos));
            }
            this.setDraggingArea(null);
            this.dragState = 0;
        } else {
            if (this.isOn(pos)) {
                if (this.currentState == -19) {
                    this.board.eraseRoute(pos);
                } else if (this.currentState == -20) {
                    this.changeRoute1(pos, 8);
                }
            }
            this.currentState = -9;
        }
    }

    @Override
    protected void rightPressed(Address pos) {
        this.isProblemEditMode();
    }

    @Override
    protected void rightDragged(Address pos) {
        if (this.isProblemEditMode()) {
            this.rightPressed(pos);
        }
    }

    private void changeRoute(Address pos0, Address pos1) {
        int direction = Address.getDirectionTo(pos0, pos1);
        if (direction < 0) {
            return;
        }
        Address p = pos0;
        while (!p.equals(pos1)) {
            this.changeRoute1(p, direction);
            p = p.nextCell(direction);
        }
    }

    private void changeRoute1(Address p, int d) {
        if (this.board.hasNumber(p) && this.board.getRoute(p) != 8) {
            this.board.eraseRoute(p);
        }
        if (this.board.getRoute(p) != 8 && !this.board.hasNumber(p)) {
            return;
        }
        if (d >= 0 && d <= 3) {
            Address q = p.nextCell(d);
            if (!this.board.isOn(q)) {
                return;
            }
            if (this.board.getRoute(q) == (d ^ 2)) {
                this.board.changeRoute(q, 8);
            } else if (this.board.getRoute(q) == -1 && !this.board.hasNumber(q)) {
                int d1 = this.board.getIncomingDirection(p);
                if (d1 != 8 && d1 != d) {
                    return;
                }
                this.board.changeRoute(p, d);
            }
        } else if (d == 8) {
            this.board.changeRoute(p, d);
        }
    }

    @Override
    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            this.board.changeFixedNumber(pos, num);
            if (this.isSymmetricPlacementMode()) {
                Address posS = this.getSymmetricPosition(pos);
                this.board.changeFixedNumber(posS, -2);
            }
        }
    }

    @Override
    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.changeFixedNumber(pos, -1);
            if (this.isSymmetricPlacementMode()) {
                Address posS = this.getSymmetricPosition(pos);
                this.board.changeFixedNumber(posS, -1);
            }
        }
    }

    @Override
    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.changeFixedNumber(pos, -2);
            if (this.isSymmetricPlacementMode()) {
                Address posS = this.getSymmetricPosition(pos);
                this.board.changeFixedNumber(posS, -2);
            }
        }
    }
}

