/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import pencilbox.common.core.Size;
import pencilbox.common.gui.PencilBoxDialog;
import pencilbox.resource.Messages;

public class NewBoardDialog
extends PencilBoxDialog {
    private static NewBoardDialog instance = new NewBoardDialog();
    private JPanel mainPanel;
    private JSpinner spinnerRows;
    private JSpinner spinnerCols;
    private JCheckBox checkBox;

    public static NewBoardDialog getInstance() {
        return instance;
    }

    private NewBoardDialog() {
    }

    @Override
    protected void makeDialog() {
        super.makeDialog();
        this.makeMainPanel();
    }

    private void makeMainPanel() {
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.spinnerCols = new JSpinner();
        this.spinnerRows = new JSpinner();
        final SpinnerNumberModel spinnerModelCols = new SpinnerNumberModel(10, 1, 200, 1);
        final SpinnerNumberModel spinnerModelRows = new SpinnerNumberModel(10, 1, 200, 1);
        this.spinnerCols.setModel(spinnerModelCols);
        this.spinnerRows.setModel(spinnerModelRows);
        JLabel labelCols = new JLabel(Messages.getString("NewBoardDialog.labelCols"));
        JLabel labelRows = new JLabel(Messages.getString("NewBoardDialog.labelRows"));
        labelCols.setHorizontalAlignment(11);
        labelRows.setHorizontalAlignment(11);
        this.checkBox = new JCheckBox(Messages.getString("NewBoardDialog.checkBoxSquare"));
        this.checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (NewBoardDialog.this.checkBox.isSelected()) {
                    NewBoardDialog.this.spinnerRows.setModel(spinnerModelCols);
                } else {
                    spinnerModelRows.setValue(spinnerModelCols.getValue());
                    NewBoardDialog.this.spinnerRows.setModel(spinnerModelRows);
                }
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets.top = 2;
        constraints.insets.bottom = 2;
        constraints.insets.left = 0;
        constraints.insets.right = 0;
        constraints.fill = 1;
        this.addComponent(labelCols, constraints, 0, 0, 1, 1);
        this.addComponent(this.spinnerCols, constraints, 1, 0, 1, 1);
        this.addComponent(labelRows, constraints, 0, 1, 1, 1);
        this.addComponent(this.spinnerRows, constraints, 1, 1, 1, 1);
        this.addComponent(this.checkBox, constraints, 1, 2, 1, 1);
        this.add((Component)this.mainPanel, "Center");
    }

    private void addComponent(Component c, GridBagConstraints constraints, int x, int y, int w, int h) {
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = w;
        constraints.gridheight = h;
        this.mainPanel.add(c, constraints);
    }

    public void setCurrentSize(Size s) {
        if (s.getCols() != s.getRows()) {
            this.checkBox.setSelected(false);
        }
        this.spinnerCols.setValue(s.getCols());
        this.spinnerRows.setValue(s.getRows());
    }

    public Size getNewSize() {
        int rows = ((Number)this.spinnerRows.getValue()).intValue();
        int cols = ((Number)this.spinnerCols.getValue()).intValue();
        return new Size(rows, cols);
    }
}

