/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.heyawake;

import java.util.LinkedList;
import java.util.List;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.common.core.Direction;
import pencilbox.common.core.SquareEditStep;
import pencilbox.heyawake.Square;
import pencilbox.resource.Messages;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int UNKNOWN = 0;
    static final int BLACK = 1;
    static final int WHITE = 2;
    private int[][] state;
    private Square[][] square;
    private List<Square> squareList;
    int[][] chain;
    int maxChain;
    int[][] contH;
    int[][] contV;
    int[][] contWH;
    int[][] contWV;
    private int[] adjacentChain = new int[4];

    @Override
    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.square = new Square[this.rows()][this.cols()];
        this.squareList = new LinkedList<Square>();
        this.contH = new int[this.rows()][this.cols()];
        this.contV = new int[this.rows()][this.cols()];
        this.contWH = new int[this.rows()][this.cols()];
        this.contWV = new int[this.rows()][this.cols()];
        this.chain = new int[this.rows()][this.cols()];
        this.maxChain = 1;
    }

    @Override
    public void clearBoard() {
        super.clearBoard();
        ArrayUtil.initArrayInt2(this.state, 0);
        int n = this.squareList.size() - 1;
        while (n >= 0) {
            this.squareList.get(n).clear();
            --n;
        }
        this.initCont();
        ArrayUtil.initArrayInt2(this.chain, 0);
    }

    @Override
    public void trimAnswer() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getState(p) == 2) {
                this.changeState(p, 0);
            }
            ++n2;
        }
        this.initCont();
        this.initRoomCount();
    }

    @Override
    public void initBoard() {
        this.initCont();
        this.initChain();
        this.initRoomCount();
    }

    int[][] getState() {
        return this.state;
    }

    public Square getSquare(int r, int c) {
        return this.square[r][c];
    }

    public Square getSquare(Address pos) {
        return this.square[pos.r()][pos.c()];
    }

    public void setSquare(int r, int c, Square sq) {
        this.square[r][c] = sq;
    }

    public void setSquare(Address pos, Square sq) {
        this.square[pos.r()][pos.c()] = sq;
    }

    List<Square> getSquareList() {
        return this.squareList;
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public int getState(Address pos) {
        return this.getState(pos.r(), pos.c());
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public void setState(Address pos, int st) {
        this.setState(pos.r(), pos.c(), st);
    }

    public boolean isBlack(Address p) {
        return this.isOn(p) && this.getState(p) == 1;
    }

    public int getCont(Address p, int dir) {
        if (dir == 0) {
            return this.contV[p.r()][p.c()];
        }
        if (dir == 1) {
            return this.contH[p.r()][p.c()];
        }
        return -1;
    }

    public void setCont(Address p, int dir, int v) {
        if (dir == 0) {
            this.contV[p.r()][p.c()] = v;
        } else if (dir == 1) {
            this.contH[p.r()][p.c()] = v;
        }
    }

    public void setCont(int r, int c, int dir, int v) {
        if (dir == 0) {
            this.contV[r][c] = v;
        } else if (dir == 1) {
            this.contH[r][c] = v;
        }
    }

    public int getContW(Address p, int dir) {
        if (dir == 0) {
            return this.contWV[p.r()][p.c()];
        }
        if (dir == 1) {
            return this.contWH[p.r()][p.c()];
        }
        return -1;
    }

    public void setContW(Address p, int dir, int v) {
        if (dir == 0) {
            this.contWV[p.r()][p.c()] = v;
        } else if (dir == 1) {
            this.contWH[p.r()][p.c()] = v;
        }
    }

    public void setContW(int r, int c, int dir, int v) {
        if (dir == 0) {
            this.contWV[r][c] = v;
        } else if (dir == 1) {
            this.contWH[r][c] = v;
        }
    }

    int getChain(Address p) {
        return this.chain[p.r()][p.c()];
    }

    void setChain(Address p, int n) {
        this.chain[p.r()][p.c()] = n;
    }

    void initCont() {
        ArrayUtil.initArrayInt2(this.contH, 0);
        ArrayUtil.initArrayInt2(this.contV, 0);
        ArrayUtil.initArrayInt2(this.contWH, 0);
        ArrayUtil.initArrayInt2(this.contWV, 0);
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            int dir;
            Address p = addressArray[n2];
            if (this.getState(p) != 1) {
                dir = 0;
                while (dir < 2) {
                    if (this.getCont(p, dir) == 0) {
                        this.countContinuousRoom(p, dir);
                    }
                    ++dir;
                }
            }
            if (this.getState(p) == 2) {
                dir = 0;
                while (dir < 2) {
                    if (this.getCont(p, dir) == 0) {
                        this.countContinuousRoomW(p, dir);
                    }
                    ++dir;
                }
            }
            ++n2;
        }
    }

    void initRoomCount() {
        Square room;
        Address p;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            room = this.getSquare(p);
            if (room != null) {
                room.setNBlack(0);
                room.setNWhite(0);
            }
            ++n2;
        }
        addressArray = this.cellAddrs();
        n = addressArray.length;
        n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            room = this.getSquare(p);
            if (room != null) {
                if (this.getState(p) == 1) {
                    room.setNBlack(room.getNBlack() + 1);
                } else if (this.getState(p) == 2) {
                    room.setNWhite(room.getNWhite() + 1);
                }
            }
            ++n2;
        }
    }

    public void changeState(Address p, int st) {
        Square room;
        Address p1;
        int d;
        int prev = this.getState(p);
        if (st == prev) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.STATE, p, prev, st));
        }
        this.setState(p, st);
        if (st == 1) {
            this.setCont(p, 1, 0);
            this.setCont(p, 0, 0);
            d = 0;
            while (d < 4) {
                p1 = Address.nextCell(p, d);
                if (this.isOn(p1)) {
                    this.countContinuousRoom(p1, d & 1);
                }
                ++d;
            }
            this.connectChain(p);
        }
        if (prev == 1) {
            this.countContinuousRoom(p, 0);
            this.countContinuousRoom(p, 1);
            this.cutChain(p);
        }
        if (st == 2) {
            this.countContinuousRoomW(p, 0);
            this.countContinuousRoomW(p, 1);
        }
        if (prev == 2) {
            this.setContW(p, 1, 0);
            this.setContW(p, 0, 0);
            d = 0;
            while (d < 4) {
                p1 = Address.nextCell(p, d);
                if (this.isOn(p1)) {
                    this.countContinuousRoomW(p1, d & 1);
                }
                ++d;
            }
        }
        if ((room = this.getSquare(p)) != null) {
            if (st == 1) {
                room.setNBlack(room.getNBlack() + 1);
            } else if (st == 2) {
                room.setNWhite(room.getNWhite() + 1);
            }
            if (prev == 1) {
                room.setNBlack(room.getNBlack() - 1);
            } else if (prev == 2) {
                room.setNWhite(room.getNWhite() - 1);
            }
        }
    }

    @Override
    public void undo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            if (step.getType() == AbstractStep.EditType.STATE) {
                this.changeState(s.getPos(), s.getBefore());
            } else if (step.getType() == AbstractStep.EditType.NUMBER) {
                this.changeNumber(s.getPos(), s.getBefore());
            }
        } else if (step instanceof SquareEditStep) {
            SquareEditStep s = (SquareEditStep)step;
            if (s.getOperation() == 1) {
                this.removeSquare(this.getSquare(s.getQ0()));
            } else if (s.getOperation() == 0) {
                this.addSquare(new Square(s.getP0(), s.getP1()));
            } else if (s.getOperation() == 2) {
                this.changeSquare(this.getSquare(s.getQ0()), s.getP0(), s.getP1());
            }
        }
    }

    @Override
    public void redo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            if (step.getType() == AbstractStep.EditType.STATE) {
                this.changeState(s.getPos(), s.getAfter());
            } else if (step.getType() == AbstractStep.EditType.NUMBER) {
                this.changeNumber(s.getPos(), s.getAfter());
            }
        } else if (step instanceof SquareEditStep) {
            SquareEditStep s = (SquareEditStep)step;
            if (s.getOperation() == 1) {
                this.addSquare(new Square(s.getQ0(), s.getQ1()));
            } else if (s.getOperation() == 0) {
                this.removeSquare(this.getSquare(s.getP0()));
            } else if (s.getOperation() == 2) {
                this.changeSquare(this.getSquare(s.getP0()), s.getQ0(), s.getQ1());
            }
        }
    }

    public void removeOverlappedSquares(Square sq, Square org) {
        for (Address p : sq.cellSet()) {
            Square s = this.getSquare(p);
            if (s == null || s == org) continue;
            this.removeSquare(s);
        }
    }

    public void setSquare(Square region, Square sq) {
        for (Address p : region.cellSet()) {
            this.setSquare(p, sq);
        }
    }

    public void addSquare(Square sq) {
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new SquareEditStep(sq.p0(), sq.p1(), 1));
        }
        this.setSquare(sq, sq);
        this.squareList.add(sq);
    }

    public void changeSquare(Square sq, Address q0, Address q1) {
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new SquareEditStep(sq.p0(), sq.p1(), q0, q1, 2));
        }
        this.setSquare(sq, null);
        sq.set(q0, q1);
        this.setSquare(sq, sq);
    }

    public void removeSquare(Square sq) {
        this.changeNumber(sq.p0(), -1);
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new SquareEditStep(sq.p0(), sq.p1(), 0));
        }
        this.setSquare(sq, null);
        this.squareList.remove(sq);
    }

    public void changeNumber(Address p, int n) {
        Square square = this.getSquare(p);
        if (square == null) {
            return;
        }
        int prev = square.getNumber();
        if (prev == n) {
            return;
        }
        square.setNumber(n);
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.NUMBER, p, prev, n));
        }
    }

    boolean isBlock(Address p) {
        int d = 0;
        while (d < 4) {
            if (this.isBlack(Address.nextCell(p, d))) {
                return true;
            }
            ++d;
        }
        return false;
    }

    void countContinuousRoom(Address p0, int dir) {
        int count = 0;
        Square sq = null;
        Address p = p0;
        while (this.isOn(p) && this.getState(p) != 1) {
            p = Address.nextCell(p, dir);
        }
        p = Address.nextCell(p, dir ^ 2);
        while (this.isOn(p) && this.getState(p) != 1) {
            Square room = this.getSquare(p);
            if (sq == null || room != sq) {
                ++count;
                sq = room;
            }
            p = Address.nextCell(p, dir ^ 2);
        }
        p = Address.nextCell(p, dir);
        while (this.isOn(p) && this.getState(p) != 1) {
            this.setCont(p, dir, count);
            p = Address.nextCell(p, dir);
        }
    }

    void countContinuousRoomW(Address p0, int dir) {
        int count = 0;
        Square sq = null;
        Address p = p0;
        while (this.isOn(p) && this.getState(p) == 2) {
            p = Address.nextCell(p, dir);
        }
        p = Address.nextCell(p, dir ^ 2);
        while (this.isOn(p) && this.getState(p) == 2) {
            Square room = this.getSquare(p);
            if (room != sq) {
                ++count;
                sq = room;
            }
            p = Address.nextCell(p, dir ^ 2);
        }
        p = Address.nextCell(p, dir);
        while (this.isOn(p) && this.getState(p) == 2) {
            this.setContW(p, dir, count);
            p = Address.nextCell(p, dir);
        }
    }

    void initChain() {
        Address p;
        this.maxChain = 1;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            this.setChain(p, 0);
            ++n2;
        }
        addressArray = this.cellAddrs();
        n = addressArray.length;
        n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            if (this.isOnPeriphery(p) && this.isBlack(p) && this.getChain(p) == 0 && this.initChain1(p, -1, 1) == -1) {
                this.updateChain(p, -1);
            }
            ++n2;
        }
        addressArray = this.cellAddrs();
        n = addressArray.length;
        n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            if (!this.isOnPeriphery(p) && this.isBlack(p) && this.getChain(p) == 0 && this.initChain1(p, -1, ++this.maxChain) == -1) {
                this.updateChain(p, -1);
            }
            ++n2;
        }
    }

    int initChain1(Address p, int d, int n) {
        if (n == 1 && d != -1 && this.isOnPeriphery(p)) {
            return -1;
        }
        if (n >= 0 && this.isOnPeriphery(p)) {
            this.setChain(p, 1);
        } else {
            this.setChain(p, n);
        }
        int[] nArray = Direction.DIAGONAL4;
        int n2 = Direction.DIAGONAL4.length;
        int n3 = 0;
        while (n3 < n2) {
            int dd = nArray[n3];
            Address pp = Address.nextCell(p, dd);
            if (dd != (d ^ 2) && this.isBlack(pp)) {
                if (this.getChain(pp) == n) {
                    return -1;
                }
                if (this.initChain1(pp, dd, n) == -1) {
                    return -1;
                }
            }
            ++n3;
        }
        return n;
    }

    void connectChain(Address p) {
        int[] adjacent = this.adjacentChain;
        int k = 0;
        int newChain = Integer.MAX_VALUE;
        if (this.isOnPeriphery(p)) {
            newChain = 1;
        }
        int[] nArray = Direction.DIAGONAL4;
        int n = Direction.DIAGONAL4.length;
        int n2 = 0;
        while (n2 < n) {
            int dd = nArray[n2];
            Address pp = Address.nextCell(p, dd);
            if (this.isBlack(pp)) {
                int c1 = this.getChain(pp);
                if (this.isOnPeriphery(p) && c1 == 1) {
                    newChain = -1;
                }
                adjacent[k] = c1;
                int l = 0;
                while (l < k) {
                    if (adjacent[k] == adjacent[l]) {
                        newChain = -1;
                    }
                    ++l;
                }
                ++k;
                if (c1 < newChain) {
                    newChain = c1;
                }
            }
            ++n2;
        }
        if (newChain == Integer.MAX_VALUE) {
            this.setChain(p, ++this.maxChain);
        } else {
            this.updateChain(p, newChain);
        }
    }

    void cutChain(Address p) {
        this.initChain();
    }

    void updateChain(Address p, int n) {
        this.setChain(p, n);
        int[] nArray = Direction.DIAGONAL4;
        int n2 = Direction.DIAGONAL4.length;
        int n3 = 0;
        while (n3 < n2) {
            int dd = nArray[n3];
            Address pp = Address.nextCell(p, dd);
            if (this.isBlack(pp) && this.getChain(pp) != n) {
                this.updateChain(pp, n);
            }
            ++n3;
        }
    }

    @Override
    public int checkAnswerCode() {
        Address p;
        int result = 0;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            if (this.getState(p) == 1) {
                if (this.isBlock(p)) {
                    result |= 1;
                }
                if (this.getChain(p) == -1) {
                    result |= 2;
                }
            }
            ++n2;
        }
        addressArray = this.cellAddrs();
        n = addressArray.length;
        n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            if (this.getCont(p, 1) >= 3 || this.getCont(p, 0) >= 3) {
                result |= 8;
            }
            ++n2;
        }
        for (Square sq : this.squareList) {
            if (sq.getNumber() < 0 || sq.getNumber() == sq.getNBlack()) continue;
            result |= 4;
        }
        return result;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return BoardBase.COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(Messages.getString("heyawake.AnswerCheckMessage1"));
        }
        if ((result & 2) == 2) {
            message.append(Messages.getString("heyawake.AnswerCheckMessage2"));
        }
        if ((result & 4) == 4) {
            message.append(Messages.getString("heyawake.AnswerCheckMessage3"));
        }
        if ((result & 8) == 8) {
            message.append(Messages.getString("heyawake.AnswerCheckMessage4"));
        }
        return message.toString();
    }
}

