/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.sudoku;

import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.resource.Messages;
import pencilbox.sudoku.DigitPatternHint;

public class Board
extends BoardBase {
    static final int UNKNOWN = 0;
    static final int BLANK = 0;
    static final int UNDETERMINED = -2;
    private int maxNumber;
    private int[][] state;
    private int[][] number;
    private int unit = 0;
    private int[][] multi;
    private DigitPatternHint hint;

    @Override
    protected void setup() {
        super.setup();
        this.maxNumber = this.rows();
        int s = 1;
        while (s < 10) {
            if (s * s == this.maxNumber) {
                this.unit = s;
                break;
            }
            ++s;
        }
        if (this.unit == 0) {
            throw new RuntimeException("\u4e0d\u6b63\u306a\u5927\u304d\u3055");
        }
        this.state = new int[this.maxNumber][this.maxNumber];
        this.number = new int[this.maxNumber][this.maxNumber];
        this.multi = new int[this.maxNumber][this.maxNumber];
        this.hint = new DigitPatternHint();
        this.hint.setupHint(this);
    }

    @Override
    public void clearBoard() {
        super.clearBoard();
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (!this.isStable(p)) {
                this.setState(p, 0);
            }
            ++n2;
        }
        this.initMulti();
        this.hint.initHint();
    }

    public int getMaxNumber() {
        return this.maxNumber;
    }

    int[][] getNumber() {
        return this.number;
    }

    int[][] getState() {
        return this.state;
    }

    public int getUnit() {
        return this.unit;
    }

    public boolean isStable(int r, int c) {
        return this.number[r][c] != 0;
    }

    public boolean isStable(Address pos) {
        return this.isStable(pos.r(), pos.c());
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public int getState(Address pos) {
        return this.getState(pos.r(), pos.c());
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public void setState(Address pos, int st) {
        this.setState(pos.r(), pos.c(), st);
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address p) {
        return this.number[p.r()][p.c()];
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public void setNumber(Address pos, int n) {
        this.setNumber(pos.r(), pos.c(), n);
    }

    public int getNumberOrState(Address p) {
        return this.isStable(p) ? this.getNumber(p) : this.getState(p);
    }

    public int getNumberOrState(int r, int c) {
        return this.isStable(r, c) ? this.getNumber(r, c) : this.getState(r, c);
    }

    @Override
    public void initBoard() {
        this.initMulti();
        this.hint.initHint();
    }

    int getPattern(Address p) {
        return this.hint.getPattern(p);
    }

    boolean canPlace(Address p, int n) {
        return this.getNumber(p) == 0 && this.hint.canPlace(p, n);
    }

    public void changeAnswerNumber(Address p, int n) {
        int prev = this.getState(p);
        if (n == prev) {
            return;
        }
        if (this.isStable(p)) {
            this.changeFixedNumber(p, 0);
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.NUMBER, p, prev, n));
        }
        this.changeNumber1(p, prev, n);
        this.setState(p, n);
    }

    public void changeFixedNumber(Address p, int n) {
        int prev = this.getNumber(p);
        if (n == prev) {
            return;
        }
        if (this.getState(p) > 0) {
            this.changeAnswerNumber(p, 0);
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.FIXED, p, prev, n));
        }
        this.changeNumber1(p, prev, n);
        this.setNumber(p, n);
    }

    private void changeNumber1(Address p, int prev, int n) {
        this.updateMulti(p, prev, n);
        this.hint.updateHint(p, n);
    }

    @Override
    public void undo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            if (s.getType() == AbstractStep.EditType.NUMBER) {
                this.changeAnswerNumber(s.getPos(), s.getBefore());
            } else if (s.getType() == AbstractStep.EditType.FIXED) {
                this.changeFixedNumber(s.getPos(), s.getBefore());
            }
        }
    }

    @Override
    public void redo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            if (s.getType() == AbstractStep.EditType.NUMBER) {
                this.changeAnswerNumber(s.getPos(), s.getAfter());
            } else if (s.getType() == AbstractStep.EditType.FIXED) {
                this.changeFixedNumber(s.getPos(), s.getAfter());
            }
        }
    }

    public boolean isMultipleNumber(Address p) {
        return this.multi[p.r()][p.c()] > 1;
    }

    void initMulti() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int n3 = this.getNumberOrState(p);
            if (n3 > 0) {
                this.multi[p.r()][p.c()] = 1;
                this.updateMulti1(p, n3, 1, 0);
            }
            ++n2;
        }
    }

    void updateMulti(Address p0, int prev, int n) {
        int c0;
        int r0 = p0.r();
        if (this.multi[r0][c0 = p0.c()] > 1) {
            this.updateMulti1(p0, prev, 0, -1);
        }
        if (n > 0) {
            this.multi[r0][c0] = 1;
            this.updateMulti1(p0, n, 1, 1);
        } else {
            this.multi[r0][c0] = 0;
        }
    }

    private void updateMulti1(Address p0, int num, int m, int k) {
        int r0 = p0.r();
        int c0 = p0.c();
        int c = 0;
        while (c < this.cols()) {
            if (c != c0 && this.getNumberOrState(r0, c) == num) {
                int[] nArray = this.multi[r0];
                int n = c;
                nArray[n] = nArray[n] + k;
                int[] nArray2 = this.multi[r0];
                int n2 = c0;
                nArray2[n2] = nArray2[n2] + m;
            }
            ++c;
        }
        int r = 0;
        while (r < this.rows()) {
            if (r != r0 && this.getNumberOrState(r, c0) == num) {
                int[] nArray = this.multi[r];
                int n = c0;
                nArray[n] = nArray[n] + k;
                int[] nArray3 = this.multi[r0];
                int n3 = c0;
                nArray3[n3] = nArray3[n3] + m;
            }
            ++r;
        }
        int unit = this.getUnit();
        int r2 = r0 - r0 % unit;
        while (r2 < r0 - r0 % unit + unit) {
            int c2 = c0 - c0 % unit;
            while (c2 < c0 - c0 % unit + unit) {
                if ((r2 != r0 || c2 != c0) && this.getNumberOrState(r2, c2) == num) {
                    int[] nArray = this.multi[r2];
                    int n = c2;
                    nArray[n] = nArray[n] + k;
                    int[] nArray4 = this.multi[r0];
                    int n4 = c0;
                    nArray4[n4] = nArray4[n4] + m;
                }
                ++c2;
            }
            ++r2;
        }
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.isMultipleNumber(p)) {
                result |= 1;
            }
            if (this.getNumberOrState(p) <= 0) {
                result |= 2;
            }
            ++n2;
        }
        return result;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        if (result == 2) {
            return Messages.getString("sudoku.AnswerCheckMessage2");
        }
        if ((result & 1) == 1) {
            return Messages.getString("sudoku.AnswerCheckMessage1");
        }
        return "";
    }

    @Override
    public void exchangeNumbers(int v1, int v2) {
        this.exchangeNumbers(new int[]{v1, v2}, new int[]{v2, v1});
    }

    public void exchangeNumbers(int[] a, int[] b) {
        Board board = this;
        board.startCompoundUndo();
        Address[] addressArray = board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            int k;
            int n3;
            Address p = addressArray[n2];
            if (board.isStable(p)) {
                n3 = board.getNumber(p);
                k = 0;
                while (k < a.length) {
                    if (n3 == a[k]) {
                        board.changeFixedNumber(p, b[k]);
                        break;
                    }
                    ++k;
                }
            } else {
                n3 = board.getState(p);
                k = 0;
                while (k < a.length) {
                    if (n3 == a[k]) {
                        board.changeAnswerNumber(p, b[k]);
                        break;
                    }
                    ++k;
                }
            }
            ++n2;
        }
        board.stopCompoundUndo();
    }
}

