/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.slalom;

import java.util.ArrayList;
import pencilbox.common.core.Address;
import pencilbox.common.io.PzprWriterBase;
import pencilbox.slalom.Board;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PzprWriter
extends PzprWriterBase {
    private Board bd;

    @Override
    protected String getPzprName() {
        return "slalom";
    }

    @Override
    protected void pzlexport() {
        this.bd = (Board)this.boardBase;
        this.outSize(this.bd.rows(), this.bd.cols());
        int ver = 1;
        if (ver == 1) {
            this.outpflag("p");
        }
        this.encodeSlalom(ver);
    }

    void encodeSlalom(int ver) {
        String pstr;
        String cm = "";
        int count = 0;
        int i = 0;
        while (i < this.rows * this.cols) {
            pstr = "";
            int n = this.QuC(i);
            if (n == 1) {
                pstr = "1";
            } else if (n == 21) {
                pstr = "2";
            } else if (n == 22) {
                pstr = "3";
            } else {
                pstr = "";
                ++count;
            }
            if (count == 0) {
                cm = String.valueOf(cm) + pstr;
            } else if (pstr.length() > 0 || count == 32) {
                cm = String.valueOf(cm) + PzprWriter.toString(3 + count, 36) + pstr;
                count = 0;
            }
            ++i;
        }
        if (count > 0) {
            cm = String.valueOf(cm) + PzprWriter.toString(3 + count, 36);
        }
        this.bd.initBoard();
        count = 0;
        if (ver == 0) {
            ArrayList<Address> gateList = this.makeGateList();
            int r = 0;
            while (r < this.bd.getNGate()) {
                String pstr2 = "";
                int val = this.bd.getGateNumber(gateList.get(r));
                if (val >= 1 && val < 16) {
                    pstr2 = PzprWriter.toString(val, 16);
                } else if (val >= 16 && val < 256) {
                    pstr2 = "-" + PzprWriter.toString(val, 16);
                } else {
                    ++count;
                }
                if (count == 0) {
                    cm = String.valueOf(cm) + pstr2;
                } else if (pstr2.length() > 0 || count == 20) {
                    cm = String.valueOf(cm) + PzprWriter.toString(15 + count, 36) + pstr2;
                    count = 0;
                }
                ++r;
            }
            if (count > 0) {
                cm = String.valueOf(cm) + PzprWriter.toString(15 + count, 36);
            }
        } else if (ver == 1) {
            int c = 0;
            while (c < this.rows * this.cols) {
                if (this.QuC(c) == 1) {
                    pstr = "";
                    int val = this.QnC(c);
                    if (val >= 1 && val < 16) {
                        pstr = PzprWriter.toString(val, 16);
                    } else if (val >= 16 && val < 256) {
                        pstr = "-" + PzprWriter.toString(val, 16);
                    } else {
                        ++count;
                    }
                    if (count == 0) {
                        cm = String.valueOf(cm) + pstr;
                    } else if (pstr.length() > 0 || count == 20) {
                        cm = String.valueOf(cm) + PzprWriter.toString(15 + count, 36) + pstr;
                        count = 0;
                    }
                }
                ++c;
            }
            if (count > 0) {
                cm = String.valueOf(cm) + PzprWriter.toString(15 + count, 36);
            }
        }
        int startid = this.a2i(this.bd.getGoal());
        if (this.bd.getGoal().isNowhere()) {
            startid = 0;
        }
        cm = String.valueOf(cm) + "/" + startid;
        this.outbstr(cm);
    }

    private ArrayList<Address> makeGateList() {
        ArrayList<Address> gateList = new ArrayList<Address>();
        int r = 0;
        while (r < this.bd.rows()) {
            int c = 0;
            while (c < this.bd.cols()) {
                Address aa;
                Address a = Address.address(r, c);
                int n = this.bd.getNumber(a);
                if (n == -4) {
                    aa = Address.nextCell(a, 1);
                    if (!this.bd.isOn(aa) || this.bd.getNumber(aa) != -4) {
                        gateList.add(a);
                    }
                } else if (!(n != -5 || this.bd.isOn(aa = Address.nextCell(a, 0)) && this.bd.getNumber(aa) == -5)) {
                    gateList.add(a);
                }
                ++c;
            }
            ++r;
        }
        return gateList;
    }

    @Override
    protected int QuC(int i) {
        int n = this.bd.getNumber(this.i2a(i));
        if (n >= 0) {
            return 1;
        }
        if (n == -5) {
            return 21;
        }
        if (n == -4) {
            return 22;
        }
        return 0;
    }

    @Override
    protected int QnC(int i) {
        int n = this.bd.getNumber(this.i2a(i));
        if (n > 0) {
            return n;
        }
        if (n == 0) {
            return -2;
        }
        return -1;
    }
}

